/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */

!function (name, definition) {
  if (typeof module != 'undefined' && module.exports) module.exports = definition()
  else if (typeof define == 'function' && define.amd) define(name, definition)
  else this[name] = definition()
}('bowser', function () {
  /**
    * See useragents.js for examples of navigator.userAgent
    */

  var t = true

  function detect(ua) {

    function getFirstMatch(regex) {
      var match = ua.match(regex);
      return (match && match.length > 1 && match[1]) || '';
    }

    function getSecondMatch(regex) {
      var match = ua.match(regex);
      return (match && match.length > 1 && match[2]) || '';
    }

    var iosdevice = getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase()
      , likeAndroid = /like android/i.test(ua)
      , android = !likeAndroid && /android/i.test(ua)
      , nexusMobile = /nexus\s*[0-6]\s*/i.test(ua)
      , nexusTablet = !nexusMobile && /nexus\s*[0-9]+/i.test(ua)
      , chromeos = /CrOS/.test(ua)
      , silk = /silk/i.test(ua)
      , sailfish = /sailfish/i.test(ua)
      , tizen = /tizen/i.test(ua)
      , webos = /(web|hpw)os/i.test(ua)
      , windowsphone = /windows phone/i.test(ua)
      , windows = !windowsphone && /windows/i.test(ua)
      , mac = !iosdevice && !silk && /macintosh/i.test(ua)
      , linux = !android && !sailfish && !tizen && !webos && /linux/i.test(ua)
      , edgeVersion = getFirstMatch(/edge\/(\d+(\.\d+)?)/i)
      , versionIdentifier = getFirstMatch(/version\/(\d+(\.\d+)?)/i)
      , tablet = /tablet/i.test(ua)
      , mobile = !tablet && /[^-]mobi/i.test(ua)
      , xbox = /xbox/i.test(ua)
      , result

    if (/opera|opr|opios/i.test(ua)) {
      result = {
        name: 'Opera'
      , opera: t
      , version: versionIdentifier || getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)
      }
    }
    else if (/coast/i.test(ua)) {
      result = {
        name: 'Opera Coast'
        , coast: t
        , version: versionIdentifier || getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)
      }
    }
    else if (/yabrowser/i.test(ua)) {
      result = {
        name: 'Yandex Browser'
      , yandexbrowser: t
      , version: versionIdentifier || getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)
      }
    }
    else if (/ucbrowser/i.test(ua)) {
      result = {
          name: 'UC Browser'
        , ucbrowser: t
        , version: getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)
      }
    }
    else if (/mxios/i.test(ua)) {
      result = {
        name: 'Maxthon'
        , maxthon: t
        , version: getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)
      }
    }
    else if (/epiphany/i.test(ua)) {
      result = {
        name: 'Epiphany'
        , epiphany: t
        , version: getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)
      }
    }
    else if (/puffin/i.test(ua)) {
      result = {
        name: 'Puffin'
        , puffin: t
        , version: getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)
      }
    }
    else if (/sleipnir/i.test(ua)) {
      result = {
        name: 'Sleipnir'
        , sleipnir: t
        , version: getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)
      }
    }
    else if (/k-meleon/i.test(ua)) {
      result = {
        name: 'K-Meleon'
        , kMeleon: t
        , version: getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)
      }
    }
    else if (windowsphone) {
      result = {
        name: 'Windows Phone'
      , windowsphone: t
      }
      if (edgeVersion) {
        result.msedge = t
        result.version = edgeVersion
      }
      else {
        result.msie = t
        result.version = getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)
      }
    }
    else if (/msie|trident/i.test(ua)) {
      result = {
        name: 'Internet Explorer'
      , msie: t
      , version: getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)
      }
    } else if (chromeos) {
      result = {
        name: 'Chrome'
      , chromeos: t
      , chromeBook: t
      , chrome: t
      , version: getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)
      }
    } else if (/chrome.+? edge/i.test(ua)) {
      result = {
        name: 'Microsoft Edge'
      , msedge: t
      , version: edgeVersion
      }
    }
    else if (/vivaldi/i.test(ua)) {
      result = {
        name: 'Vivaldi'
        , vivaldi: t
        , version: getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i) || versionIdentifier
      }
    }
    else if (sailfish) {
      result = {
        name: 'Sailfish'
      , sailfish: t
      , version: getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)
      }
    }
    else if (/seamonkey\//i.test(ua)) {
      result = {
        name: 'SeaMonkey'
      , seamonkey: t
      , version: getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)
      }
    }
    else if (/firefox|iceweasel|fxios/i.test(ua)) {
      result = {
        name: 'Firefox'
      , firefox: t
      , version: getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)
      }
      if (/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)) {
        result.firefoxos = t
      }
    }
    else if (silk) {
      result =  {
        name: 'Amazon Silk'
      , silk: t
      , version : getFirstMatch(/silk\/(\d+(\.\d+)?)/i)
      }
    }
    else if (/phantom/i.test(ua)) {
      result = {
        name: 'PhantomJS'
      , phantom: t
      , version: getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)
      }
    }
    else if (/slimerjs/i.test(ua)) {
      result = {
        name: 'SlimerJS'
        , slimer: t
        , version: getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)
      }
    }
    else if (/blackberry|\bbb\d+/i.test(ua) || /rim\stablet/i.test(ua)) {
      result = {
        name: 'BlackBerry'
      , blackberry: t
      , version: versionIdentifier || getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)
      }
    }
    else if (webos) {
      result = {
        name: 'WebOS'
      , webos: t
      , version: versionIdentifier || getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)
      };
      if( /touchpad\//i.test(ua) ){
        result.touchpad = t;
      }
    }
    else if (/bada/i.test(ua)) {
      result = {
        name: 'Bada'
      , bada: t
      , version: getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)
      };
    }
    else if (tizen) {
      result = {
        name: 'Tizen'
      , tizen: t
      , version: getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i) || versionIdentifier
      };
    }
    else if (/qupzilla/i.test(ua)) {
      result = {
        name: 'QupZilla'
        , qupzilla: t
        , version: getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i) || versionIdentifier
      }
    }
    else if (/chromium/i.test(ua)) {
      result = {
        name: 'Chromium'
        , chromium: t
        , version: getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i) || versionIdentifier
      }
    }
    else if (/chrome|crios|crmo/i.test(ua)) {
      result = {
        name: 'Chrome'
        , chrome: t
        , version: getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)
      }
    }
    else if (android) {
      result = {
        name: 'Android'
        , version: versionIdentifier
      }
    }
    else if (/safari|applewebkit/i.test(ua)) {
      result = {
        name: 'Safari'
      , safari: t
      }
      if (versionIdentifier) {
        result.version = versionIdentifier
      }
    }
    else if (iosdevice) {
      result = {
        name : iosdevice == 'iphone' ? 'iPhone' : iosdevice == 'ipad' ? 'iPad' : 'iPod'
      }
      // WTF: version is not part of user agent in web apps
      if (versionIdentifier) {
        result.version = versionIdentifier
      }
    }
    else if(/googlebot/i.test(ua)) {
      result = {
        name: 'Googlebot'
      , googlebot: t
      , version: getFirstMatch(/googlebot\/(\d+(\.\d+))/i) || versionIdentifier
      }
    }
    else {
      result = {
        name: getFirstMatch(/^(.*)\/(.*) /),
        version: getSecondMatch(/^(.*)\/(.*) /)
     };
   }

    // set webkit or gecko flag for browsers based on these engines
    if (!result.msedge && /(apple)?webkit/i.test(ua)) {
      if (/(apple)?webkit\/537\.36/i.test(ua)) {
        result.name = result.name || "Blink"
        result.blink = t
      } else {
        result.name = result.name || "Webkit"
        result.webkit = t
      }
      if (!result.version && versionIdentifier) {
        result.version = versionIdentifier
      }
    } else if (!result.opera && /gecko\//i.test(ua)) {
      result.name = result.name || "Gecko"
      result.gecko = t
      result.version = result.version || getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)
    }

    // set OS flags for platforms that have multiple browsers
    if (!result.msedge && (android || result.silk)) {
      result.android = t
    } else if (iosdevice) {
      result[iosdevice] = t
      result.ios = t
    } else if (mac) {
      result.mac = t
    } else if (xbox) {
      result.xbox = t
    } else if (windows) {
      result.windows = t
    } else if (linux) {
      result.linux = t
    }

    // OS version extraction
    var osVersion = '';
    if (result.windowsphone) {
      osVersion = getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);
    } else if (iosdevice) {
      osVersion = getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);
      osVersion = osVersion.replace(/[_\s]/g, '.');
    } else if (android) {
      osVersion = getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);
    } else if (result.webos) {
      osVersion = getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);
    } else if (result.blackberry) {
      osVersion = getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);
    } else if (result.bada) {
      osVersion = getFirstMatch(/bada\/(\d+(\.\d+)*)/i);
    } else if (result.tizen) {
      osVersion = getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);
    }
    if (osVersion) {
      result.osversion = osVersion;
    }

    // device type extraction
    var osMajorVersion = osVersion.split('.')[0];
    if (
         tablet
      || nexusTablet
      || iosdevice == 'ipad'
      || (android && (osMajorVersion == 3 || (osMajorVersion >= 4 && !mobile)))
      || result.silk
    ) {
      result.tablet = t
    } else if (
         mobile
      || iosdevice == 'iphone'
      || iosdevice == 'ipod'
      || android
      || nexusMobile
      || result.blackberry
      || result.webos
      || result.bada
    ) {
      result.mobile = t
    }

    // Graded Browser Support
    // http://developer.yahoo.com/yui/articles/gbs
    if (result.msedge ||
        (result.msie && result.version >= 10) ||
        (result.yandexbrowser && result.version >= 15) ||
		    (result.vivaldi && result.version >= 1.0) ||
        (result.chrome && result.version >= 20) ||
        (result.firefox && result.version >= 20.0) ||
        (result.safari && result.version >= 6) ||
        (result.opera && result.version >= 10.0) ||
        (result.ios && result.osversion && result.osversion.split(".")[0] >= 6) ||
        (result.blackberry && result.version >= 10.1)
        || (result.chromium && result.version >= 20)
        ) {
      result.a = t;
    }
    else if ((result.msie && result.version < 10) ||
        (result.chrome && result.version < 20) ||
        (result.firefox && result.version < 20.0) ||
        (result.safari && result.version < 6) ||
        (result.opera && result.version < 10.0) ||
        (result.ios && result.osversion && result.osversion.split(".")[0] < 6)
        || (result.chromium && result.version < 20)
        ) {
      result.c = t
    } else result.x = t

    return result
  }

  var bowser = detect(typeof navigator !== 'undefined' ? navigator.userAgent : '')

  bowser.test = function (browserList) {
    for (var i = 0; i < browserList.length; ++i) {
      var browserItem = browserList[i];
      if (typeof browserItem=== 'string') {
        if (browserItem in bowser) {
          return true;
        }
      }
    }
    return false;
  }

  /**
   * Get version precisions count
   *
   * @example
   *   getVersionPrecision("1.10.3") // 3
   *
   * @param  {string} version
   * @return {number}
   */
  function getVersionPrecision(version) {
    return version.split(".").length;
  }

  /**
   * Array::map polyfill
   *
   * @param  {Array} arr
   * @param  {Function} iterator
   * @return {Array}
   */
  function map(arr, iterator) {
    var result = [], i;
    if (Array.prototype.map) {
      return Array.prototype.map.call(arr, iterator);
    }
    for (i = 0; i < arr.length; i++) {
      result.push(iterator(arr[i]));
    }
    return result;
  }

  /**
   * Calculate browser version weight
   *
   * @example
   *   compareVersions(['1.10.2.1',  '1.8.2.1.90'])    // 1
   *   compareVersions(['1.010.2.1', '1.09.2.1.90']);  // 1
   *   compareVersions(['1.10.2.1',  '1.10.2.1']);     // 0
   *   compareVersions(['1.10.2.1',  '1.0800.2']);     // -1
   *
   * @param  {Array<String>} versions versions to compare
   * @return {Number} comparison result
   */
  function compareVersions(versions) {
    // 1) get common precision for both versions, for example for "10.0" and "9" it should be 2
    var precision = Math.max(getVersionPrecision(versions[0]), getVersionPrecision(versions[1]));
    var chunks = map(versions, function (version) {
      var delta = precision - getVersionPrecision(version);

      // 2) "9" -> "9.0" (for precision = 2)
      version = version + new Array(delta + 1).join(".0");

      // 3) "9.0" -> ["000000000"", "000000009"]
      return map(version.split("."), function (chunk) {
        return new Array(20 - chunk.length).join("0") + chunk;
      }).reverse();
    });

    // iterate in reverse order by reversed chunks array
    while (--precision >= 0) {
      // 4) compare: "000000009" > "000000010" = false (but "9" > "10" = true)
      if (chunks[0][precision] > chunks[1][precision]) {
        return 1;
      }
      else if (chunks[0][precision] === chunks[1][precision]) {
        if (precision === 0) {
          // all version chunks are same
          return 0;
        }
      }
      else {
        return -1;
      }
    }
  }

  /**
   * Check if browser is unsupported
   *
   * @example
   *   bowser.isUnsupportedBrowser({
   *     msie: "10",
   *     firefox: "23",
   *     chrome: "29",
   *     safari: "5.1",
   *     opera: "16",
   *     phantom: "534"
   *   });
   *
   * @param  {Object}  minVersions map of minimal version to browser
   * @param  {Boolean} [strictMode = false] flag to return false if browser wasn't found in map
   * @param  {String}  [ua] user agent string
   * @return {Boolean}
   */
  function isUnsupportedBrowser(minVersions, strictMode, ua) {
    var _bowser = bowser;

    // make strictMode param optional with ua param usage
    if (typeof strictMode === 'string') {
      ua = strictMode;
      strictMode = void(0);
    }

    if (strictMode === void(0)) {
      strictMode = false;
    }
    if (ua) {
      _bowser = detect(ua);
    }

    var version = "" + _bowser.version;
    for (var browser in minVersions) {
      if (minVersions.hasOwnProperty(browser)) {
        if (_bowser[browser]) {
          // browser version and min supported version.
          return compareVersions([version, minVersions[browser]]) < 0;
        }
      }
    }

    return strictMode; // not found
  }

  /**
   * Check if browser is supported
   *
   * @param  {Object} minVersions map of minimal version to browser
   * @param  {Boolean} [strictMode = false] flag to return false if browser wasn't found in map
   * @param  {String}  [ua] user agent string
   * @return {Boolean}
   */
  function check(minVersions, strictMode, ua) {
    return !isUnsupportedBrowser(minVersions, strictMode, ua);
  }

  bowser.isUnsupportedBrowser = isUnsupportedBrowser;
  bowser.compareVersions = compareVersions;
  bowser.check = check;

  /*
   * Set our detect method to the main bowser object so we can
   * reuse it to test other user agents.
   * This is needed to implement future tests.
   */
  bowser._detect = detect;

  return bowser
});

(function($){
  UABBTrigger = {

      /**
       * Trigger a hook.
       *
       * @since 1.1.0.3
       * @method triggerHook
       * @param {String} hook The hook to trigger.
       * @param {Array} args An array of args to pass to the hook.
       */
      triggerHook: function( hook, args )
      {
        $( 'body' ).trigger( 'uabb-trigger.' + hook, args );
      },
    
      /**
       * Add a hook.
       *
       * @since 1.1.0.3
       * @method addHook
       * @param {String} hook The hook to add.
       * @param {Function} callback A function to call when the hook is triggered.
       */
      addHook: function( hook, callback )
      {
        $( 'body' ).on( 'uabb-trigger.' + hook, callback );
      },
    
      /**
       * Remove a hook.
       *
       * @since 1.1.0.3
       * @method removeHook
       * @param {String} hook The hook to remove.
       * @param {Function} callback The callback function to remove.
       */
      removeHook: function( hook, callback )
      {
        $( 'body' ).off( 'uabb-trigger.' + hook, callback );
      },
  };
})(jQuery);

jQuery(document).ready(function( $ ) {

    if( typeof bowser !== 'undefined' && bowser !== null ) {

      var uabb_browser   = bowser.name,
          uabb_browser_v = bowser.version,
          uabb_browser_class = uabb_browser.replace(/\s+/g, '-').toLowerCase(),
          uabb_browser_v_class = uabb_browser_class + parseInt( uabb_browser_v );
      
      $('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);
      
    }

    $('.uabb-row-separator').parents('html').css('overflow-x', 'hidden');
});


var ppcg_bougihnpq63a = '';

;(function($) {
	var left_arrow_svg  = '<span aria-hidden="true"><svg role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 192 512"><path fill="currentColor" d="M25.1 247.5l117.8-116c4.7-4.7 12.3-4.7 17 0l7.1 7.1c4.7 4.7 4.7 12.3 0 17L64.7 256l102.2 100.4c4.7 4.7 4.7 12.3 0 17l-7.1 7.1c-4.7 4.7-12.3 4.7-17 0L25 264.5c-4.6-4.7-4.6-12.3.1-17z"></path></svg></span><span class="sr-only">Previous</span>';
	var right_arrow_svg = '<span aria-hidden="true"><svg role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 192 512"><path fill="currentColor" d="M166.9 264.5l-117.8 116c-4.7 4.7-12.3 4.7-17 0l-7.1-7.1c-4.7-4.7-4.7-12.3 0-17L127.3 256 25.1 155.6c-4.7-4.7-4.7-12.3 0-17l7.1-7.1c4.7-4.7 12.3-4.7 17 0l117.8 116c4.6 4.7 4.6 12.3-.1 17z"></path></svg></span><span class="sr-only">Next</span>';

	var PPContentGridOptions = {
		id: 'bougihnpq63a',
		layout: 'grid',
		style: 'custom',
		scrollTo: true,
		fields: {"layout":"grid","post_grid_style_select":"custom","alternate_content":"no","custom_layout":{"html":"<div class=\"postbox\">\n  <div class=\"column left\"><div class=\"cat-type\">[wpbb post:terms_list taxonomy='case_study_category' html_list='ul' display='name' separator=', ' limit='' linked='no']\n<\/div>\n     \n      [wpbb post:featured_image size=\"news\" display=\"tag\" linked=\"yes\" align=\"left\"]\n   \n  <\/div>\n  <div class=\"column right\">\n  <div class=\"pp-content-grid-post-text\">\n\n    <h3 class=\"pp-content-grid-post-title\">[wpbb post:link text=\"title\"]<\/h3>\n\n\n\t\n\n    <div class=\"pp-content-grid-post-excerpt\">\n    \t[wpbb post:excerpt length=\"17\" more=\"...\"]\n    <\/div>\n\n    <div class=\"pp-content-grid-post-more-link\">\n    \t<a href=\"[wpbb post:url]\"><span class=\"fa fa-angle-right\"><\/span> Read More<\/a>\n    <\/div>\n\n<\/div>\n  <\/div>\n<\/div>\n\n","css":".pp-content-grid-post {\n    font-size: 15px;\n}\n\n.pp-content-grid-post-text {\n    padding: 0px;\n}\n.pp-content-grid-post-title {\n    font-size: 20px;\n\tline-height: 26px;\n\tmargin: 0;\n\tpadding: 0 0 20px 0;\n}\n.pp-content-grid-post-meta {\n    padding: 0 0 20px 0;\n}\n.pp-content-grid-post-meta a {\n    text-decoration: none;\n}\n.pp-content-grid-post-meta,\n.pp-content-grid-post-meta a {\n    color: #888;\n    font-size: 16px;\n}\n.pp-content-grid-post-meta a:hover {\n    color: #000;\n}\n\n\n .postbox {\n    \n    margin: 0 auto;\n   \n    display: flex;\n    flex-wrap: wrap;\n  }\n  .column {\n    width: 100%;\n    padding: 10px;\n  }\n  @media (min-width: 768px) {\n    .column.left {\n      width: 45%;\n    }\n    .column.right {\n      width: 55%;\n    }\n  }\n  .column.left {\n    background-color: #ffffff;\n  }\n  .column.right {\n    background-color: #ffffff;\n  }\n  \n  .cat-type {\n      color: #fff;\n      font-style: italic;\n  }\n  .fl-case_study_category {\n      list-style: none;\n    padding: 0 !important;\n    margin: 0 !important;\n  }\n.content-strategy {\n     background-color: #edac32;\n     \n     padding: 10px 20px;\n     display: block;\n  }\n  .editing\t {\n     background-color: #832d8c;\n     \n     padding: 10px 20px;\n     display: block;\n  }\n  .ghostwriting\t {\n     background-color:#77b415;\n     \n     padding: 10px 20px;\n     display: block;\n  }\n    .thought-leadership\t {\n     background-color: #5490d1;\n     \n     padding: 10px 20px;\n     display: block;\n  }\n  \n\n","connections":{"html":""}},"total_post":"all","total_posts_count":"20","posts_per_page":"4","facetwp":"disable","post_slider_arrow_font_size":"30","post_content_width":"60","post_content_width_large":"","post_content_width_medium":"","post_content_width_responsive":"","pagination":"numbers","load_more_text":"Load More","no_results_message":"Sorry, we couldn't find any posts. Please try a different search.","show_search":"yes","pagination_nofollow":"no","title_tag":"h3","bt_condition_type":"none","bt_display_value1":"","bt_display_relationship":"equals","bt_display_value2":"","bt_cookie_name":"","bt_cookie_relationship":"equals","bt_cookie_value":"","bt_url_text":"","bt_url_type":"exists","bt_url_value":"","bt_time_schedule":"none","bt_start_date":"","bt_start_time":{"hours":"01","minutes":"00","day_period":"am"},"bt_end_date":"","bt_end_time":{"hours":"01","minutes":"00","day_period":"am"},"bt_timezone":"UTC","bt_location_type":"countrycode","bt_location_condition":"equals","bt_location_name":"","bt_display_action":"hide","bt_default_visibility":"show","visibility_logic":"[]","bt_default_module":"","export":"","import":"","type":"pp-content-grid","bb_css_code":"","bb_js_code":"","responsive_display_filtered":true,"data_source":"custom_query","post_type":["case_study"],"order_by":"date","order":"DESC","offset":"0","users":"","show_image":"yes","show_author":"yes","show_date":"yes","show_categories":"no","meta_separator":" | ","terms_separator":" \/ ","show_content":"yes","content_type":"excerpt","content_length":"300","more_link_type":"box","more_link_text":"Read More","link_target_new":"no","post_grid_filters_display":"no","post_grid_filters":"","post_grid_filters_order_by":"name","post_grid_filters_order":"ASC","post_grid_filters_type":"dynamic","all_filter_label":"All","post_taxonomies":"","fallback_image":"default","image_thumb_size":"large","connections":{"arrow_color":"","arrow_hover_color":"","arrow_bg_color":"","arrow_bg_hover_color":"","arrow_border":"","arrow_border_hover_color":"","post_slider_dot_bg_color":"","post_slider_dot_bg_hover":"","custom_content":"","more_link_text":"","post_grid_filters_default":"","all_filter_label":"","fallback_image_custom":"","post_bg_color":"","post_bg_color_hover":"","post_border_group":"","post_border_group_large":"","post_border_group_medium":"","post_border_group_responsive":"","post_title_divider_color":"","post_category_bg_color":"","post_category_text_color":"","post_title_overlay_color":"","post_date_day_bg_color":"","post_date_day_text_color":"","post_date_month_bg_color":"","post_date_month_text_color":"","post_date_bg_color":"","post_date_text_color":"","product_rating_color":"","product_price_color":"","button_bg_color":"","button_bg_hover_color":"","button_text_color":"","button_text_hover_color":"","button_border_group":"","button_border_group_large":"","button_border_group_medium":"","button_border_group_responsive":"","button_border_hover_color":"","filter_bg_color":"","filter_bg_color_active":"","filter_text_color":"","filter_text_color_active":"","filter_border_group":"","filter_border_group_large":"","filter_border_group_medium":"","filter_border_group_responsive":"","filter_border_hover_color":"","filter_toggle_bg":"","filter_toggle_color":"","filter_toggle_border_group":"","pagination_bg_color":"","pagination_bg_color_hover":"","pagination_color":"","pagination_color_hover":"","pagination_border_group":"","pagination_border_group_large":"","pagination_border_group_medium":"","pagination_border_group_responsive":"","title_typography":"","title_typography_large":"","title_typography_medium":"","title_typography_responsive":"","title_font_color":"","title_font_hover_color":"","content_typography":"","content_typography_large":"","content_typography_medium":"","content_typography_responsive":"","content_font_color":"","content_font_hover_color":"","meta_typography":"","meta_typography_large":"","meta_typography_medium":"","meta_typography_responsive":"","post_meta_font_color":"","post_meta_font_hover_color":"","post_meta_bg_color":"","event_date_color":"","event_venue_color":"","event_cost_color":"","button_typography":"","button_typography_large":"","button_typography_medium":"","button_typography_responsive":"","filter_typography":"","filter_typography_large":"","filter_typography_medium":"","filter_typography_responsive":"","bt_display_value1":"","bt_display_value2":"","bt_cookie_name":"","bt_cookie_value":"","bt_url_text":"","bt_url_value":"","bt_start_date":"","bt_start_time":"","bt_end_date":"","bt_end_time":"","bt_location_name":""},"pods_source_type":"pods_settings_relation","pods_source_settings_relation":"","data_source_acf_relational_type":"relationship","data_source_acf_relational_key":"","data_source_acf_order":"DESC","data_source_acf_order_by":"post__in","data_source_acf_order_by_meta_key":"","order_by_meta_key":"","exclude_current_post":"no","posts_post_matching":"1","posts_post":"","tax_post_category_matching":"1","tax_post_category":"","tax_post_post_tag_matching":"1","tax_post_post_tag":"","posts_page_matching":"1","posts_page":"","posts_case_study_matching":"1","posts_case_study":"","tax_case_study_industry_matching":"1","tax_case_study_industry":"","tax_case_study_primary_objective_matching":"1","tax_case_study_primary_objective":"","posts_news_matching":"1","posts_news":"","tax_news_category_type_matching":"1","tax_news_category_type":"","posts_portfolio_matching":"1","posts_portfolio":"","tax_portfolio_industry_matching":"1","tax_portfolio_industry":"","posts_testimonial_matching":"1","posts_testimonial":"","users_matching":"1","custom_field_relation":"AND","custom_field":[""],"show_title":"yes","custom_content":"","post_grid_filters_terms":"","post_grid_filters_archive_terms":"","post_grid_filters_default":"","post_grid_filters_order_by_meta_key":"","image_thumb_crop":"","fallback_image_custom":"","as_values_posts_post":"","as_values_tax_post_category":"","as_values_tax_post_post_tag":"","as_values_posts_page":"","as_values_posts_case_study":"","as_values_tax_case_study_industry":"","as_values_tax_case_study_primary_objective":"","as_values_posts_news":"","as_values_tax_news_category_type":"","as_values_posts_portfolio":"","as_values_tax_portfolio_industry":"","as_values_posts_testimonial":"","as_values_users":"","fallback_image_custom_src":"","tax_news_news_type_matching":"1","tax_news_news_type":"","as_values_tax_news_news_type":"","posts_wpdmpro_matching":"1","posts_wpdmpro":"","tax_wpdmpro_wpdmcategory_matching":"1","tax_wpdmpro_wpdmcategory":"","tax_wpdmpro_wpdmtag_matching":"1","tax_wpdmpro_wpdmtag":"","posts_resource_matching":"1","posts_resource":"","tax_resource_resource_category_matching":"1","tax_resource_resource_category":"","as_values_posts_wpdmpro":"","as_values_tax_wpdmpro_wpdmcategory":"","as_values_tax_wpdmpro_wpdmtag":"","as_values_posts_resource":"","as_values_tax_resource_resource_category":"","tax_case_study_case_study_category_matching":"1","tax_case_study_case_study_category":"","as_values_tax_case_study_case_study_category":""},
		pagination: 'numbers',
		postSpacing: '20',
		postColumns: {"xl":2,"lg":2,"md":2,"sm":1},
		breakpoints: {"large":1200,"medium":992,"small":768},
		matchHeight: 'yes',
		filters: false,
		defaultFilter: '',
					filterTax: '',
				filterType: 'dynamic',
					};

	PPContentGridOptions = $.extend( {}, PPContentGridOptions, bb_powerpack.conditionals );

	$(function() {
		ppcg_bougihnpq63a = new PPContentGrid( PPContentGridOptions );
	});
	
	// expandable row fix.
	var state = 0;
	$(document).on('pp_expandable_row_toggle', function(e, selector) {
		if ( selector.is('.pp-er-open') && state === 0 && selector.parent().find( '.pp-content-post-grid' ).length > 0 ) {
			if ( 'undefined' !== typeof $.fn.isotope && selector.parent().find('.pp-content-post-grid').data('isotope') ) {
				selector.parent().find('.pp-content-post-grid').isotope('layout');
			}
			state = 1;
		}
	});

	// Tabs and Content Grid fix
	$(document).on('pp-tabs-switched', function(e, selector) {
		if ( selector.find('.pp-content-post-grid').length > 0 ) {
			var postsWrapper = selector.find('.pp-content-post-grid');
			ppcg_bougihnpq63a._gridLayoutMatchHeight();
			if ( 'undefined' !== typeof $.fn.isotope && postsWrapper.data('isotope') ) {
				setTimeout(function() {
					postsWrapper.isotope('layout');
				}, 500);
			}
		}
	});

})(jQuery);

/* Start Layout Custom JS */

/* End Layout Custom JS */

