/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */!function(name,definition){if(typeof module!='undefined'&&module.exports)module.exports=definition()
else if(typeof define=='function'&&define.amd)define(name,definition)
else this[name]=definition()}('bowser',function(){var t=true
function detect(ua){function getFirstMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[1])||'';}
function getSecondMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[2])||'';}
var iosdevice=getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),likeAndroid=/like android/i.test(ua),android=!likeAndroid&&/android/i.test(ua),nexusMobile=/nexus\s*[0-6]\s*/i.test(ua),nexusTablet=!nexusMobile&&/nexus\s*[0-9]+/i.test(ua),chromeos=/CrOS/.test(ua),silk=/silk/i.test(ua),sailfish=/sailfish/i.test(ua),tizen=/tizen/i.test(ua),webos=/(web|hpw)os/i.test(ua),windowsphone=/windows phone/i.test(ua),windows=!windowsphone&&/windows/i.test(ua),mac=!iosdevice&&!silk&&/macintosh/i.test(ua),linux=!android&&!sailfish&&!tizen&&!webos&&/linux/i.test(ua),edgeVersion=getFirstMatch(/edge\/(\d+(\.\d+)?)/i),versionIdentifier=getFirstMatch(/version\/(\d+(\.\d+)?)/i),tablet=/tablet/i.test(ua),mobile=!tablet&&/[^-]mobi/i.test(ua),xbox=/xbox/i.test(ua),result
if(/opera|opr|opios/i.test(ua)){result={name:'Opera',opera:t,version:versionIdentifier||getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}}
else if(/coast/i.test(ua)){result={name:'Opera Coast',coast:t,version:versionIdentifier||getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}}
else if(/yabrowser/i.test(ua)){result={name:'Yandex Browser',yandexbrowser:t,version:versionIdentifier||getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}}
else if(/ucbrowser/i.test(ua)){result={name:'UC Browser',ucbrowser:t,version:getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/mxios/i.test(ua)){result={name:'Maxthon',maxthon:t,version:getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/epiphany/i.test(ua)){result={name:'Epiphany',epiphany:t,version:getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/puffin/i.test(ua)){result={name:'Puffin',puffin:t,version:getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}}
else if(/sleipnir/i.test(ua)){result={name:'Sleipnir',sleipnir:t,version:getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/k-meleon/i.test(ua)){result={name:'K-Meleon',kMeleon:t,version:getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(windowsphone){result={name:'Windows Phone',windowsphone:t}
if(edgeVersion){result.msedge=t
result.version=edgeVersion}
else{result.msie=t
result.version=getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)}}
else if(/msie|trident/i.test(ua)){result={name:'Internet Explorer',msie:t,version:getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)}}else if(chromeos){result={name:'Chrome',chromeos:t,chromeBook:t,chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}else if(/chrome.+? edge/i.test(ua)){result={name:'Microsoft Edge',msedge:t,version:edgeVersion}}
else if(/vivaldi/i.test(ua)){result={name:'Vivaldi',vivaldi:t,version:getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i)||versionIdentifier}}
else if(sailfish){result={name:'Sailfish',sailfish:t,version:getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}}
else if(/seamonkey\//i.test(ua)){result={name:'SeaMonkey',seamonkey:t,version:getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)}}
else if(/firefox|iceweasel|fxios/i.test(ua)){result={name:'Firefox',firefox:t,version:getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)}
if(/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)){result.firefoxos=t}}
else if(silk){result={name:'Amazon Silk',silk:t,version:getFirstMatch(/silk\/(\d+(\.\d+)?)/i)}}
else if(/phantom/i.test(ua)){result={name:'PhantomJS',phantom:t,version:getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)}}
else if(/slimerjs/i.test(ua)){result={name:'SlimerJS',slimer:t,version:getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)}}
else if(/blackberry|\bbb\d+/i.test(ua)||/rim\stablet/i.test(ua)){result={name:'BlackBerry',blackberry:t,version:versionIdentifier||getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}}
else if(webos){result={name:'WebOS',webos:t,version:versionIdentifier||getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)};if(/touchpad\//i.test(ua)){result.touchpad=t;}}
else if(/bada/i.test(ua)){result={name:'Bada',bada:t,version:getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)};}
else if(tizen){result={name:'Tizen',tizen:t,version:getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||versionIdentifier};}
else if(/qupzilla/i.test(ua)){result={name:'QupZilla',qupzilla:t,version:getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||versionIdentifier}}
else if(/chromium/i.test(ua)){result={name:'Chromium',chromium:t,version:getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||versionIdentifier}}
else if(/chrome|crios|crmo/i.test(ua)){result={name:'Chrome',chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}
else if(android){result={name:'Android',version:versionIdentifier}}
else if(/safari|applewebkit/i.test(ua)){result={name:'Safari',safari:t}
if(versionIdentifier){result.version=versionIdentifier}}
else if(iosdevice){result={name:iosdevice=='iphone'?'iPhone':iosdevice=='ipad'?'iPad':'iPod'}
if(versionIdentifier){result.version=versionIdentifier}}
else if(/googlebot/i.test(ua)){result={name:'Googlebot',googlebot:t,version:getFirstMatch(/googlebot\/(\d+(\.\d+))/i)||versionIdentifier}}
else{result={name:getFirstMatch(/^(.*)\/(.*) /),version:getSecondMatch(/^(.*)\/(.*) /)};}
if(!result.msedge&&/(apple)?webkit/i.test(ua)){if(/(apple)?webkit\/537\.36/i.test(ua)){result.name=result.name||"Blink"
result.blink=t}else{result.name=result.name||"Webkit"
result.webkit=t}
if(!result.version&&versionIdentifier){result.version=versionIdentifier}}else if(!result.opera&&/gecko\//i.test(ua)){result.name=result.name||"Gecko"
result.gecko=t
result.version=result.version||getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)}
if(!result.msedge&&(android||result.silk)){result.android=t}else if(iosdevice){result[iosdevice]=t
result.ios=t}else if(mac){result.mac=t}else if(xbox){result.xbox=t}else if(windows){result.windows=t}else if(linux){result.linux=t}
var osVersion='';if(result.windowsphone){osVersion=getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);}else if(iosdevice){osVersion=getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);osVersion=osVersion.replace(/[_\s]/g,'.');}else if(android){osVersion=getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);}else if(result.webos){osVersion=getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);}else if(result.blackberry){osVersion=getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);}else if(result.bada){osVersion=getFirstMatch(/bada\/(\d+(\.\d+)*)/i);}else if(result.tizen){osVersion=getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);}
if(osVersion){result.osversion=osVersion;}
var osMajorVersion=osVersion.split('.')[0];if(tablet||nexusTablet||iosdevice=='ipad'||(android&&(osMajorVersion==3||(osMajorVersion>=4&&!mobile)))||result.silk){result.tablet=t}else if(mobile||iosdevice=='iphone'||iosdevice=='ipod'||android||nexusMobile||result.blackberry||result.webos||result.bada){result.mobile=t}
if(result.msedge||(result.msie&&result.version>=10)||(result.yandexbrowser&&result.version>=15)||(result.vivaldi&&result.version>=1.0)||(result.chrome&&result.version>=20)||(result.firefox&&result.version>=20.0)||(result.safari&&result.version>=6)||(result.opera&&result.version>=10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]>=6)||(result.blackberry&&result.version>=10.1)||(result.chromium&&result.version>=20)){result.a=t;}
else if((result.msie&&result.version<10)||(result.chrome&&result.version<20)||(result.firefox&&result.version<20.0)||(result.safari&&result.version<6)||(result.opera&&result.version<10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]<6)||(result.chromium&&result.version<20)){result.c=t}else result.x=t
return result}
var bowser=detect(typeof navigator!=='undefined'?navigator.userAgent:'')
bowser.test=function(browserList){for(var i=0;i<browserList.length;++i){var browserItem=browserList[i];if(typeof browserItem==='string'){if(browserItem in bowser){return true;}}}
return false;}
function getVersionPrecision(version){return version.split(".").length;}
function map(arr,iterator){var result=[],i;if(Array.prototype.map){return Array.prototype.map.call(arr,iterator);}
for(i=0;i<arr.length;i++){result.push(iterator(arr[i]));}
return result;}
function compareVersions(versions){var precision=Math.max(getVersionPrecision(versions[0]),getVersionPrecision(versions[1]));var chunks=map(versions,function(version){var delta=precision-getVersionPrecision(version);version=version+new Array(delta+1).join(".0");return map(version.split("."),function(chunk){return new Array(20-chunk.length).join("0")+chunk;}).reverse();});while(--precision>=0){if(chunks[0][precision]>chunks[1][precision]){return 1;}
else if(chunks[0][precision]===chunks[1][precision]){if(precision===0){return 0;}}
else{return-1;}}}
function isUnsupportedBrowser(minVersions,strictMode,ua){var _bowser=bowser;if(typeof strictMode==='string'){ua=strictMode;strictMode=void(0);}
if(strictMode===void(0)){strictMode=false;}
if(ua){_bowser=detect(ua);}
var version=""+_bowser.version;for(var browser in minVersions){if(minVersions.hasOwnProperty(browser)){if(_bowser[browser]){return compareVersions([version,minVersions[browser]])<0;}}}
return strictMode;}
function check(minVersions,strictMode,ua){return!isUnsupportedBrowser(minVersions,strictMode,ua);}
bowser.isUnsupportedBrowser=isUnsupportedBrowser;bowser.compareVersions=compareVersions;bowser.check=check;bowser._detect=detect;return bowser});(function($){UABBTrigger={triggerHook:function(hook,args){$('body').trigger('uabb-trigger.'+hook,args);},addHook:function(hook,callback){$('body').on('uabb-trigger.'+hook,callback);},removeHook:function(hook,callback){$('body').off('uabb-trigger.'+hook,callback);},};})(jQuery);jQuery(document).ready(function($){if(typeof bowser!=='undefined'&&bowser!==null){var uabb_browser=bowser.name,uabb_browser_v=bowser.version,uabb_browser_class=uabb_browser.replace(/\s+/g,'-').toLowerCase(),uabb_browser_v_class=uabb_browser_class+parseInt(uabb_browser_v);$('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);}
$('.uabb-row-separator').parents('html').css('overflow-x','hidden');});var wpAjaxUrl='https://mangiero.sumy-starter.us/wp-admin/admin-ajax.php';var flBuilderUrl='https://mangiero.sumy-starter.us/wp-content/plugins/bb-plugin/';var FLBuilderLayoutConfig={anchorLinkAnimations:{duration:1000,easing:'swing',offset:100},paths:{pluginUrl:'https://mangiero.sumy-starter.us/wp-content/plugins/bb-plugin/',wpAjaxUrl:'https://mangiero.sumy-starter.us/wp-admin/admin-ajax.php'},breakpoints:{small:768,medium:992,large:1200},waypoint:{offset:80},emptyColWidth:'0%'};(function($){if(typeof FLBuilderLayout!='undefined'){return;}
FLBuilderLayout={init:function(){FLBuilderLayout._destroy();FLBuilderLayout._initClasses();FLBuilderLayout._initBackgrounds();FLBuilderLayout._initRowShapeLayerHeight();if(0===$('.fl-builder-edit').length){FLBuilderLayout._initAnchorLinks();FLBuilderLayout._initHash();FLBuilderLayout._initForms();FLBuilderLayout._reorderMenu();}
else{FLBuilderLayout._initNestedColsWidth();}
$('body').removeClass('fl-no-js');},refreshGalleries:function(element){var $element='undefined'==typeof element?$('body'):$(element),mfContent=$element.find('.fl-mosaicflow-content'),wmContent=$element.find('.fl-gallery'),mfObject=null;if(mfContent){mfObject=mfContent.data('mosaicflow');if(mfObject){mfObject.columns=$([]);mfObject.columnsHeights=[];mfContent.data('mosaicflow',mfObject);mfContent.mosaicflow('refill');}}
if(wmContent){wmContent.trigger('refreshWookmark');}},refreshGridLayout:function(element){var $element='undefined'==typeof element?$('body'):$(element),msnryContent=$element.find('.masonry');if(msnryContent.length){msnryContent.masonry('layout');}},reloadSlider:function(content){var $content='undefined'==typeof content?$('body'):$(content);if($content.find('.bx-viewport > div').length>0){$.each($content.find('.bx-viewport > div'),function(key,slider){setTimeout(function(){$(slider).data('bxSlider').reloadSlider();},100);});}},resizeAudio:function(element){var $element='undefined'==typeof element?$('body'):$(element),audioPlayers=$element.find('.wp-audio-shortcode.mejs-audio'),player=null,mejsPlayer=null,rail=null,railWidth=400;if(audioPlayers.length&&typeof mejs!=='undefined'){audioPlayers.each(function(){player=$(this);mejsPlayer=mejs.players[player.attr('id')];rail=player.find('.mejs-controls .mejs-time-rail');var innerMejs=player.find('.mejs-inner'),total=player.find('.mejs-controls .mejs-time-total');if(typeof mejsPlayer!=='undefined'){railWidth=Math.ceil(player.width()*0.8);if(innerMejs.length){rail.css('width',railWidth+'px!important');mejsPlayer.options.autosizeProgress=true;setTimeout(function(){mejsPlayer.setControlsSize();},50);player.find('.mejs-inner').css({visibility:'visible',height:'inherit'});}}});}},preloadAudio:function(element){var $element='undefined'==typeof element?$('body'):$(element),contentWrap=$element.closest('.fl-accordion-item'),audioPlayers=$element.find('.wp-audio-shortcode.mejs-audio');if(!contentWrap.hasClass('fl-accordion-item-active')&&audioPlayers.find('.mejs-inner').length){audioPlayers.find('.mejs-inner').css({visibility:'hidden',height:0});}},resizeSlideshow:function(){if(typeof YUI!=='undefined'){YUI().use('node-event-simulate',function(Y){Y.one(window).simulate("resize");});}},reloadGoogleMap:function(element){var $element='undefined'==typeof element?$('body'):$(element),googleMap=$element.find('iframe[src*="google.com/maps"]');if(googleMap.length){googleMap.attr('src',function(i,val){return val;});}},_destroy:function(){var win=$(window);win.off('scroll.fl-bg-parallax');win.off('resize.fl-bg-video');},_isTouch:function(){if(('ontouchstart'in window)||(window.DocumentTouch&&document instanceof DocumentTouch)){return true;}
return false;},_isMobile:function(){return/Mobile|Android|Silk\/|Kindle|BlackBerry|Opera Mini|Opera Mobi|webOS/i.test(navigator.userAgent);},_initClasses:function(){var body=$('body'),ua=navigator.userAgent;if(!body.hasClass('archive')&&$('.fl-builder-content-primary').length>0){body.addClass('fl-builder');}
if(FLBuilderLayout._isTouch()){body.addClass('fl-builder-touch');}
if(FLBuilderLayout._isMobile()){body.addClass('fl-builder-mobile');}
if($(window).width()<FLBuilderLayoutConfig.breakpoints.small){body.addClass('fl-builder-breakpoint-small');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.small&&$(window).width()<FLBuilderLayoutConfig.breakpoints.medium){body.addClass('fl-builder-breakpoint-medium');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.medium&&$(window).width()<FLBuilderLayoutConfig.breakpoints.large){body.addClass('fl-builder-breakpoint-large');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.large){body.addClass('fl-builder-breakpoint-default');}
if(ua.indexOf('Trident/7.0')>-1&&ua.indexOf('rv:11.0')>-1){body.addClass('fl-builder-ie-11');}},_initBackgrounds:function(){var win=$(window);if($('.fl-row-bg-parallax').length>0&&!FLBuilderLayout._isMobile()){FLBuilderLayout._scrollParallaxBackgrounds();FLBuilderLayout._initParallaxBackgrounds();win.on('resize.fl-bg-parallax',FLBuilderLayout._initParallaxBackgrounds);win.on('scroll.fl-bg-parallax',FLBuilderLayout._scrollParallaxBackgrounds);}
if($('.fl-bg-video').length>0){FLBuilderLayout._initBgVideos();FLBuilderLayout._resizeBgVideos();var resizeBGTimer=null;win.on('resize.fl-bg-video',function(e){clearTimeout(resizeBGTimer);resizeBGTimer=setTimeout(function(){FLBuilderLayout._resizeBgVideos(e);},100);});}},_initParallaxBackgrounds:function(){$('.fl-row-bg-parallax').each(FLBuilderLayout._initParallaxBackground);},_initParallaxBackground:function(){var row=$(this),content=row.find('> .fl-row-content-wrap'),winWidth=$(window).width(),screenSize='',imageSrc={default:'',medium:'',responsive:'',};imageSrc.default=row.data('parallax-image')||'';imageSrc.medium=row.data('parallax-image-medium')||imageSrc.default;imageSrc.responsive=row.data('parallax-image-responsive')||imageSrc.medium;if(winWidth>FLBuilderLayoutConfig.breakpoints.medium){screenSize='default';}else if(winWidth>FLBuilderLayoutConfig.breakpoints.small&&winWidth<=FLBuilderLayoutConfig.breakpoints.medium){screenSize='medium';}else if(winWidth<=FLBuilderLayoutConfig.breakpoints.small){screenSize='responsive';}
content.css('background-image','url('+imageSrc[screenSize]+')');row.data('current-image-loaded',screenSize);},_scrollParallaxBackgrounds:function(){$('.fl-row-bg-parallax').each(FLBuilderLayout._scrollParallaxBackground);},_scrollParallaxBackground:function(){var win=$(window),row=$(this),content=row.find('> .fl-row-content-wrap'),speed=row.data('parallax-speed'),offset=content.offset(),yPos=-((win.scrollTop()-offset.top)/ speed),initialOffset=(row.data('parallax-offset')!=null)?row.data('parallax-offset'):0,totalOffset=yPos-initialOffset;content.css('background-position','center '+totalOffset+'px');},_initBgVideos:function(){$('.fl-bg-video').each(FLBuilderLayout._initBgVideo);},_initBgVideo:function(){var wrap=$(this),width=wrap.data('width'),height=wrap.data('height'),mp4=wrap.data('mp4'),youtube=wrap.data('youtube'),vimeo=wrap.data('vimeo'),mp4Type=wrap.data('mp4-type'),webm=wrap.data('webm'),webmType=wrap.data('webm-type'),fallback=wrap.data('fallback'),loaded=wrap.data('loaded'),videoMobile=wrap.data('video-mobile'),fallbackTag='',videoTag=null,mp4Tag=null,webmTag=null;if(loaded){return;}
videoTag=$('<video autoplay loop muted playsinline></video>');if('undefined'!=typeof fallback&&''!=fallback){videoTag.attr('poster','data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7')
videoTag.css({backgroundImage:'url("'+fallback+'")',backgroundColor:'transparent',backgroundRepeat:'no-repeat',backgroundSize:'cover',backgroundPosition:'center center',})}
if('undefined'!=typeof mp4&&''!=mp4){mp4Tag=$('<source />');mp4Tag.attr('src',mp4);mp4Tag.attr('type',mp4Type);videoTag.append(mp4Tag);}
if('undefined'!=typeof webm&&''!=webm){webmTag=$('<source />');webmTag.attr('src',webm);webmTag.attr('type',webmType);videoTag.append(webmTag);}
if(!FLBuilderLayout._isMobile()||(FLBuilderLayout._isMobile()&&"yes"==videoMobile)){if('undefined'!=typeof youtube){FLBuilderLayout._initYoutubeBgVideo.apply(this);}
else if('undefined'!=typeof vimeo){FLBuilderLayout._initVimeoBgVideo.apply(this);}
else{wrap.append(videoTag);}}
else{videoTag.attr('src','')
wrap.append(videoTag);}
wrap.data('loaded',true);},_initYoutubeBgVideo:function(){var playerWrap=$(this),videoId=playerWrap.data('video-id'),videoPlayer=playerWrap.find('.fl-bg-video-player'),enableAudio=playerWrap.data('enable-audio'),audioButton=playerWrap.find('.fl-bg-video-audio'),startTime='undefined'!==typeof playerWrap.data('start')?playerWrap.data('start'):0,startTime='undefined'!==typeof playerWrap.data('t')&&startTime===0?playerWrap.data('t'):startTime,endTime='undefined'!==typeof playerWrap.data('end')?playerWrap.data('end'):0,loop='undefined'!==typeof playerWrap.data('loop')?playerWrap.data('loop'):1,stateCount=0,player,fallback_showing;if(videoId){fallback=playerWrap.data('fallback')||false
if(fallback){playerWrap.find('iframe').remove()
fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+playerWrap.data('fallback')+')');fallbackTag.css('background-size','cover');fallbackTag.css('transition','background-image 1s')
playerWrap.append(fallbackTag);fallback_showing=true;}
FLBuilderLayout._onYoutubeApiReady(function(YT){setTimeout(function(){player=new YT.Player(videoPlayer[0],{videoId:videoId,events:{onReady:function(event){if("no"===enableAudio||FLBuilderLayout._isMobile()){event.target.mute();}
else if("yes"===enableAudio&&event.target.isMuted){event.target.unMute();}
playerWrap.data('YTPlayer',player);FLBuilderLayout._resizeYoutubeBgVideo.apply(playerWrap);event.target.playVideo();if(audioButton.length>0&&!FLBuilderLayout._isMobile()){audioButton.on('click',{button:audioButton,player:player},FLBuilderLayout._toggleBgVideoAudio);}},onStateChange:function(event){if(event.data===1){if(fallback_showing){$('.fl-bg-video-fallback').css('background-image','url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)')}}
if(stateCount<4){stateCount++;}
if(stateCount>1&&(-1===event.data||2===event.data)&&"yes"===enableAudio){player.mute();player.playVideo();audioButton.show();}
if(event.data===YT.PlayerState.ENDED&&1===loop){if(startTime>0){player.seekTo(startTime);}
else{player.playVideo();}}},onError:function(event){console.info('YT Error: '+event.data)
FLBuilderLayout._onErrorYoutubeVimeo(playerWrap)}},playerVars:{playsinline:FLBuilderLayout._isMobile()?1:0,controls:0,showinfo:0,rel:0,start:startTime,end:endTime,}});},1);});}},_onErrorYoutubeVimeo:function(playerWrap){fallback=playerWrap.data('fallback')||false
if(!fallback){return false;}
playerWrap.find('iframe').remove()
fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+playerWrap.data('fallback')+')');playerWrap.append(fallbackTag);},_onYoutubeApiReady:function(callback){if(window.YT&&YT.loaded){callback(YT);}else{setTimeout(function(){FLBuilderLayout._onYoutubeApiReady(callback);},350);}},_initVimeoBgVideo:function(){var playerWrap=$(this),videoId=playerWrap.data('video-id'),videoHash=playerWrap.data('video-hash'),videoPlayer=playerWrap.find('.fl-bg-video-player'),enableAudio=playerWrap.data('enable-audio'),audioButton=playerWrap.find('.fl-bg-video-audio'),player,width=playerWrap.outerWidth(),ua=navigator.userAgent;if(typeof Vimeo!=='undefined'&&videoId){const vimOptions={loop:true,title:false,portrait:false,background:true,autopause:false,muted:true,};if(videoHash.length){vimOptions.url=`https://player.vimeo.com/video/${ videoId }?h=${ videoHash }`;}else{vimOptions.id=videoId;}
player=new Vimeo.Player(videoPlayer[0],vimOptions);playerWrap.data('VMPlayer',player);if("no"===enableAudio){player.setVolume(0);}
else if("yes"===enableAudio){if(ua.indexOf("Safari")>-1||ua.indexOf("Chrome")>-1||ua.indexOf("Firefox")>-1){player.setVolume(0);audioButton.show();}
else{player.setVolume(1);}}
player.play().catch(function(error){FLBuilderLayout._onErrorYoutubeVimeo(playerWrap)});if(audioButton.length>0){audioButton.on('click',{button:audioButton,player:player},FLBuilderLayout._toggleBgVideoAudio);}}},_toggleBgVideoAudio:function(e){var player=e.data.player,control=e.data.button.find('.fl-audio-control');if(control.hasClass('fa-volume-off')){control.removeClass('fa-volume-off').addClass('fa-volume-up');e.data.button.find('.fa-times').hide();if('function'===typeof player.unMute){player.unMute();}
else{player.setVolume(1);}}
else{control.removeClass('fa-volume-up').addClass('fa-volume-off');e.data.button.find('.fa-times').show();if('function'===typeof player.unMute){player.mute();}
else{player.setVolume(0);}}},_videoBgSourceError:function(e){var source=$(e.target),wrap=source.closest('.fl-bg-video'),vid=wrap.find('video'),fallback=wrap.data('fallback'),fallbackTag='';source.remove();if(vid.find('source').length){return;}else if(''!==fallback){fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+fallback+')');wrap.append(fallbackTag);vid.remove();}},_resizeBgVideos:function(){$('.fl-bg-video').each(function(){FLBuilderLayout._resizeBgVideo.apply(this);if($(this).parent().find('img').length>0){$(this).parent().imagesLoaded($.proxy(FLBuilderLayout._resizeBgVideo,this));}});},_resizeBgVideo:function(){if(0===$(this).find('video').length&&0===$(this).find('iframe').length){return;}
var wrap=$(this),wrapHeight=wrap.outerHeight(),wrapWidth=wrap.outerWidth(),vid=wrap.find('video'),vidHeight=wrap.data('height'),vidWidth=wrap.data('width'),newWidth=wrapWidth,newHeight=Math.round(vidHeight*wrapWidth/vidWidth),newLeft=0,newTop=0,iframe=wrap.find('iframe'),isRowFullHeight=$(this).closest('.fl-row-bg-video').hasClass('fl-row-full-height'),vidCSS={top:'50%',left:'50%',transform:'translate(-50%,-50%)',};if(vid.length){if(vidHeight===''||typeof vidHeight==='undefined'||vidWidth===''||typeof vidWidth==='undefined'){vid.css({'left':'0px','top':'0px','width':newWidth+'px'});vid.on('loadedmetadata',FLBuilderLayout._resizeOnLoadedMeta);return;}
if(!isRowFullHeight){if(newHeight<wrapHeight){newHeight=wrapHeight;newLeft=-((newWidth-wrapWidth)/ 2);newWidth=vidHeight?Math.round(vidWidth*wrapHeight/vidHeight):newWidth;}
else{newTop=-((newHeight-wrapHeight)/2);}
vidCSS={left:newLeft+'px',top:newTop+'px',height:newHeight+'px',width:newWidth+'px',}}
vid.css(vidCSS);}
else if(iframe.length){if(typeof wrap.data('youtube')!=='undefined'){FLBuilderLayout._resizeYoutubeBgVideo.apply(this);}}},_resizeOnLoadedMeta:function(){var video=$(this),wrapHeight=video.parent().outerHeight(),wrapWidth=video.parent().outerWidth(),vidWidth=video[0].videoWidth,vidHeight=video[0].videoHeight,newHeight=Math.round(vidHeight*wrapWidth/vidWidth),newWidth=wrapWidth,newLeft=0,newTop=0;if(newHeight<wrapHeight){newHeight=wrapHeight;newWidth=Math.round(vidWidth*wrapHeight/vidHeight);newLeft=-((newWidth-wrapWidth)/2);}
else{newTop=-((newHeight-wrapHeight)/2);}
video.parent().data('width',vidWidth);video.parent().data('height',vidHeight);video.css({'left':newLeft+'px','top':newTop+'px','width':newWidth+'px','height':newHeight+'px'});},_resizeYoutubeBgVideo:function(){var wrap=$(this),wrapWidth=wrap.outerWidth(),wrapHeight=wrap.outerHeight(),player=wrap.data('YTPlayer'),video=player?player.getIframe():null,aspectRatioSetting='16:9',aspectRatioArray=aspectRatioSetting.split(':'),aspectRatio=aspectRatioArray[0]/ aspectRatioArray[1],ratioWidth=wrapWidth / aspectRatio,ratioHeight=wrapHeight*aspectRatio,isWidthFixed=wrapWidth / wrapHeight>aspectRatio,width=isWidthFixed?wrapWidth:ratioHeight,height=isWidthFixed?ratioWidth:wrapHeight;if(video){$(video).width(width).height(height);}},_initHash:function(){var hash=window.location.hash.replace('#','').split('/').shift(),element=null,tabs=null,responsiveLabel=null,tabIndex=null,label=null;if(''!==hash){try{element=$('#'+hash);if(element.length>0){if(element.hasClass('fl-accordion-item')){setTimeout(function(){element.find('.fl-accordion-button').trigger('click');},100);}
if(element.hasClass('fl-tabs-panel')){setTimeout(function(){tabs=element.closest('.fl-tabs');responsiveLabel=element.find('.fl-tabs-panel-label');tabIndex=responsiveLabel.data('index');label=tabs.find('.fl-tabs-labels .fl-tabs-label[data-index='+tabIndex+']');label[0].click();FLBuilderLayout._scrollToElement(element);},100);}}}
catch(e){}}},_initAnchorLinks:function(){$('a').each(FLBuilderLayout._initAnchorLink);},_initAnchorLink:function(){var link=$(this),href=link.attr('href'),loc=window.location,id=null,element=null,flNode=false;if('undefined'!=typeof href&&href.indexOf('#')>-1&&link.closest('svg').length<1){if(loc.pathname.replace(/^\//,'')==this.pathname.replace(/^\//,'')&&loc.hostname==this.hostname){try{id=href.split('#').pop();if(!id){return;}
element=$('#'+id);if(element.length>0){flNode=element.hasClass('fl-row')||element.hasClass('fl-col')||element.hasClass('fl-module');if(!element.hasClass('fl-no-scroll')&&(link.hasClass('fl-scroll-link')||flNode)){$(link).on('click',FLBuilderLayout._scrollToElementOnLinkClick);}
if(element.hasClass('fl-accordion-item')){$(link).on('click',FLBuilderLayout._scrollToAccordionOnLinkClick);}
if(element.hasClass('fl-tabs-panel')){$(link).on('click',FLBuilderLayout._scrollToTabOnLinkClick);}}}
catch(e){}}}},_scrollToElementOnLinkClick:function(e,callback){var element=$('#'+$(this).attr('href').split('#').pop());FLBuilderLayout._scrollToElement(element,callback);e.preventDefault();},_scrollToElement:function(element,callback){var config=FLBuilderLayoutConfig.anchorLinkAnimations,dest=0,win=$(window),doc=$(document);if(element.length>0){if('fixed'===element.css('position')||'fixed'===element.parent().css('position')){dest=element.position().top;}
else if(element.offset().top>doc.height()-win.height()){dest=doc.height()-win.height();}
else{dest=element.offset().top-config.offset;}
$('html, body').stop(true).animate({scrollTop:dest},config.duration,config.easing,function(){if('undefined'!=typeof callback){callback();}
if(undefined!=element.attr('id')&&window.location.hash!=='#'+element.attr('id')){if(history.pushState){history.pushState(null,null,'#'+element.attr('id'));}
else{window.location.hash=element.attr('id');}}});}},_scrollToAccordionOnLinkClick:function(e){var element=$('#'+$(this).attr('href').split('#').pop());if(element.length>0){var callback=function(){if(element){element.find('.fl-accordion-button').trigger('click');element=false;}};FLBuilderLayout._scrollToElementOnLinkClick.call(this,e,callback);}},_scrollToTabOnLinkClick:function(e){var element=$('#'+$(this).attr('href').split('#').pop()),tabs=null,label=null,responsiveLabel=null;if(element.length>0){tabs=element.closest('.fl-tabs');responsiveLabel=element.find('.fl-tabs-panel-label');tabIndex=responsiveLabel.data('index');label=tabs.find('.fl-tabs-labels .fl-tabs-label[data-index='+tabIndex+']');if(responsiveLabel.is(':visible')){var callback=function(){if(element){responsiveLabel.trigger($.Event('click',{which:1}));}};FLBuilderLayout._scrollToElementOnLinkClick.call(this,e,callback);}
else{label[0].click();FLBuilderLayout._scrollToElement(element);}
e.preventDefault();}},_initForms:function(){if(!FLBuilderLayout._hasPlaceholderSupport){$('.fl-form-field input').each(FLBuilderLayout._initFormFieldPlaceholderFallback);}
$('.fl-form-field input').on('focus',FLBuilderLayout._clearFormFieldError);},_hasPlaceholderSupport:function(){var input=document.createElement('input');return'undefined'!=input.placeholder;},_initFormFieldPlaceholderFallback:function(){var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if('undefined'!=placeholder&&''===val){field.val(placeholder);field.on('focus',FLBuilderLayout._hideFormFieldPlaceholderFallback);field.on('blur',FLBuilderLayout._showFormFieldPlaceholderFallback);}},_hideFormFieldPlaceholderFallback:function(){var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if(val==placeholder){field.val('');}},_showFormFieldPlaceholderFallback:function(){var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if(''===val){field.val(placeholder);}},_clearFormFieldError:function(){var field=$(this);field.removeClass('fl-form-error');field.siblings('.fl-form-error-message').hide();},_initRowShapeLayerHeight:function(){FLBuilderLayout._adjustRowShapeLayerHeight();$(window).on('resize',FLBuilderLayout._adjustRowShapeLayerHeight);},_initNestedColsWidth:function(){var nestedCols=$('.fl-col-has-cols');if(nestedCols.length<=0){return;}
$(nestedCols).each(function(index,col){if($(col).width()<=0){$(col).css('width',FLBuilderLayoutConfig.emptyColWidth);}});},_adjustRowShapeLayerHeight:function(){var rowShapeLayers=$('.fl-builder-shape-layer');$(rowShapeLayers).each(function(index){var rowShapeLayer=$(this),shape=$(rowShapeLayer).find('svg'),height=shape.height(),excludeShapes='.fl-builder-shape-circle, .fl-builder-shape-dot-cluster, .fl-builder-shape-topography, .fl-builder-shape-rect';if(!rowShapeLayer.is(excludeShapes)){$(shape).css('height',Math.ceil(height));}});},_string_to_slug:function(str){str=str.replace(/^\s+|\s+$/g,'');if('undefined'==typeof window._fl_string_to_slug_regex){regex=new RegExp('[^a-zA-Z0-9\'":() !.,-_|]','g');}else{regex=new RegExp('[^'+window._fl_string_to_slug_regex+'\'":\(\) !.,-_|\\\p{Letter}]','ug');}
str=str.replace(regex,'').replace(/\s+/g,' ');return str;},_reorderMenu:function(){if($('#wp-admin-bar-fl-builder-frontend-edit-link-default li').length>1){$('#wp-admin-bar-fl-builder-frontend-duplicate-link').appendTo('#wp-admin-bar-fl-builder-frontend-edit-link-default').css('padding-top','5px').css('border-top','2px solid #1D2125').css('margin-top','5px')}}};$(function(){FLBuilderLayout.init();});})(jQuery);(function($){if(typeof FLBuilderLayoutModules!=='undefined'){return;}
FLBuilderLayoutModules={init:function(){if(0===$('.fl-builder-edit').length){FLBuilderLayoutModules._initModuleAnimations();}},_initModuleAnimations:function(){if(typeof jQuery.fn.waypoint!=='undefined'){$('.fl-animation').each(function(){var node=$(this),nodeTop=node.offset().top,winHeight=$(window).height(),bodyHeight=$('body').height(),waypoint=FLBuilderLayoutConfig.waypoint,offset='80%';if(typeof waypoint.offset!==undefined){offset=FLBuilderLayoutConfig.waypoint.offset+'%';}
if(bodyHeight-nodeTop<winHeight*0.2){offset='100%';}
node.waypoint({offset:offset,handler:FLBuilderLayoutModules._doModuleAnimation});});}},_doModuleAnimation:function(){var module='undefined'==typeof this.element?$(this):$(this.element),delay=parseFloat(module.data('animation-delay')),duration=parseFloat(module.data('animation-duration'));if(!isNaN(duration)){module.css('animation-duration',duration+'s');}
if(!isNaN(delay)&&delay>0){setTimeout(function(){module.addClass('fl-animated');},delay*1000);}else{setTimeout(function(){module.addClass('fl-animated');},1);}}};$(function(){FLBuilderLayoutModules.init();});})(jQuery);;(function($){PPContentGrid=function(settings){this.settings=settings;this.nodeClass='.fl-node-'+settings.id;this.wrapperClass=this.nodeClass+' .pp-content-post-'+this.settings.layout;this.postClass=this.wrapperClass+' .pp-content-'+this.settings.layout+'-post';this.matchHeight=settings.matchHeight=='yes'?true:false;this.style=settings.style;this.masonry=settings.masonry=='yes'?true:false;this.filters=settings.filters;this.filterTax=settings.filterTax;this.filterType=settings.filterType;this.page=$(this.wrapperClass).data('paged');this.isFiltering=false;this.isDefaultFilter=false;this.activeFilter='';this.totalPages=1;this.currentPage=1;this.cacheData={};this.ajaxData={};this.includeSettings=true;if(this._hasPosts()){this._initLayout();this._initSearch();}};PPContentGrid.prototype={settings:{},nodeClass:'',wrapperClass:'',postClass:'',filters:false,filterTax:'',filterType:'',filterData:{},isFiltering:false,isDefaultFilter:false,activeFilter:'',totalPages:1,currentPage:1,cacheData:{},ajaxData:{},includeSettings:true,matchHeight:false,masonry:false,style:'',_hasPosts:function(){return $(this.postClass).length>0;},_useCssGrid:function(){return this.matchHeight&&'dynamic'===this.filterType;},_initIsotopeData:function(){var postFilterData={itemSelector:'.pp-content-post',percentPosition:true,transitionDuration:'0.3s',hiddenStyle:{opacity:0},visibleStyle:{opacity:1},masonry:{columnWidth:'.pp-content-post',gutter:'.pp-grid-space'},isOriginLeft:!$('body').hasClass('rtl'),};if(!this.masonry){postFilterData=$.extend({},postFilterData,{layoutMode:'fitRows',fitRows:{gutter:'.pp-grid-space'},});}
this.filterData=postFilterData;if(this.settings.defaultFilter!==''){this.activeFilter=this.settings.defaultFilter;}},_initSearch:function(){var searchFormClass='cg-search-form';$(this.nodeClass).trigger('grid.searchInit',[searchFormClass,this]);if(!$(this.nodeClass).hasClass('cg-search-result')&&$('.'+searchFormClass).length>0){return;}
$('.'+searchFormClass).find('form').on('submit',function(e){e.preventDefault();var input=$(e.target).find('input[type="search"]');bb_powerpack.search_term=input.val();if(input.val()!==''){this.settings.is_search=true;this.isFiltering=true;}else{this.settings.is_search=false;this.isFiltering=false;this.cacheData={};this.ajaxData={};}
this._getAjaxPosts(this.activeFilter,this.filterData,this.currentPage);}.bind(this));$('.'+searchFormClass).find('form input').on('input clear',function(e){if($(e.target).val()===''){bb_powerpack.search_term='';this.settings.is_search=false;this.isFiltering=false;this.cacheData={};this.ajaxData={};this._getAjaxPosts(this.activeFilter,this.filterData,this.currentPage);}}.bind(this));},_initLayout:function(){if($(this.nodeClass).find('.pp-posts-wrapper').hasClass('pp-posts-initiated')){return;}
switch(this.settings.layout){case'grid':this._initIsotopeData();this._gridLayout();this._initPagination();this._reLayout();break;case'carousel':this._carouselLayout();break;}
$(this.postClass).css('visibility','visible');var self=this;$(window).on('load',function(){if(!$(self.nodeClass).hasClass('pp-cg-no-page-scroll')){FLBuilderLayout._scrollToElement($(self.nodeClass+' .pp-paged-scroll-to'));}});$(this.nodeClass).on('grid.afterInit carousel.afterInit',function(){$(self.nodeClass).find('.pp-posts-wrapper').addClass('pp-posts-initiated');if('carousel'===self.settings.layout){setTimeout(function(){self._gridLayoutMatchHeightSimple();},200);}
if($(self.nodeClass).find('.owl-nav').length>0&&self.settings.carousel.autoplay){var carousel=$(self.nodeClass).find('.owl-carousel');$(self.nodeClass).find('.owl-nav button').on('mouseover',function(){carousel.trigger('stop.owl.autoplay');}).on('mouseleave',function(){carousel.trigger('play.owl.autoplay');});}});$(this.nodeClass).find('.pp-posts-wrapper img').on('load',function(){if('lazy'!==$(this).attr('loading')){return;}
var postsWrapper=$(self.nodeClass).find('.pp-content-post-grid');if('undefined'!==typeof $.fn.isotope){setTimeout(function(){if(postsWrapper.data('isotope')){postsWrapper.isotope('layout');}},500);}});},_gridLayout:function(){var wrap=$(this.wrapperClass);var postFilterData=this.filterData;this._loadItemsFromCache();this._setLastPostClass();this._setCenterAlign();$(window).on('resize',this._setCenterAlign.bind(this));wrap.imagesLoaded(function(){var node=$(this.nodeClass);var base=this;var postFilters=!this._useCssGrid()&&!wrap.data('isotope')?wrap.isotope(postFilterData):wrap;if(this.settings.filters||this.masonry){var filterWrap=$(this.nodeClass).find('.pp-post-filters');var filterToggle=$(this.nodeClass).find('.pp-post-filters-toggle');filterToggle.on('click',function(){filterWrap.slideToggle(function(){if($(this).is(':visible')){filterToggle.addClass('pp-post-filters-open');}
if(!$(this).is(':visible')){filterToggle.removeClass('pp-post-filters-open');}});});filterWrap.on('click keyup','.pp-post-filter',function(e){var shouldFilter='click'===e.type||('keyup'===e.type&&(13===e.keyCode||13===e.which))
if(!shouldFilter){return;}
base.activeFilter=$(this).data('term');base.isFiltering=true;if('static'===base.filterType){var filterVal=$(this).attr('data-filter');postFilters.isotope({filter:filterVal});}else{var term=$(this).data('term');$(base.wrapperClass).addClass('pp-is-filtering');base._getPosts(term,postFilterData);}
filterWrap.find('.pp-post-filter').removeClass('pp-filter-active');$(this).addClass('pp-filter-active');filterToggle.find('span.toggle-text').html($(this).text());if(filterToggle.hasClass('pp-post-filters-open')){filterWrap.slideUp();filterToggle.removeClass('pp-post-filters-open');}
$(base.nodeClass).trigger('grid.filter.change');});$(window).on('resize',function(){if(!filterToggle.is(':visible')){filterWrap.removeAttr('style');}});if(base.settings.defaultFilter!==''){var defaultFilter=base.settings.defaultFilter;if(filterWrap.find('li[data-term="'+defaultFilter+'"]').length>0){self.isDefaultFilter=true;filterWrap.find('li[data-term="'+defaultFilter+'"]').trigger('click');}}
if(''!==location.hash){var filterHash=location.hash.split('#')[1];filterWrap.find('li[data-term="'+filterHash+'"]').trigger('click');}
$(window).on('hashchange',function(){if(''!==location.hash){var filterHash=location.hash.split('#')[1];filterWrap.find('li[data-term="'+filterHash+'"]').trigger('click');}});}
if('dynamic'===base.filterType){$(base.nodeClass).find('.fl-builder-pagination a').off('click').on('click',function(e){e.preventDefault();var pageNumber=base._getPageNumber(this);base.currentPage=pageNumber;base._getPosts('',postFilterData,pageNumber);});}
if(!this.masonry){setTimeout(function(){if(base.settings.filters&&'static'===base.filterType){node.find('.pp-filter-active').trigger('click');}
base._gridLayoutMatchHeight();if(wrap.data('isotope')){wrap.isotope('layout');}},1000);}
$(this.nodeClass).trigger('grid.afterInit');}.bind(this));},_loadItemsFromCache:function(){if(window.localStorage&&$(this.nodeClass).hasClass('cg-cache-active')){var cachedResponse=window.localStorage.getItem('ppcg_'+this.settings.id);if(cachedResponse){cachedResponse=JSON.parse(cachedResponse);cachedTime=cachedResponse.timestamp;timeDiff=(new Date().getTime()-cachedTime)/ 1000;timeDiff /=(60*60);if(timeDiff>=12||location.href!==cachedResponse.currentUrl){window.localStorage.removeItem('ppcg_'+this.settings.id);}else{var pages=cachedResponse.cacheData.ajaxCache[cachedResponse.filter].page;Object.keys(pages).forEach(function(page){this._renderPosts(pages[page],{term:cachedResponse.filter,isotopeData:this.filterData,page:cachedResponse.paged});}.bind(this));this.currentPage=cachedResponse.currentPage;this.activeFilter=cachedResponse.activeFilter;this.cacheData=cachedResponse.cacheData;$(this.nodeClass).find('.pp-post-filter').removeClass('pp-filter-active');if(''===this.activeFilter||'all'===cachedResponse.filter){$(this.nodeClass).find('.pp-post-filter[data-filter="*"]').addClass('pp-filter-active');}else{$(this.nodeClass).find('.pp-post-filter[data-term="'+this.activeFilter+'"]').addClass('pp-filter-active');}}}}},_removeItemsFromCache:function(){if(window.localStorage){window.localStorage.removeItem('ppcg_'+this.settings.id);}},_setLastPostClass:function(){var posts=$(this.postClass);if(posts.length>0){var last=posts[posts.length-1];$(last).addClass('pp-post-last');}},_setCenterAlign:function(){if($(this.nodeClass).hasClass('cg-center-align')){var columns=this._getColumns();var gridSpace=$(this.wrapperClass).find('.pp-grid-space').outerWidth();if($(this.postClass).length>=columns){gridSpace=gridSpace*(columns-1);}
if(1===columns){gridSpace=0;}
var colWidth=($(this.nodeClass+' .fl-module-content').outerWidth()/ columns)-gridSpace;if(colWidth>0){this.filterData.masonry.columnWidth=colWidth;this.filterData.masonry.isFitRows=true;this.filterData.percentPosition=false;gridSpace+=0.18;if($(this.postClass).length<columns){var wrapperWidth=(colWidth*$(this.postClass).length)+(gridSpace*($(this.postClass).length-1));}else{var wrapperWidth=(colWidth*columns)+gridSpace;}
$(this.postClass).css('width',colWidth+'px');$(this.wrapperClass).css('width',wrapperWidth+'px');}}},_carouselLayout:function(){var self=this;var wrap=$(this.nodeClass+' .pp-content-post-carousel .pp-content-posts-inner');var setAriaAttrs=function(e){var visibleSlides=0;$(e.target).find('.owl-item').each(function(index){if(!$(this).hasClass('cloned')){visibleSlides++;$(this).attr('aria-label','Item '+visibleSlides+' of '+e.item.count);}});var currentIndex=e.item.index;var visibleItems=e.page.size;$(e.target).find('.owl-item').each(function(index){if(index>=currentIndex&&index<currentIndex+visibleItems){$(this).attr('aria-hidden','false');$(this).attr('tabindex','0');$(this).find('a, button').attr('tabindex','0');}else{$(this).attr('aria-hidden','true');$(this).attr('tabindex','-1');$(this).find('a, button').attr('tabindex','-1');}});};var owlOptions={onInitialized:function(e){var count=1;$(e.target).find('.owl-dot').each(function(){$(this).append('<span class="sr-only">Slide group '+count+'</span>');count++;if($(this).hasClass('active')){$(this).attr('aria-current','true');}else{$(this).attr('aria-current','false');}});$(e.target).find('.owl-item').attr('role','group');setAriaAttrs(e);self._gridLayoutMatchHeightSimple();},onChanged:function(e){$(e.target).find('.owl-dot').each(function(){if($(this).hasClass('active')){$(this).attr('aria-current','true');}else{$(this).attr('aria-current','false');}});setAriaAttrs(e);},onResized:this._gridLayoutMatchHeightSimple.bind(this),onRefreshed:this._gridLayoutMatchHeightSimple.bind(this),onLoadedLazy:this._gridLayoutMatchHeightSimple.bind(this),rtl:$('body').hasClass('rtl')};if($(this.postClass).length<this.settings.carousel.items){this.settings.carousel.slideBy='page';this.settings.carousel.loop=false;}
if(this.settings.carousel.lazyLoad){$(this.postClass).each(function(){if($(this).find('.pp-content-grid-post-image img').length>0){var src=$(this).find('.pp-content-grid-post-image img').addClass('owl-lazy').attr('src');$(this).find('.pp-content-grid-post-image img').removeAttr('src').attr('data-src',src);}else{var src=$(this).find('.pp-post-image img').addClass('owl-lazy').attr('src');$(this).find('.pp-post-image img').removeAttr('src').attr('data-src',src);}});}
owlOptions=$.extend({},this.settings.carousel,owlOptions);$(this.nodeClass).trigger('carousel.beforeInit',[owlOptions]);wrap.imagesLoaded(function(){wrap.owlCarousel(owlOptions);var owl=wrap.data('owl.carousel');wrap.on('keyup',function(e){if(37===e.keyCode||37===e.which){owl.prev();}
if(39===e.keyCode||39===e.which){owl.next();}});if($(this.nodeClass).hasClass('overflow-visible')){$(this.nodeClass).closest('.fl-row').css('overflow-x','hidden');$(this.nodeClass).find('.owl-carousel').css('overflow','visible');}
$(this.nodeClass).trigger('carousel.afterInit');}.bind(this));},_getPosts:function(term,isotopeData,paged){var processAjax=false,filter=term,paged=(!paged||'undefined'===typeof paged)?1:paged;if('undefined'===typeof term||''===term){filter='all';}
this._getTotalPages();var cacheData=this._getCacheData(filter);if('undefined'===typeof cacheData){processAjax=true;}else{var cachedResponse=cacheData.page[paged];if('undefined'===typeof cachedResponse){processAjax=true;}else{$(this.nodeClass).trigger('grid.beforeRender');this._renderPosts(cachedResponse,{term:term,isotopeData:isotopeData,page:paged});}}
if(processAjax){this._getAjaxPosts(term,isotopeData,paged);}},_getAjaxPosts:function(term,isotopeData,paged){var taxonomy=this.filterTax,paged='undefined'===typeof paged?false:paged,self=this;var currentPage=bb_powerpack.current_page.split('?')[0];var data={pp_action:'get_ajax_posts',node_id:this.settings.id,paged:!paged?this.page:paged,current_page:currentPage,};if('undefined'!==typeof this.includeSettings&&this.includeSettings){data.settings=this.settings.fields;}
if($(this.wrapperClass).data('template-id')){data.template_id=$(this.wrapperClass).data('template-id');data.template_node_id=$(this.wrapperClass).data('template-node-id');}
if(this.settings.is_archive){data['is_archive']=true;}
if('undefined'!==typeof term&&''!==term){data['term']=term;}else if(this.settings.is_tax&&this.settings.current_term){data['is_tax']=true;data['taxonomy']=this.settings.current_tax;data['term']=this.settings.current_term;}
if(this.settings.is_tax&&this.settings.current_term){data['current_tax']=this.settings.current_tax;data['current_term']=this.settings.current_term;}
if(this.settings.is_author&&this.settings.current_author){data['is_author']=true;data['author_id']=this.settings.current_author;}
if(this.settings.is_search){data['is_search']=true;data['search_term']=bb_powerpack.search_term;}
if($(this.wrapperClass).data('orderby')){data['orderby']=$(this.wrapperClass).data('orderby');}
this.ajaxData=data;if(!this.paginating){$(this.wrapperClass).addClass('pp-is-filtering');}
$.post(location.href.split('#').shift(),data,function(response){self.includeSettings=true;self._setCacheData(term,response,paged);$(self.nodeClass).trigger('grid.beforeRender');self._renderPosts(response,{term:term,isotopeData:isotopeData,page:paged});$(self.wrapperClass).removeClass('pp-is-filtering');if(!self.paginating){self.paginating=false;}}).fail(function(xhr){if(404==xhr.status&&'undefined'!==xhr.responseJSON.data){var response=xhr.responseJSON;self.includeSettings=true;self._setCacheData(term,response,paged);$(self.nodeClass).trigger('grid.beforeRender');self._renderPosts(response,{term:term,isotopeData:isotopeData,page:paged});$(self.wrapperClass).removeClass('pp-is-filtering');if(!self.paginating){self.paginating=false;}}});},_renderPosts:function(response,args){var self=this,wrap=$(this.wrapperClass),posts=$(response.data),count=0;posts.each(function(){if($(this).hasClass('pp-content-post')){count++;}});wrap.parent().css('--items-count',count);if(('load_more'!==self.settings.pagination&&'scroll'!==self.settings.pagination)||self.isFiltering){if(wrap.data('isotope')){wrap.isotope('remove',$(this.postClass));}else{wrap.find(this.postClass).remove();}}
if(wrap.data('isotope')){wrap.isotope('remove',$('.pp-posts-not-found-text'));}else{wrap.find('.pp-posts-not-found-text').remove();}
if(wrap.data('isotope')){if(!this.masonry){wrap.isotope('insert',posts,this._gridLayoutMatchHeight.bind(this));wrap.imagesLoaded(function(){setTimeout(function(){self._gridLayoutMatchHeight();},150);}.bind(this));}else{wrap.isotope('insert',posts);}
wrap.find('.pp-grid-space').remove();wrap.append('<div class="pp-grid-space"></div>');}else{posts.hide();if(('load_more'==self.settings.pagination||'scroll'==self.settings.pagination)&&!self.isFiltering){wrap.append(posts.fadeIn(400));}else{wrap.html(posts.fadeIn(400));}}
wrap.imagesLoaded(function(){setTimeout(function(){if(!this.masonry){self._gridLayoutMatchHeight();}
if(wrap.data('isotope')){wrap.isotope('layout');}},500);}.bind(this));if('load_more'===self.settings.pagination){$(self.nodeClass).find('.pp-content-grid-load-more').remove();}
if('scroll'===self.settings.pagination){$(self.nodeClass).find('.pp-content-grid-loader').remove();}
if(response.pagination){var $pagination=$(response.pagination);if('numbers'===self.settings.pagination){$pagination.removeAttr('style');}
$(self.nodeClass).find('.fl-builder-pagination').remove();$(self.nodeClass).find('> .fl-module-content').append($pagination);if('load_more'===self.settings.pagination){setTimeout(function(){self._getTotalPages();if(self.totalPages!==self.currentPage){$(self.nodeClass).find('.fl-module-content .pp-content-grid-load-more').fadeIn();self._initPagination();}else{$(self.nodeClass).find('.fl-module-content .pp-content-grid-load-more').slideUp();}},250);}
$(self.nodeClass).off('click','.pp-ajax-pagination a').on('click','.pp-ajax-pagination a',function(e){e.preventDefault();var pageNumber=self._getPageNumber(this);self.currentPage=pageNumber;self._getPosts(args.term,args.isotopeData,pageNumber);});}else{$(self.nodeClass).find('.fl-builder-pagination').remove();}
if(('load_more'!==self.settings.pagination&&'scroll'!==self.settings.pagination)||self.isFiltering){if(self.settings.scrollTo&&!self.isDefaultFilter){var scrollToClass=self.settings.scrollToClass||self.nodeClass;var offsetTop=$(scrollToClass).offset().top-200;$('html, body').stop().animate({scrollTop:offsetTop},300);self.isDefaultFilter=false;}}
if(response.styles_scripts&&''!==response.styles_scripts){$('body').append($(response.styles_scripts));}
if(self.isFiltering){self.isFiltering=false;$(self.nodeClass).trigger('grid.filter.complete');}
wrap.removeClass('pp-is-filtering');$(self.nodeClass).trigger('grid.rendered');},_getPageNumber:function(pageElement){var pageNumber=parseInt($(pageElement).text());if($(pageElement).hasClass('next')){pageNumber=parseInt($(pageElement).parents('.pp-content-grid-pagination').find('.current').text())+1;}
if($(pageElement).hasClass('prev')){pageNumber=parseInt($(pageElement).parents('.pp-content-grid-pagination').find('.current').text())-1;}
return pageNumber;},_setCacheData:function(filter,response,paged){if('undefined'===typeof filter||''===filter){filter='all';}
if('undefined'===typeof paged||!paged){paged=1;}
if('undefined'===typeof this.cacheData.ajaxCache){this.cacheData.ajaxCache={};}
if('undefined'===typeof this.cacheData.ajaxCache[filter]){this.cacheData.ajaxCache[filter]={};}
if('undefined'===typeof this.cacheData.ajaxCache[filter].page){this.cacheData.ajaxCache[filter].page={};}
this.cacheData.ajaxCache[filter].page[paged]=response;if(window.localStorage){var localData={paged:paged,currentPage:this.currentPage,currentUrl:location.href,cacheData:this.cacheData,filter:filter,activeFilter:this.activeFilter,timestamp:new Date().getTime()};window.localStorage.setItem('ppcg_'+this.settings.id,JSON.stringify(localData));}},_getCacheData:function(filter){var cacheData=this.cacheData;if('undefined'===typeof cacheData.ajaxCache){cacheData.ajaxCache={};}
return cacheData.ajaxCache[filter];},_getColumns:function(){var columns=this.settings.postColumns.xl;if(window.innerWidth<=this.settings.breakpoints.large){columns=this.settings.postColumns.lg;}
if(window.innerWidth<=this.settings.breakpoints.medium){columns=this.settings.postColumns.md;}
if(window.innerWidth<=this.settings.breakpoints.small){columns=this.settings.postColumns.sm;}
return columns;},_gridLayoutMatchHeight:function(){var highestBox=0;var contentHeight=0;var postElements=$(this.postClass+':visible');var columns=this._getColumns();if(!this.matchHeight||1===columns){return;}
if('style-9'===this.style){return;}
if(this._useCssGrid()){return;}
if(this.settings.layout==='grid'){if(this.masonry){return;}
postElements.css('height','auto');var rows=Math.round(postElements.length / columns);if(postElements.length%columns>0){rows=rows+1;}
var j=1,k=columns;for(var i=0;i<rows;i++){var postsInRow=$(this.postClass+':visible:nth-child(n+'+j+'):nth-child(-n+'+k+')');postsInRow.css('height','').each(function(){if($(this).height()>highestBox){highestBox=$(this).height();contentHeight=$(this).find('.pp-content-post-data').outerHeight();}});postsInRow.height(highestBox);j=k+1;k=k+columns;if(k>postElements.length){k=postElements.length;}
highestBox=0;}}else{postElements.css('height','').each(function(){if($(this).height()>highestBox){highestBox=$(this).height();contentHeight=$(this).find('.pp-content-post-data').outerHeight();}});postElements.height(highestBox);}},_gridLayoutMatchHeightSimple:function(){if(!this.matchHeight){return;}
if($(this.wrapperClass).hasClass('pp-css-grid')){return;}
if('style-9'===this.style){return;}
var highestBox=0;var contentHeight=0;var postElements=$(this.postClass);var columns=this._getColumns();if(1===columns&&this.settings.layout==='grid'){return;}
postElements.css('height','').each(function(){if($(this).height()>highestBox){highestBox=$(this).height();contentHeight=$(this).find('.pp-content-post-data').outerHeight();}});postElements.height(highestBox);},_initPagination:function(){var self=this;setTimeout(function(){self._getTotalPages();if(self.settings.pagination==='load_more'){self._initLoadMore();}
if(self.settings.pagination==='scroll'&&typeof FLBuilder==='undefined'){self._initScroll();}},500);},_getTotalPages:function(){var pages=$(this.nodeClass+' .pp-content-grid-pagination').find('li .page-numbers:not(.next)');if(pages.length>1){var total=pages.last().text().replace(/\D/g,'')
this.totalPages=parseInt(total);}else{this.totalPages=1;}
return this.totalPages;},_initLoadMore:function(){var self=this,$button=$(this.nodeClass).find('.pp-grid-load-more-button'),currentPage=self.currentPage,activeFilter=self.activeFilter,isAjaxPagination='dynamic'===self.filterType;if(!self.filters||'dynamic'!==self.filterType){activeFilter='';}
$(self.nodeClass).on('grid.filter.change',function(){if(self.filters&&'dynamic'===self.filterType){activeFilter=self.activeFilter}});$button.off('click').on('click',function(e){e.preventDefault();$(this).addClass('disabled loading');self.isFiltering=false;self.paginating=true;currentPage=parseInt(currentPage)+1;self._getPosts(activeFilter,self.filterData,currentPage);self.currentPage=currentPage;});$(self.nodeClass).on('grid.rendered',function(){$button.removeClass('disabled loading');if(currentPage>=self.totalPages){$button.parent().hide();}});$(self.nodeClass).on('grid.filter.complete',function(){if($(self.nodeClass).find('.pp-content-grid-pagination').length>0){self._getTotalPages();self.currentPage=currentPage=1;$button.parent().show();}else{$button.parent().hide();}});},_initScroll:function(){var self=this,gridOffset=$(this.wrapperClass).offset(),gridHeight=$(this.wrapperClass).height(),winHeight=$(window).height(),currentPage=this.currentPage,activeFilter=self.activeFilter,rendered=false,loaded=false;if(self.scrollPaginationIninitiated){return;}
if(!self.filters||'dynamic'!==self.filterType){activeFilter='';}
$(window).on('scroll',function(){if(loaded){return;}
var scrollPos=$(window).scrollTop();if(scrollPos>=gridOffset.top-(winHeight-gridHeight)){self.isFiltering=false;currentPage=parseInt(currentPage)+1;$(self.nodeClass).find('.pp-content-grid-loader').show();if(currentPage<=self.totalPages){loaded=true;self.paginating=true;self._getPosts(activeFilter,self.filterData,currentPage);}else{loaded=true;$(self.nodeClass).find('.pp-content-grid-loader').hide();}
self.currentPage=currentPage;}}.bind(this));$(self.nodeClass).on('grid.filter.change',function(){if(self.filters&&'dynamic'===self.filterType){activeFilter=self.activeFilter}
gridHeight=$(self.wrapperClass).height();self._gridLayoutMatchHeightSimple();if($(self.wrapperClass).data('isotope')){$(self.wrapperClass).isotope('layout');}
if('dynamic'===self.filterType){self._getTotalPages();self.currentPage=currentPage=1;loaded=false;}});$(self.nodeClass).on('grid.rendered',function(){gridHeight=$(self.wrapperClass).height();if(!rendered){self._getTotalPages();}
$(self.nodeClass).find('.pp-content-grid-loader').hide();setTimeout(function(){self._gridLayoutMatchHeightSimple();if($(self.wrapperClass).data('isotope')){$(self.wrapperClass).isotope('layout');}},500);if(currentPage>=self.totalPages){loaded=true;}else{loaded=false;}
rendered=true;});$(self.nodeClass).on('grid.filter.complete',function(){if($(self.nodeClass).find('.pp-content-grid-pagination').length>0){self._getTotalPages();self.currentPage=currentPage=1;}});self.scrollPaginationIninitiated=true;},_reLayout:function(){var self=this;var wrap=$(this.wrapperClass);var refreshLayout=function(){wrap.imagesLoaded(function(){if($('body').hasClass('fl-builder-active')){return;}
if(!self.masonry){self._gridLayoutMatchHeight();}
setTimeout(function(){if(wrap.data('isotope')){wrap.isotope('destroy');}
self.layoutRefreshed=true;self._gridLayout();self._initPagination();},500);});};$(document).on('sf:ajaxfinish','.searchandfilter',refreshLayout);$(document).on('facetwp-loaded',function(){if('undefined'!==typeof FWPBB&&'undefined'!==typeof FWPBB.modules){FWPBB.modules[self.settings.id]=self.settings;}
refreshLayout();});$(window).on('wpgb.loaded',function(){if('undefined'===typeof WP_Grid_Builder){return;}
if('undefined'===typeof WP_Grid_Builder['on']){return;}
WP_Grid_Builder.on('init',function(wpgb){if(wpgb.facets&&'undefined'!==typeof wpgb.facets['on']){wpgb.facets.on('appended',refreshLayout);}});});}};})(jQuery);var ppcg_jwz3igrv5lfs='';;(function($){var left_arrow_svg='<span aria-hidden="true"><svg role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 192 512"><path fill="currentColor" d="M25.1 247.5l117.8-116c4.7-4.7 12.3-4.7 17 0l7.1 7.1c4.7 4.7 4.7 12.3 0 17L64.7 256l102.2 100.4c4.7 4.7 4.7 12.3 0 17l-7.1 7.1c-4.7 4.7-12.3 4.7-17 0L25 264.5c-4.6-4.7-4.6-12.3.1-17z"></path></svg></span><span class="sr-only">Previous</span>';var right_arrow_svg='<span aria-hidden="true"><svg role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 192 512"><path fill="currentColor" d="M166.9 264.5l-117.8 116c-4.7 4.7-12.3 4.7-17 0l-7.1-7.1c-4.7-4.7-4.7-12.3 0-17L127.3 256 25.1 155.6c-4.7-4.7-4.7-12.3 0-17l7.1-7.1c4.7-4.7 12.3-4.7 17 0l117.8 116c4.6 4.7 4.6 12.3-.1 17z"></path></svg></span><span class="sr-only">Next</span>';var PPContentGridOptions={id:'jwz3igrv5lfs',layout:'grid',style:'custom',scrollTo:true,fields:{"layout":"grid","post_grid_style_select":"custom","alternate_content":"no","custom_layout":{"html":"<div class=\"pp-content-grid-post-image\">\n \n  [wpbb-if post:custom_field key='link'] \n<a href=\"[wpbb post:custom_field key='link']\" target=\"_blank\">\t[wpbb post:featured_image size=\"portfolio\" display=\"tag\" linked=\"no\"]<\/a>\n[wpbb-else] \n \n<a href=\"[wpbb post:pods_display field='upload']\" download=\"[wpbb post:title]\">\t[wpbb post:featured_image size=\"portfolio\" display=\"tag\" linked=\"no\"]<\/a>\n[\/wpbb-if]\n<\/div>\n\n\n<div class=\"pp-content-grid-post-text\">\n [wpbb-if post:custom_field key='link'] \n    <h3 class=\"pp-content-grid-post-title\"><a href=\"[wpbb post:custom_field key='link']\"  target=\"_blank\">[wpbb post:title]<\/a><\/h3>\n[wpbb-else] \n   <h3 class=\"pp-content-grid-post-title\"><a href=\"[wpbb post:pods_display field='upload']\">[wpbb post:title]<\/a><\/h3>\n[\/wpbb-if]\n\n    <div class=\"pp-content-grid-post-excerpt\">\n   <div class=\"pub\">   [wpbb post:custom_field key='author_source']<\/div>  \n\n    \t[wpbb post:content]\n    <\/div>\n\n  \n\n<\/div>\n","css":".pp-content-grid-post {\n    font-size: 16px;\n}\n.pp-content-grid-post-image {\n    padding: 0px;\n    padding-bottom: 0;\n    \n}\n.pp-content-grid-post-text {\n    padding: 0px;\n}\n.pp-content-grid-post-title {\n    font-size: 20px;\n\tline-height: 26px;\n\tmargin: 0;\n\tpadding: 10px 0 10px 0;\n\tcolor: #77b415;\n}\n.pp-content-grid-post-title a {\n    color: #77b415;\n}\n.pp-content-grid-post-meta {\n    padding: 0;\n}\n.pub {\n    color: #666;\n    font-style: italic;\n    padding-bottom: 10px;\n     font-size: 15px;\n}\n","connections":{"html":""}},"total_post":"all","total_posts_count":"20","posts_per_page":"6","facetwp":"disable","post_slider_arrow_font_size":"30","post_content_width":"60","post_content_width_large":"","post_content_width_medium":"","post_content_width_responsive":"","pagination":"numbers","load_more_text":"Load More","no_results_message":"No resources available.","show_search":"no","pagination_nofollow":"no","title_tag":"h3","bt_condition_type":"none","bt_display_value1":"","bt_display_relationship":"equals","bt_display_value2":"","bt_cookie_name":"","bt_cookie_relationship":"equals","bt_cookie_value":"","bt_url_text":"","bt_url_type":"exists","bt_url_value":"","bt_time_schedule":"none","bt_start_date":"","bt_start_time":{"hours":"01","minutes":"00","day_period":"am"},"bt_end_date":"","bt_end_time":{"hours":"01","minutes":"00","day_period":"am"},"bt_timezone":"UTC","bt_location_type":"countrycode","bt_location_condition":"equals","bt_location_name":"","bt_display_action":"hide","bt_default_visibility":"show","visibility_logic":"[]","bt_default_module":"","export":"","import":"","type":"pp-content-grid","responsive_display_filtered":true,"connections":{"arrow_color":"","arrow_hover_color":"","arrow_bg_color":"","arrow_bg_hover_color":"","arrow_border":"","arrow_border_hover_color":"","post_slider_dot_bg_color":"","post_slider_dot_bg_hover":"","custom_content":"","more_link_text":"","post_grid_filters_default":"","all_filter_label":"","fallback_image_custom":"","post_bg_color":"","post_bg_color_hover":"","post_border_group":"","post_border_group_large":"","post_border_group_medium":"","post_border_group_responsive":"","post_title_divider_color":"","post_category_bg_color":"","post_category_text_color":"","post_title_overlay_color":"","post_date_day_bg_color":"","post_date_day_text_color":"","post_date_month_bg_color":"","post_date_month_text_color":"","post_date_bg_color":"","post_date_text_color":"","product_rating_color":"","product_price_color":"","button_bg_color":"","button_bg_hover_color":"","button_text_color":"","button_text_hover_color":"","button_border_group":"","button_border_group_large":"","button_border_group_medium":"","button_border_group_responsive":"","button_border_hover_color":"","filter_bg_color":"","filter_bg_color_active":"","filter_text_color":"","filter_text_color_active":"","filter_border_group":"","filter_border_group_large":"","filter_border_group_medium":"","filter_border_group_responsive":"","filter_border_hover_color":"","filter_toggle_bg":"","filter_toggle_color":"","filter_toggle_border_group":"","pagination_bg_color":"","pagination_bg_color_hover":"","pagination_color":"","pagination_color_hover":"","pagination_border_group":"","pagination_border_group_large":"","pagination_border_group_medium":"","pagination_border_group_responsive":"","title_typography":"","title_typography_large":"","title_typography_medium":"","title_typography_responsive":"","title_font_color":"","title_font_hover_color":"","content_typography":"","content_typography_large":"","content_typography_medium":"","content_typography_responsive":"","content_font_color":"","content_font_hover_color":"","meta_typography":"","meta_typography_large":"","meta_typography_medium":"","meta_typography_responsive":"","post_meta_font_color":"","post_meta_font_hover_color":"","post_meta_bg_color":"","event_date_color":"","event_venue_color":"","event_cost_color":"","button_typography":"","button_typography_large":"","button_typography_medium":"","button_typography_responsive":"","filter_typography":"","filter_typography_large":"","filter_typography_medium":"","filter_typography_responsive":"","bt_display_value1":"","bt_display_value2":"","bt_cookie_name":"","bt_cookie_value":"","bt_url_text":"","bt_url_value":"","bt_start_date":"","bt_start_time":"","bt_end_date":"","bt_end_time":"","bt_location_name":""},"pods_source_type":"pods_settings_relation","pods_source_settings_relation":"","data_source":"custom_query","data_source_acf_relational_type":"relationship","data_source_acf_relational_key":"","data_source_acf_order":"DESC","data_source_acf_order_by":"post__in","data_source_acf_order_by_meta_key":"","post_type":["resource"],"order_by":"title","order_by_meta_key":"","order":"ASC","offset":"0","exclude_current_post":"no","posts_post_matching":"1","posts_post":"","tax_post_category_matching":"1","tax_post_category":"","tax_post_post_tag_matching":"1","tax_post_post_tag":"","posts_page_matching":"1","posts_page":"","posts_wpdmpro_matching":"1","posts_wpdmpro":"","tax_wpdmpro_wpdmcategory_matching":"1","tax_wpdmpro_wpdmcategory":"","tax_wpdmpro_wpdmtag_matching":"1","tax_wpdmpro_wpdmtag":"","posts_news_matching":"1","posts_news":"","tax_news_news_type_matching":"1","tax_news_news_type":"","posts_portfolio_matching":"1","posts_portfolio":"","tax_portfolio_industry_matching":"1","tax_portfolio_industry":"","posts_testimonial_matching":"1","posts_testimonial":"","users_matching":"1","users":"","custom_field_relation":"AND","custom_field":[""],"show_title":"yes","show_content":"yes","content_type":"excerpt","custom_content":"","content_length":"300","more_link_type":"box","more_link_text":"Read More","link_target_new":"no","post_grid_filters_display":"yes","post_grid_filters_type":"dynamic","post_grid_filters_terms":"","post_grid_filters_archive_terms":"","post_grid_filters_default":"","all_filter_label":"All","post_grid_filters_order_by":"name","post_grid_filters_order_by_meta_key":"","post_grid_filters_order":"ASC","show_image":"yes","image_thumb_size":"large","image_thumb_crop":"","fallback_image":"default","fallback_image_custom":"","show_author":"yes","show_date":"yes","show_categories":"no","meta_separator":" | ","terms_separator":" \/ ","as_values_posts_post":"","as_values_tax_post_category":"","as_values_tax_post_post_tag":"","as_values_posts_page":"","as_values_posts_wpdmpro":"","as_values_tax_wpdmpro_wpdmcategory":"","as_values_tax_wpdmpro_wpdmtag":"","as_values_posts_news":"","as_values_tax_news_news_type":"","as_values_posts_portfolio":"","as_values_tax_portfolio_industry":"","as_values_posts_testimonial":"","as_values_users":"","post_grid_filters":"resource_category","fallback_image_custom_src":"","post_taxonomies":"","posts_resource_matching":"1","posts_resource":"","tax_resource_resource_category_matching":"1","tax_resource_resource_category":"","as_values_posts_resource":"","as_values_tax_resource_resource_category":"","post_grid_filters_post_type":"resource","posts_case_study_matching":"1","posts_case_study":"","tax_case_study_industry_matching":"1","tax_case_study_industry":"","tax_case_study_primary_objective_matching":"1","tax_case_study_primary_objective":"","as_values_posts_case_study":"","as_values_tax_case_study_industry":"","as_values_tax_case_study_primary_objective":""},pagination:'numbers',postSpacing:'30',postColumns:{"xl":3,"lg":3,"md":2,"sm":1},breakpoints:{"large":1200,"medium":992,"small":768},matchHeight:'yes',filters:true,defaultFilter:'',filterTax:'resource_category',filterType:'dynamic',};PPContentGridOptions=$.extend({},PPContentGridOptions,bb_powerpack.conditionals);$(function(){ppcg_jwz3igrv5lfs=new PPContentGrid(PPContentGridOptions);});var state=0;$(document).on('pp_expandable_row_toggle',function(e,selector){if(selector.is('.pp-er-open')&&state===0&&selector.parent().find('.pp-content-post-grid').length>0){if('undefined'!==typeof $.fn.isotope&&selector.parent().find('.pp-content-post-grid').data('isotope')){selector.parent().find('.pp-content-post-grid').isotope('layout');}
state=1;}});$(document).on('pp-tabs-switched',function(e,selector){if(selector.find('.pp-content-post-grid').length>0){var postsWrapper=selector.find('.pp-content-post-grid');ppcg_jwz3igrv5lfs._gridLayoutMatchHeight();if('undefined'!==typeof $.fn.isotope&&postsWrapper.data('isotope')){setTimeout(function(){postsWrapper.isotope('layout');},500);}}});})(jQuery);