/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */!function(name,definition){if(typeof module!='undefined'&&module.exports)module.exports=definition()
else if(typeof define=='function'&&define.amd)define(name,definition)
else this[name]=definition()}('bowser',function(){var t=true
function detect(ua){function getFirstMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[1])||'';}
function getSecondMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[2])||'';}
var iosdevice=getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),likeAndroid=/like android/i.test(ua),android=!likeAndroid&&/android/i.test(ua),nexusMobile=/nexus\s*[0-6]\s*/i.test(ua),nexusTablet=!nexusMobile&&/nexus\s*[0-9]+/i.test(ua),chromeos=/CrOS/.test(ua),silk=/silk/i.test(ua),sailfish=/sailfish/i.test(ua),tizen=/tizen/i.test(ua),webos=/(web|hpw)os/i.test(ua),windowsphone=/windows phone/i.test(ua),windows=!windowsphone&&/windows/i.test(ua),mac=!iosdevice&&!silk&&/macintosh/i.test(ua),linux=!android&&!sailfish&&!tizen&&!webos&&/linux/i.test(ua),edgeVersion=getFirstMatch(/edge\/(\d+(\.\d+)?)/i),versionIdentifier=getFirstMatch(/version\/(\d+(\.\d+)?)/i),tablet=/tablet/i.test(ua),mobile=!tablet&&/[^-]mobi/i.test(ua),xbox=/xbox/i.test(ua),result
if(/opera|opr|opios/i.test(ua)){result={name:'Opera',opera:t,version:versionIdentifier||getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}}
else if(/coast/i.test(ua)){result={name:'Opera Coast',coast:t,version:versionIdentifier||getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}}
else if(/yabrowser/i.test(ua)){result={name:'Yandex Browser',yandexbrowser:t,version:versionIdentifier||getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}}
else if(/ucbrowser/i.test(ua)){result={name:'UC Browser',ucbrowser:t,version:getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/mxios/i.test(ua)){result={name:'Maxthon',maxthon:t,version:getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/epiphany/i.test(ua)){result={name:'Epiphany',epiphany:t,version:getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/puffin/i.test(ua)){result={name:'Puffin',puffin:t,version:getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}}
else if(/sleipnir/i.test(ua)){result={name:'Sleipnir',sleipnir:t,version:getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/k-meleon/i.test(ua)){result={name:'K-Meleon',kMeleon:t,version:getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(windowsphone){result={name:'Windows Phone',windowsphone:t}
if(edgeVersion){result.msedge=t
result.version=edgeVersion}
else{result.msie=t
result.version=getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)}}
else if(/msie|trident/i.test(ua)){result={name:'Internet Explorer',msie:t,version:getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)}}else if(chromeos){result={name:'Chrome',chromeos:t,chromeBook:t,chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}else if(/chrome.+? edge/i.test(ua)){result={name:'Microsoft Edge',msedge:t,version:edgeVersion}}
else if(/vivaldi/i.test(ua)){result={name:'Vivaldi',vivaldi:t,version:getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i)||versionIdentifier}}
else if(sailfish){result={name:'Sailfish',sailfish:t,version:getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}}
else if(/seamonkey\//i.test(ua)){result={name:'SeaMonkey',seamonkey:t,version:getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)}}
else if(/firefox|iceweasel|fxios/i.test(ua)){result={name:'Firefox',firefox:t,version:getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)}
if(/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)){result.firefoxos=t}}
else if(silk){result={name:'Amazon Silk',silk:t,version:getFirstMatch(/silk\/(\d+(\.\d+)?)/i)}}
else if(/phantom/i.test(ua)){result={name:'PhantomJS',phantom:t,version:getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)}}
else if(/slimerjs/i.test(ua)){result={name:'SlimerJS',slimer:t,version:getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)}}
else if(/blackberry|\bbb\d+/i.test(ua)||/rim\stablet/i.test(ua)){result={name:'BlackBerry',blackberry:t,version:versionIdentifier||getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}}
else if(webos){result={name:'WebOS',webos:t,version:versionIdentifier||getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)};if(/touchpad\//i.test(ua)){result.touchpad=t;}}
else if(/bada/i.test(ua)){result={name:'Bada',bada:t,version:getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)};}
else if(tizen){result={name:'Tizen',tizen:t,version:getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||versionIdentifier};}
else if(/qupzilla/i.test(ua)){result={name:'QupZilla',qupzilla:t,version:getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||versionIdentifier}}
else if(/chromium/i.test(ua)){result={name:'Chromium',chromium:t,version:getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||versionIdentifier}}
else if(/chrome|crios|crmo/i.test(ua)){result={name:'Chrome',chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}
else if(android){result={name:'Android',version:versionIdentifier}}
else if(/safari|applewebkit/i.test(ua)){result={name:'Safari',safari:t}
if(versionIdentifier){result.version=versionIdentifier}}
else if(iosdevice){result={name:iosdevice=='iphone'?'iPhone':iosdevice=='ipad'?'iPad':'iPod'}
if(versionIdentifier){result.version=versionIdentifier}}
else if(/googlebot/i.test(ua)){result={name:'Googlebot',googlebot:t,version:getFirstMatch(/googlebot\/(\d+(\.\d+))/i)||versionIdentifier}}
else{result={name:getFirstMatch(/^(.*)\/(.*) /),version:getSecondMatch(/^(.*)\/(.*) /)};}
if(!result.msedge&&/(apple)?webkit/i.test(ua)){if(/(apple)?webkit\/537\.36/i.test(ua)){result.name=result.name||"Blink"
result.blink=t}else{result.name=result.name||"Webkit"
result.webkit=t}
if(!result.version&&versionIdentifier){result.version=versionIdentifier}}else if(!result.opera&&/gecko\//i.test(ua)){result.name=result.name||"Gecko"
result.gecko=t
result.version=result.version||getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)}
if(!result.msedge&&(android||result.silk)){result.android=t}else if(iosdevice){result[iosdevice]=t
result.ios=t}else if(mac){result.mac=t}else if(xbox){result.xbox=t}else if(windows){result.windows=t}else if(linux){result.linux=t}
var osVersion='';if(result.windowsphone){osVersion=getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);}else if(iosdevice){osVersion=getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);osVersion=osVersion.replace(/[_\s]/g,'.');}else if(android){osVersion=getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);}else if(result.webos){osVersion=getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);}else if(result.blackberry){osVersion=getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);}else if(result.bada){osVersion=getFirstMatch(/bada\/(\d+(\.\d+)*)/i);}else if(result.tizen){osVersion=getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);}
if(osVersion){result.osversion=osVersion;}
var osMajorVersion=osVersion.split('.')[0];if(tablet||nexusTablet||iosdevice=='ipad'||(android&&(osMajorVersion==3||(osMajorVersion>=4&&!mobile)))||result.silk){result.tablet=t}else if(mobile||iosdevice=='iphone'||iosdevice=='ipod'||android||nexusMobile||result.blackberry||result.webos||result.bada){result.mobile=t}
if(result.msedge||(result.msie&&result.version>=10)||(result.yandexbrowser&&result.version>=15)||(result.vivaldi&&result.version>=1.0)||(result.chrome&&result.version>=20)||(result.firefox&&result.version>=20.0)||(result.safari&&result.version>=6)||(result.opera&&result.version>=10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]>=6)||(result.blackberry&&result.version>=10.1)||(result.chromium&&result.version>=20)){result.a=t;}
else if((result.msie&&result.version<10)||(result.chrome&&result.version<20)||(result.firefox&&result.version<20.0)||(result.safari&&result.version<6)||(result.opera&&result.version<10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]<6)||(result.chromium&&result.version<20)){result.c=t}else result.x=t
return result}
var bowser=detect(typeof navigator!=='undefined'?navigator.userAgent:'')
bowser.test=function(browserList){for(var i=0;i<browserList.length;++i){var browserItem=browserList[i];if(typeof browserItem==='string'){if(browserItem in bowser){return true;}}}
return false;}
function getVersionPrecision(version){return version.split(".").length;}
function map(arr,iterator){var result=[],i;if(Array.prototype.map){return Array.prototype.map.call(arr,iterator);}
for(i=0;i<arr.length;i++){result.push(iterator(arr[i]));}
return result;}
function compareVersions(versions){var precision=Math.max(getVersionPrecision(versions[0]),getVersionPrecision(versions[1]));var chunks=map(versions,function(version){var delta=precision-getVersionPrecision(version);version=version+new Array(delta+1).join(".0");return map(version.split("."),function(chunk){return new Array(20-chunk.length).join("0")+chunk;}).reverse();});while(--precision>=0){if(chunks[0][precision]>chunks[1][precision]){return 1;}
else if(chunks[0][precision]===chunks[1][precision]){if(precision===0){return 0;}}
else{return-1;}}}
function isUnsupportedBrowser(minVersions,strictMode,ua){var _bowser=bowser;if(typeof strictMode==='string'){ua=strictMode;strictMode=void(0);}
if(strictMode===void(0)){strictMode=false;}
if(ua){_bowser=detect(ua);}
var version=""+_bowser.version;for(var browser in minVersions){if(minVersions.hasOwnProperty(browser)){if(_bowser[browser]){return compareVersions([version,minVersions[browser]])<0;}}}
return strictMode;}
function check(minVersions,strictMode,ua){return!isUnsupportedBrowser(minVersions,strictMode,ua);}
bowser.isUnsupportedBrowser=isUnsupportedBrowser;bowser.compareVersions=compareVersions;bowser.check=check;bowser._detect=detect;return bowser});(function($){UABBTrigger={triggerHook:function(hook,args){$('body').trigger('uabb-trigger.'+hook,args);},addHook:function(hook,callback){$('body').on('uabb-trigger.'+hook,callback);},removeHook:function(hook,callback){$('body').off('uabb-trigger.'+hook,callback);},};})(jQuery);jQuery(document).ready(function($){if(typeof bowser!=='undefined'&&bowser!==null){var uabb_browser=bowser.name,uabb_browser_v=bowser.version,uabb_browser_class=uabb_browser.replace(/\s+/g,'-').toLowerCase(),uabb_browser_v_class=uabb_browser_class+parseInt(uabb_browser_v);$('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);}
$('.uabb-row-separator').parents('html').css('overflow-x','hidden');});jQuery(function($){$(function(){$('.fl-node-igucoknew2tj .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});;(function($){PPSearchForm=function(settings){this.id=settings.id;this.node=$('.fl-node-'+this.id);this.form=this.node.find('.pp-search-form');this.selectors={input:'.fl-node-'+this.id+' .pp-search-form__input',toggle:'.fl-node-'+this.id+' .pp-search-form__toggle',container:'.fl-node-'+this.id+' .pp-search-form__container',};this._init();};PPSearchForm.prototype={id:'',node:'',form:'',_init:function(){$(this.selectors.input).on('focus',function(){this.form.addClass('pp-search-form--focus');}.bind(this)).on('blur',function(){this.form.removeClass('pp-search-form--focus');}.bind(this));$(this.selectors.toggle).on('click',function(){$(this.selectors.container).addClass('pp-search-form--lightbox').find('.pp-search-form__input').trigger('focus');this._focus(this.form);}.bind(this));this.form.find('.pp-search-form--lightbox-close').on('click',function(){$(this.selectors.container).removeClass('pp-search-form--lightbox');}.bind(this));$(document).on('keyup',function(e){if(27==e.which&&this.form.find('.pp-search-form--lightbox').length>0){$(this.selectors.container).removeClass('pp-search-form--lightbox');}}.bind(this));},_focus:function(form){var $el=form.find('.pp-search-form__input');if($el[0].setSelectionRange){var len=$el.val().length*2;setTimeout(function(){$el[0].setSelectionRange(len,len);},1);}else{$el.val($el.val());}}};})(jQuery);(function($){new PPSearchForm({id:'0n1myqhvip6g',});})(jQuery);;jQuery(function($){$(function(){$('.fl-node-t6iuazvm7qoe .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});(function($){new PPSearchForm({id:'lj1yer6c3tqo',});})(jQuery);;(function($){PPAdvancedMenu=function(settings){this.settingsId=settings.id;this.nodeClass='.fl-node-'+settings.id;this.wrapperClass=this.nodeClass+' .pp-advanced-menu';this.type=settings.type;this.mobileToggle=settings.mobile;this.mobileBelowRow='below'===settings.menuPosition;this.breakpoints=settings.breakpoints;this.mobileBreakpoint=settings.mobileBreakpoint;this.mediaBreakpoint=settings.mediaBreakpoint;this.mobileMenuType=settings.mobileMenuType;this.offCanvasDirection=settings.offCanvasDirection;this.postId=bb_powerpack.post_id;this.isBuilderActive=settings.isBuilderActive;this.currentBrowserWidth=window.innerWidth;this.fullScreenMenu=null;this.offCanvasMenu=null;this.$submenus=null;$(this._initMenu.bind(this));$(window).on('resize',function(e){var width=window.innerWidth;if(width!=this.currentBrowserWidth){this._initMenu();this._clickOrHover();this.currentBrowserWidth=width;}}.bind(this));$('body').on('click',function(e){if('undefined'!==typeof FLBuilderConfig){return;}
if($(this.wrapperClass).find('.pp-advanced-menu-mobile-toggle').hasClass('pp-active')&&('expanded'!==this.mobileToggle)){if($(e.target).parents('.fl-module-pp-advanced-menu').length>0){return;}
if($(e.target).is('input')&&$(e.target).parents('.pp-advanced-menu').length>0){return;}
if($(e.target).hasClass('pp-menu-close-btn')){return;}
$(this.wrapperClass).find('.pp-advanced-menu-mobile-toggle').trigger('click');}
$(this.wrapperClass).find('.pp-has-submenu').removeClass('focus pp-active');$(this.wrapperClass).find('.pp-has-submenu .sub-menu').removeClass('focus');$(this.wrapperClass).find('.pp-has-submenu-container').removeClass('focus');$(this.wrapperClass).find('.pp-menu-toggle').attr('aria-expanded',false);}.bind(this));$(document).on('keyup',function(e){if(27==e.which){$(this.wrapperClass).find('.pp-has-submenu').removeClass('focus pp-active');$(this.wrapperClass).find('.pp-has-submenu .sub-menu').removeClass('focus');$(this.wrapperClass).find('.pp-has-submenu-container').removeClass('focus');$(this.wrapperClass).find('.pp-menu-toggle').attr('aria-expanded',false);if($(this.wrapperClass).find('.pp-menu-toggle.focus').is(':visible')){$(this.wrapperClass).find('.pp-menu-toggle.focus').delay(100).trigger('focus');}}}.bind(this));};PPAdvancedMenu.prototype={nodeClass:'',wrapperClass:'',type:'',breakpoints:{},$submenus:null,fullScreenMenu:null,offCanvasMenu:null,_isMobile:function(){return window.innerWidth<=this.breakpoints.small?true:false;},_isMedium:function(){return window.innerWidth<=this.breakpoints.medium?true:false;},_isLarge:function(){return window.innerWidth<=this.breakpoints.large?true:false;},_isCustom:function(){return window.innerWidth<=this.breakpoints.custom?true:false;},_isTouch:function(){var prefixes=' -webkit- -moz- -o- -ms- '.split(' ');var mq=function(query){return window.matchMedia(query).matches;}
if(('ontouchstart'in window)||window.DocumentTouch&&document instanceof DocumentTouch){return true;}
var query=['(',prefixes.join('touch-enabled),('),'heartz',')'].join('');return mq(query);},_isMenuToggle:function(){if(('always'==this.mobileBreakpoint||(this._isMobile()&&'mobile'==this.mobileBreakpoint)||(this._isMedium()&&'medium-mobile'==this.mobileBreakpoint)||(this._isCustom()&&'custom'==this.mobileBreakpoint))&&($(this.nodeClass).find('.pp-advanced-menu-mobile-toggle').is(':visible')||'expanded'==this.mobileToggle)){return true;}
return false;},_bindSettingsFormEvents:function(){},_initMenu:function(){if(this.mobileToggle!='expanded'){this._initOffCanvas();this._initFullScreen();}
this._setupSubmenu();this._menuOnHover();this._menuOnFocus();this._submenuOnClick();if($(this.nodeClass).length&&this.type=='horizontal'){this._initMegaMenus();}
if(this.type=='horizontal'||this.type=='vertical'){var self=this;$(this.wrapperClass).find('.pp-has-submenu-container').on('click',function(e){if(self.mobileMenuType!=='off-canvas'&&self.mobileMenuType!=='full-screen'){if(self._isTouch()){if(!$(this).hasClass('first-click')){e.preventDefault();$(this).addClass('first-click');}}}});$(this.wrapperClass).find('li.pp-has-submenu a').on('keyup',function(e){if($(e.target).hasClass('pp-menu-toggle')&&!$(this.nodeClass).find('.pp-advanced-menu-mobile-toggle').is(':visible')){if(e.which==1||e.which==13||e.which==undefined){e.preventDefault();e.stopPropagation();$(e.target).parents('li.pp-has-submenu').toggleClass('pp-active');if($(e.target).parents('li.pp-has-submenu').hasClass('pp-active')){$(e.target).attr('aria-expanded',true);}else{$(e.target).attr('aria-expanded',false);}}}}.bind(this));}
if(this._isMenuToggle()||this.type=='accordion'){$(this.wrapperClass).off('mouseenter mouseleave');this._menuOnClick();this._clickOrHover();}else{$(this.wrapperClass).off('click');this._submenuOnRight();this._submenuRowZindexFix();}
if(this.mobileToggle!='expanded'){this._toggleForMobile();}
$(this.wrapperClass).find('li:not(.menu-item-has-children)').on('click','a',function(e){if($(e.target).closest('.pp-menu-search-item').length>0){return;}
$(this.nodeClass).find('.pp-advanced-menu').removeClass('menu-open');$(this.nodeClass).find('.pp-advanced-menu').addClass('menu-close');$('html').removeClass('pp-off-canvas-menu-open');$('html').removeClass('pp-full-screen-menu-open');}.bind(this));if($(this.wrapperClass).find('.pp-menu-search-item').length){this._toggleMenuSearch();}
if($(this.wrapperClass).find('.pp-menu-cart-item').length){this._wooUpdateParams();}},_setupSubmenu:function(){$(this.wrapperClass+' ul.sub-menu').each(function(){$(this).closest('li').attr('aria-haspopup','true');});},_menuOnHover:function(){$(this.wrapperClass).on('mouseenter','li.menu-item',function(){$(this).addClass('hover');}).on('mouseleave','li.menu-item',function(){$(this).removeClass('hover');});},_menuOnFocus:function(){$(this.nodeClass).off('focus').on('focus','a',function(e){var $menuItem=$(e.target).parents('.menu-item').first(),$parents=$(e.target).parentsUntil(this.wrapperClass);$('.pp-advanced-menu .focus:not(.pp-menu-toggle)').removeClass('focus');$menuItem.addClass('focus');$parents.addClass('focus');}.bind(this)).on('focusout','a',function(e){if($('.pp-advanced-menu .focus').hasClass('pp-has-submenu')){$(e.target).parentsUntil(this.wrapperClass).find('.pp-has-submenu-container').removeClass('first-click');}}.bind(this));$(this.nodeClass).off('focus','.pp-menu-toggle').on('focus','.pp-menu-toggle',function(e){$(e.target).addClass('focus');}.bind(this)).off('blur','.pp-menu-toggle').on('blur','.pp-menu-toggle',function(e){if($(e.target).parents('li.pp-has-submenu.pp-active').length===0||$(e.target).parents('li.pp-has-submenu.pp-active').parent('ul.menu').length===0){$(e.target).removeClass('focus');}}.bind(this));},_menuOnClick:function(){var self=this;var $mainItem='';$(this.wrapperClass).off().on('click.pp-advanced-menu keyup','.pp-has-submenu-container',function(e){var isValidEvent=e.which==1||e.which==13||e.which==undefined;if(!isValidEvent){return;}
if(e.which==13&&!$(e.target).hasClass('pp-menu-toggle')){return;}
if(self._isTouch()){if(!$(this).hasClass('first-click')){e.preventDefault();$(this).addClass('first-click');}}
e.stopPropagation();var isMainEl=$(e.target).parents('.menu-item').parent().parent().hasClass('pp-advanced-menu');if(isMainEl&&$mainItem===''){$mainItem=$(e.target).parents('.menu-item');}
var $link=$(e.target).parents('.pp-has-submenu').first(),$subMenu=$link.children('.sub-menu').first(),$href=$link.children('.pp-has-submenu-container').first().find('> a').attr('href'),$subMenuParents=$(e.target).parents('.sub-menu'),$activeParent=$(e.target).closest('.pp-has-submenu.pp-active');if($activeParent.length>0){$activeParent.find('.pp-menu-toggle').first().attr('aria-expanded',true);}else{$activeParent.find('.pp-menu-toggle').first().attr('aria-expanded',false);}
if(!$subMenu.is(':visible')||$(e.target).hasClass('pp-menu-toggle')||($subMenu.is(':visible')&&(typeof $href==='undefined'||$href=='#'))){if(!$(this.wrapperClass).hasClass('pp-advanced-menu-accordion-collapse')){e.preventDefault();}
if($(e.target).hasClass('pp-menu-toggle')){e.stopPropagation();e.preventDefault();}}
else{e.stopPropagation();window.location.href=$href;return;}
if($(this.wrapperClass).hasClass('pp-advanced-menu-accordion-collapse')){if($link.parents('.menu-item').length&&!$link.parents('.menu-item').hasClass('pp-active')){$('.menu .pp-active',this.wrapperClass).not($link).removeClass('pp-active');}
else if($link.parents('.menu-item').hasClass('pp-active')&&$link.parent('.sub-menu').length){$('.menu .pp-active',this.wrapperClass).not($link).not($activeParent).removeClass('pp-active');}
$('.sub-menu',this.wrapperClass).not($subMenu).not($subMenuParents).slideUp('normal');}
if($(self.wrapperClass).find('.sub-menu:visible').length>0){$(self.wrapperClass).find('.sub-menu:visible').parent().addClass('pp-active');}
$subMenu.slideToggle(400,function(){$(e.target).parents('.pp-has-submenu-container').parent().parent().find('> .menu-item.pp-active').removeClass('pp-active');if($mainItem!==''){$mainItem.parent().find('.menu-item.pp-active').removeClass('pp-active');$(self.wrapperClass).find('.sub-menu').parent().removeClass('pp-active');if($(self.wrapperClass).find('.sub-menu:visible').length>0){$(self.wrapperClass).find('.sub-menu:visible').parent().addClass('pp-active');}else{$link.toggleClass('pp-active');$mainItem.removeClass('pp-active');}}else{$link.toggleClass('pp-active');}
if(!$subMenu.is(':visible')){$subMenu.parent().removeClass('pp-active');$subMenu.parent().find('> .pp-has-submenu-container .pp-menu-toggle').attr('aria-expanded',false);}else{$subMenu.parent().find('> .pp-has-submenu-container .pp-menu-toggle').attr('aria-expanded',true);}});}.bind(this));},_submenuOnClick:function(){$('body').off('click',this.wrapperClass+' .sub-menu a').on('click',this.wrapperClass+' .sub-menu a',function(e){if($(e.target).parent().hasClass('focus')){$(e.target).parentsUntil(this.wrapperClass).removeClass('focus');}}.bind(this));},_clickOrHover:function(){this.$submenus=this.$submenus||$(this.wrapperClass).find('.sub-menu');var $wrapper=$(this.wrapperClass),$menu=$wrapper.find('.menu');$li=$wrapper.find('.pp-has-submenu');if(this._isMenuToggle()){$li.each(function(){if(!$(this).hasClass('pp-active')){$(this).find('.sub-menu').fadeOut();}});}else{$li.each(function(){if(!$(this).hasClass('pp-active')){$(this).find('.sub-menu').css({'display':'','opacity':''});}});}},_submenuOnRight:function(){$(this.wrapperClass).on('mouseenter focus','.pp-has-submenu',function(e){if($(e.currentTarget).find('.sub-menu').length===0){return;}
var $link=$(e.currentTarget),$parent=$link.parent(),$subMenu=$link.find('.sub-menu'),subMenuWidth=$subMenu.width(),subMenuPos=0,winWidth=window.innerWidth;if($link.closest('.pp-menu-submenu-right').length!==0){$link.addClass('pp-menu-submenu-right');}else if($('body').hasClass('rtl')){subMenuPos=$parent.is('.sub-menu')?$parent.offset().left-subMenuWidth:$link.offset().left-subMenuWidth;if(subMenuPos<=0){$link.addClass('pp-menu-submenu-right');}}else{subMenuPos=$parent.is('.sub-menu')?$parent.offset().left+$parent.width()+subMenuWidth:$link.offset().left+subMenuWidth;if(subMenuPos>winWidth){$link.addClass('pp-menu-submenu-right');}}}.bind(this)).on('mouseleave','.pp-has-submenu',function(e){$(e.currentTarget).removeClass('pp-menu-submenu-right');}.bind(this));},_submenuRowZindexFix:function(e){$(this.wrapperClass).on('mouseenter','ul.menu > .pp-has-submenu',function(e){if($(e.currentTarget).find('.sub-menu').length===0){return;}
$(this.nodeClass).closest('.fl-row').find('.fl-row-content').css('z-index','10');}.bind(this)).on('mouseleave','ul.menu > .pp-has-submenu',function(e){$(this.nodeClass).closest('.fl-row').find('.fl-row-content').css('z-index','');}.bind(this));},_toggleForMobile:function(){var $wrapper=null,$menu=null,self=this;if(this._isMenuToggle()){$wrapper=$(this.wrapperClass);if(this._isMobileBelowRowEnabled()){this._placeMobileMenuBelowRow();$menu=$(this.nodeClass+'-clone');$menu.find('ul.menu').show();}else{$menu=$wrapper.find('.menu');}
if(!$wrapper.find('.pp-advanced-menu-mobile-toggle').hasClass('pp-active')&&this.mobileMenuType==='default'){$menu.css({display:'none'});}
$wrapper.on('click','.pp-advanced-menu-mobile-toggle',function(e){$(this).toggleClass('pp-active');if($(this).hasClass('pp-active')){$(this).attr('aria-expanded','true');$menu.addClass('pp-menu-visible');}else{$(this).attr('aria-expanded','false');$menu.removeClass('pp-menu-visible');}
$menu.slideToggle();e.stopPropagation();});$menu.on('click','.menu-item > a[href*="#"]',function(e){var $href=$(this).attr('href'),$targetID='';if($href!=='#'){$targetID=$href.split('#')[1];if($('body').find('#'+$targetID).length>0){e.preventDefault();$(this).toggleClass('pp-active');setTimeout(function(){$('html, body').animate({scrollTop:$('#'+$targetID).offset().top},1000,function(){window.location.hash=$targetID;});},500);if(!self._isMenuToggle()){$menu.slideToggle();}}}});}
else{if(this._isMobileBelowRowEnabled()){this._removeMenuFromBelowRow();}
$wrapper=$(this.wrapperClass),$menu=$wrapper.children('.menu');$wrapper.find('.pp-advanced-menu-mobile-toggle').removeClass('pp-active');$menu.css({display:''});}},_initMegaMenus:function(){var module=$(this.nodeClass),rowContent=module.closest('.fl-row-content'),rowWidth=rowContent.width(),megas=module.find('.mega-menu'),disabled=module.find('.mega-menu-disabled'),isToggle=this._isMenuToggle();if(isToggle){megas.removeClass('mega-menu').addClass('mega-menu-disabled');module.find('li.mega-menu-disabled > ul.sub-menu').css('width','');rowContent.css('position','');}else{disabled.removeClass('mega-menu-disabled').addClass('mega-menu');module.find('li.mega-menu > ul.sub-menu').css('width',rowWidth+'px');rowContent.css('position','relative');}},_initOffCanvas:function(){if(this.mobileMenuType!=='off-canvas'){return;}
$('html').addClass('pp-off-canvas-menu-module');$('html').addClass('pp-off-canvas-menu-'+this.offCanvasDirection);if($(this.nodeClass).find('#pp-menu-'+this.settingsId).length===0){return;}
var menuHTML=$(this.nodeClass).find('#pp-menu-'+this.settingsId).html();if(null===this.offCanvasMenu){this.offCanvasMenu=$('<div id="pp-advanced-menu-off-canvas-'+this.settingsId+'" class="fl-node-'+this.settingsId+' pp-menu-off-canvas" />').html(menuHTML);}
if($('#pp-advanced-menu-off-canvas-'+this.settingsId).length===0&&null!==this.offCanvasMenu&&!this.isBuilderActive){this.offCanvasMenu.appendTo('body');}
$(this.nodeClass).trigger('pp-advanced-menu-off-canvas-init',[this.offCanvasMenu]);this._toggleMenu();},_initFullScreen:function(){if(this.mobileMenuType!=='full-screen'){return;}
$('html').addClass('pp-full-screen-menu-module');if($(this.nodeClass).find('#pp-menu-'+this.settingsId).length===0){return;}
var menuHTML=$(this.nodeClass).find('#pp-menu-'+this.settingsId).html();if(null===this.fullScreenMenu){this.fullScreenMenu=$('<div id="pp-advanced-menu-full-screen-'+this.settingsId+'" class="fl-node-'+this.settingsId+' pp-menu-full-screen" />').html(menuHTML);}
if($('#pp-advanced-menu-full-screen-'+this.settingsId).length===0&&null!==this.fullScreenMenu&&!this.isBuilderActive){this.fullScreenMenu.appendTo('body');}
$(this.nodeClass).trigger('pp-advanced-menu-full-screen-init',[this.fullScreenMenu]);this._toggleMenu();},_toggleMenu:function(){var self=this;var singleInstance=true;if(self.mobileMenuType==='full-screen'){var winHeight=window.innerHeight;$(self.nodeClass).find('.pp-menu-overlay').css('height',winHeight+'px');$(window).on('resize',function(){winHeight=window.innerHeight;$(self.nodeClass).find('.pp-menu-overlay').css('height',winHeight+'px');});}
$(self.nodeClass).find('.pp-advanced-menu-mobile-toggle').off('click').on('click',function(){if(singleInstance){if($('.pp-advanced-menu.menu-open').length>0){$('.pp-advanced-menu').removeClass('menu-open');$('html').removeClass('pp-full-screen-menu-open');}}
if($(self.nodeClass).find('.pp-advanced-menu').hasClass('menu-open')){$(self.nodeClass).find('.pp-advanced-menu').removeClass('menu-open');$(self.nodeClass).find('.pp-advanced-menu').addClass('menu-close');$('html').removeClass('pp-off-canvas-menu-open');$('html').removeClass('pp-full-screen-menu-open');}else{$(self.nodeClass).find('.pp-advanced-menu').addClass('menu-open');if(self.mobileMenuType==='off-canvas'){$('html').addClass('pp-off-canvas-menu-open');self.offCanvasMenu.find('nav').attr('tabindex','0').trigger('focus');$(this).attr('tabindex','-1').trigger('blur');}
if(self.mobileMenuType==='full-screen'){$('html').addClass('pp-full-screen-menu-open');self.fullScreenMenu.find('nav').attr('tabindex','0').trigger('focus');$(this).attr('tabindex','-1').trigger('blur');}}
if('0'==$(this).attr('tabindex')){$(this).attr('aria-expanded','false');}else{$(this).attr('aria-expanded','true');}});$(self.nodeClass).find('.pp-advanced-menu-mobile-toggle').on('keyup',function(e){if(13===e.keyCode||13===e.which){$(this).trigger('click');}});$(self.nodeClass).find('.pp-advanced-menu .pp-menu-close-btn, .pp-clear').on('click',function(){$(self.nodeClass).find('.pp-advanced-menu').removeClass('menu-open');$(self.nodeClass).find('.pp-advanced-menu').addClass('menu-close');$('html').removeClass('pp-off-canvas-menu-open');$('html').removeClass('pp-full-screen-menu-open');if($(self.nodeClass).find('.pp-advanced-menu-mobile-toggle').is(':visible')){setTimeout(function(){$(self.nodeClass).find('.pp-advanced-menu-mobile-toggle').attr('tabindex',0).attr('aria-expanded','false').trigger('focus');},120);}
if(self.offCanvasMenu&&self.offCanvasMenu.length>0){self.offCanvasMenu.find('nav').attr('tabindex','-1').trigger('blur');}
if(self.fullScreenMenu&&self.fullScreenMenu.length>0){self.fullScreenMenu.find('nav').attr('tabindex','-1').trigger('blur');}});if(this.isBuilderActive){setTimeout(function(){if($('.fl-builder-settings[data-node="'+self.settingsId+'"]').length>0){$('.pp-advanced-menu').removeClass('menu-open');$(self.nodeClass).find('.pp-advanced-menu-mobile-toggle').trigger('click');}},600);FLBuilder.addHook('settings-form-init',function(){if(!$('.fl-builder-settings[data-node="'+self.settingsId+'"]').length>0){return;}
if(!$(self.nodeClass).find('.pp-advanced-menu').hasClass('menu-open')){$('.pp-advanced-menu').removeClass('menu-open');$(self.nodeClass).find('.pp-advanced-menu-mobile-toggle').trigger('click');}});if($('html').hasClass('pp-full-screen-menu-open')&&!$(self.nodeClass).find('.pp-advanced-menu').hasClass('menu-open')){$('html').removeClass('pp-full-screen-menu-open');}
if($('html').hasClass('pp-off-canvas-menu-open')&&!$(self.nodeClass).find('.pp-advanced-menu').hasClass('menu-open')){$('html').removeClass('pp-off-canvas-menu-open');}}},_isMobileBelowRowEnabled:function(){if(this.mobileMenuType==='default'){return this.mobileBelowRow&&$(this.nodeClass).closest('.fl-col').length;}
return false;},_placeMobileMenuBelowRow:function(){if($(this.nodeClass+'-clone').length){return;}
var module=$(this.nodeClass),clone=null,row=module.closest('.fl-row-content');if(module.length<1){return;}
clone=(module.length>1)?$(module[0]).clone():module.clone();module.find('.pp-menu-nav').remove();clone.addClass((this.nodeClass+'-clone').replace('.',''));clone.addClass('pp-menu-mobile-clone');clone.find('.pp-advanced-menu-mobile').remove();row.append(clone);if(module.hasClass('fl-animation')){clone.removeClass('fl-animation');}
this._menuOnClick();},_removeMenuFromBelowRow:function(){if(!$(this.nodeClass+'-clone').length){return;}
var module=$(this.nodeClass),clone=$(this.nodeClass+'-clone'),menu=clone.find('.pp-menu-nav');module.find('.pp-advanced-menu-mobile').after(menu);module.find('.pp-advanced-menu-mobile-toggle').attr('aria-expanded',false);clone.remove();},_toggleMenuSearch:function(){var items=$(this.wrapperClass).find('.pp-menu-search-item'),self=this;items.each(function(){var item=$(this);var button=item.find('> a'),form=item.find('.pp-search-form'),input=item.find('.pp-search-form__input');button.on('click',function(e){e.preventDefault();item.toggleClass('pp-search-active');if(item.hasClass('pp-search-active')){setTimeout(function(){input.focus();self._focusMenuSearch(input);},100);}
$('body').on('click.pp-menu-search',self._hideMenuSearch.bind(self));});input.on('focus',function(){form.addClass('pp-search-form--focus');}).on('blur',function(){form.removeClass('pp-search-form--focus');});});},_hideMenuSearch:function(e){if(e!==undefined){if($(e.target).closest('.pp-menu-search-item').length>0){return;}}
$(this.wrapperClass).find('.pp-menu-search-item').removeClass('pp-search-active');$('body').off('click.pp-menu-search');},_focusMenuSearch:function($el){if($el[0].setSelectionRange){var len=$el.val().length*2;setTimeout(function(){$el[0].setSelectionRange(len,len);},1);}else{$el.val($el.val());}},_wooUpdateParams:function(){if('undefined'!==typeof wc_cart_fragments_params){wc_cart_fragments_params.wc_ajax_url+='&pp-advanced-menu-node='+this.settingsId+'&post-id='+this.postId;}
if('undefined'!==typeof wc_add_to_cart_params){wc_add_to_cart_params.wc_ajax_url+='&pp-advanced-menu-node='+this.settingsId+'&post-id='+this.postId;}},_validClick:function(e){return(e.which==1||e.which==13||e.which==32||e.which==undefined)?true:false;}};})(jQuery);var pp_menu_8odmg3zwuf49;(function($){pp_menu_8odmg3zwuf49=new PPAdvancedMenu({id:'8odmg3zwuf49',type:'horizontal',mobile:'hamburger-label',menuPosition:'below',breakpoints:{large:1200,medium:992,small:768,custom:768},mobileBreakpoint:'medium-mobile',mediaBreakpoint:'992',mobileMenuType:'off-canvas',offCanvasDirection:'left',fullScreenAnimation:'',isBuilderActive:false});})(jQuery);var pp_menu_a4evohm9ifw0;(function($){pp_menu_a4evohm9ifw0=new PPAdvancedMenu({id:'a4evohm9ifw0',type:'horizontal',mobile:'hamburger-label',menuPosition:'below',breakpoints:{large:1200,medium:992,small:768,custom:768},mobileBreakpoint:'medium-mobile',mediaBreakpoint:'992',mobileMenuType:'off-canvas',offCanvasDirection:'left',fullScreenAnimation:'',isBuilderActive:false});})(jQuery);(function($){FLThemeBuilderHeaderLayout={win:null,body:null,header:null,overlay:false,hasAdminBar:false,stickyOn:'',breakpointWidth:0,init:function(){var editing=$('html.fl-builder-edit').length,header=$('.fl-builder-content[data-type=header]'),menuModule=header.find('.fl-module-menu'),breakpoint=null;if(!editing&&header.length){header.imagesLoaded($.proxy(function(){this.win=$(window);this.body=$('body');this.header=header.eq(0);this.overlay=!!Number(header.attr('data-overlay'));this.hasAdminBar=!!$('body.admin-bar').length;this.stickyOn=this.header.data('sticky-on');breakpoint=this.header.data('sticky-breakpoint');if(''==this.stickyOn){if(typeof FLBuilderLayoutConfig.breakpoints[breakpoint]!==undefined){this.breakpointWidth=FLBuilderLayoutConfig.breakpoints[breakpoint];}
else{this.breakpointWidth=FLBuilderLayoutConfig.breakpoints.medium;}}
if(Number(header.attr('data-sticky'))){this.header.data('original-top',this.header.offset().top);this.win.on('resize',$.throttle(500,$.proxy(this._initSticky,this)));this._initSticky();}},this));}},_initSticky:function(e){var header=$('.fl-builder-content[data-type=header]'),windowSize=this.win.width(),makeSticky=false;makeSticky=this._makeWindowSticky(windowSize);if(makeSticky||(this.breakpointWidth>0&&windowSize>=this.breakpointWidth)){this.win.on('scroll.fl-theme-builder-header-sticky',$.proxy(this._doSticky,this));if(e&&'resize'===e.type){if(this.header.hasClass('fl-theme-builder-header-sticky')){this._doSticky(e);}
this._adjustStickyHeaderWidth();}
if(Number(header.attr('data-shrink'))){this.header.data('original-height',this.header.outerHeight());this.win.on('resize',$.throttle(500,$.proxy(this._initShrink,this)));this._initShrink();}
this._initFlyoutMenuFix(e);}else{this.win.off('scroll.fl-theme-builder-header-sticky');this.win.off('resize.fl-theme-builder-header-sticky');this.header.removeClass('fl-theme-builder-header-sticky');this.header.removeAttr('style');this.header.parent().css('padding-top','0');}},_makeWindowSticky:function(windowSize){var makeSticky=false;switch(this.stickyOn){case'xl':makeSticky=windowSize>FLBuilderLayoutConfig.breakpoints['large'];break;case'':case'desktop':makeSticky=windowSize>=FLBuilderLayoutConfig.breakpoints['medium'];break;case'desktop-medium':makeSticky=windowSize>FLBuilderLayoutConfig.breakpoints['small'];break;case'large':makeSticky=windowSize>FLBuilderLayoutConfig.breakpoints['medium']&&windowSize<=FLBuilderLayoutConfig.breakpoints['large'];break;case'large-medium':makeSticky=windowSize>FLBuilderLayoutConfig.breakpoints['small']&&windowSize<=FLBuilderLayoutConfig.breakpoints['large'];break;case'medium':makeSticky=(windowSize<=FLBuilderLayoutConfig.breakpoints['medium']&&windowSize>FLBuilderLayoutConfig.breakpoints['small']);break;case'medium-mobile':makeSticky=(windowSize<=FLBuilderLayoutConfig.breakpoints['medium']);break;case'mobile':makeSticky=(windowSize<=FLBuilderLayoutConfig.breakpoints['small']);break;case'all':makeSticky=true;break;}
return makeSticky;},_doSticky:function(e){var winTop=Math.floor(this.win.scrollTop()),headerTop=Math.floor(this.header.data('original-top')),hasStickyClass=this.header.hasClass('fl-theme-builder-header-sticky'),hasScrolledClass=this.header.hasClass('fl-theme-builder-header-scrolled'),beforeHeader=this.header.prevAll('.fl-builder-content'),bodyTopPadding=parseInt(jQuery('body').css('padding-top')),winBarHeight=$('#wpadminbar').length?$('#wpadminbar').outerHeight():0,headerHeight=0;if(isNaN(bodyTopPadding)){bodyTopPadding=0;}
if(this.hasAdminBar&&this.win.width()>600){winTop+=Math.floor(winBarHeight);}
if(winTop>headerTop){if(!hasStickyClass){if(e&&('scroll'===e.type||'smartscroll'===e.type)){this.header.addClass('fl-theme-builder-header-sticky');if(this.overlay&&beforeHeader.length){this.header.css('top',winBarHeight);}}
if(!this.overlay){this._adjustHeaderHeight();}}}
else if(hasStickyClass){this.header.removeClass('fl-theme-builder-header-sticky');this.header.removeAttr('style');this.header.parent().css('padding-top','0');}
this._adjustStickyHeaderWidth();if(winTop>headerTop){if(!hasScrolledClass){this.header.addClass('fl-theme-builder-header-scrolled');}}else if(hasScrolledClass){this.header.removeClass('fl-theme-builder-header-scrolled');}
this._flyoutMenuFix(e);},_initFlyoutMenuFix:function(e){var header=this.header,menuModule=header.closest('.fl-menu'),flyoutMenu=menuModule.find('.fl-menu-mobile-flyout'),isPushMenu=menuModule.hasClass('fl-menu-responsive-flyout-push')||menuModule.hasClass('fl-menu-responsive-flyout-push-opacity'),isOverlay=menuModule.hasClass('fl-menu-responsive-flyout-overlay'),flyoutPos=menuModule.hasClass('fl-flyout-right')?'right':'left',flyoutParent=header.parent().is('header')?header.parent().parent():header.parent();isFullWidth=this.win.width()===header.width(),flyoutLayout='',activePos=250,headerPos=0;if(!flyoutMenu.length){return;}
if(this.win.width()>header.parent().width()){headerPos=(this.win.width()-header.width())/ 2;}
if(isOverlay){activePos=headerPos;}
else if(isPushMenu){activePos=activePos+headerPos;}
flyoutMenu.data('activePos',activePos);if(isPushMenu){flyoutLayout='push-'+flyoutPos;}
else if(isOverlay){flyoutLayout='overlay-'+flyoutPos;}
if(isPushMenu&&!$('html').hasClass('fl-theme-builder-has-flyout-menu')){$('html').addClass('fl-theme-builder-has-flyout-menu');}
if(!flyoutParent.hasClass('fl-theme-builder-flyout-menu-'+flyoutLayout)){flyoutParent.addClass('fl-theme-builder-flyout-menu-'+flyoutLayout);}
if(!header.hasClass('fl-theme-builder-flyout-menu-overlay')&&isOverlay){header.addClass('fl-theme-builder-flyout-menu-overlay');}
if(!header.hasClass('fl-theme-builder-header-full-width')&&isFullWidth){header.addClass('fl-theme-builder-header-full-width');}
else if(!isFullWidth){header.removeClass('fl-theme-builder-header-full-width');}
menuModule.on('click','.fl-menu-mobile-toggle',$.proxy(function(event){if(menuModule.find('.fl-menu-mobile-toggle.fl-active').length){$('html').addClass('fl-theme-builder-flyout-menu-active');event.stopImmediatePropagation();}
else{$('html').removeClass('fl-theme-builder-flyout-menu-active');}
this._flyoutMenuFix(event);},this));},_flyoutMenuFix:function(e){var header=this.header,menuModule=$(e.target).closest('.fl-menu'),flyoutMenu=menuModule.find('.fl-menu-mobile-flyout'),flyoutPos=menuModule.hasClass('fl-flyout-right')?'right':'left',menuOpacity=menuModule.find('.fl-menu-mobile-opacity'),isScroll='undefined'!==typeof e&&'scroll'===e.handleObj.type,activePos='undefined'!==typeof flyoutMenu.data('activePos')?flyoutMenu.data('activePos'):0,headerPos=(this.win.width()-header.width())/ 2,inactivePos=headerPos>0?activePos+4:254;if(!flyoutMenu.length){return;}
if(this.overlay){return;}
if($('.fl-theme-builder-flyout-menu-active').length){if(isScroll&&!flyoutMenu.hasClass('fl-menu-disable-transition')){flyoutMenu.addClass('fl-menu-disable-transition');}
if(header.hasClass('fl-theme-builder-header-sticky')){if(!isScroll){setTimeout($.proxy(function(){flyoutMenu.css(flyoutPos,'-'+activePos+'px');},this),1);}
else{flyoutMenu.css(flyoutPos,'-'+activePos+'px');}}
else{flyoutMenu.css(flyoutPos,'0px');}}
else{if(flyoutMenu.hasClass('fl-menu-disable-transition')){flyoutMenu.removeClass('fl-menu-disable-transition');}
if(header.hasClass('fl-theme-builder-flyout-menu-overlay')&&headerPos>0&&headerPos<250){if(header.hasClass('fl-theme-builder-header-sticky')){inactivePos=headerPos+254;}
else{inactivePos=254;}}
if(e&&e.type==='resize'){inactivePos=headerPos+254;}
flyoutMenu.css(flyoutPos,'-'+inactivePos+'px');}
if(e&&menuModule.is('.fl-menu-responsive-flyout-overlay')&&$.infinitescroll){e.stopImmediatePropagation();}
if(menuOpacity.length){if(header.hasClass('fl-theme-builder-header-sticky')){if('0px'===menuOpacity.css('left')){menuOpacity.css('left','-'+headerPos+'px');}}
else{menuOpacity.css('left','');}}},_adjustStickyHeaderWidth:function(){if($('body').hasClass('fl-fixed-width')){var parentWidth=this.header.parent().width();if(this.win.width()>=992){this.header.css({'margin':'0 auto','max-width':parentWidth,});}
else{this.header.css({'margin':'','max-width':'',});}}},_adjustHeaderHeight:function(){var beforeHeader=this.header.prevAll('.fl-builder-content'),beforeHeaderHeight=0,beforeHeaderFix=0,headerHeight=Math.floor(this.header.outerHeight()),bodyTopPadding=parseInt($('body').css('padding-top')),wpAdminBarHeight=0,totalHeaderHeight=0;if(isNaN(bodyTopPadding)){bodyTopPadding=0;}
if(beforeHeader.length){$.each(beforeHeader,function(){beforeHeaderHeight+=Math.floor($(this).outerHeight());});beforeHeaderFix=2;}
if(this.hasAdminBar&&this.win.width()<=600){wpAdminBarHeight=Math.floor($('#wpadminbar').outerHeight());}
totalHeaderHeight=Math.floor(beforeHeaderHeight+headerHeight);if(headerHeight>0){var headerParent=this.header.parent(),headerParentTopPadding=0;if($(headerParent).is('body')){headerParentTopPadding=Math.floor(headerHeight-wpAdminBarHeight);}else{headerParentTopPadding=Math.floor(headerHeight-bodyTopPadding-wpAdminBarHeight);}
$(headerParent).css('padding-top',(headerParentTopPadding-beforeHeaderFix)+'px');this.header.css({'-webkit-transform':'translate(0px, -'+totalHeaderHeight+'px)','-ms-transform':'translate(0px, -'+totalHeaderHeight+'px)','transform':'translate(0px, -'+totalHeaderHeight+'px)'});}},_initShrink:function(e){if(this.win.width()>=this.breakpointWidth){this.win.on('scroll.fl-theme-builder-header-shrink',$.proxy(this._doShrink,this));this._setImageMaxHeight();if(this.win.scrollTop()>0){this._doShrink();}}else{this.header.parent().css('padding-top','0');this.win.off('scroll.fl-theme-builder-header-shrink');this._removeShrink();this._removeImageMaxHeight();}},_doShrink:function(e){var winTop=this.win.scrollTop(),headerTop=this.header.data('original-top'),headerHeight=this.header.data('original-height'),shrinkImageHeight=this.header.data('shrink-image-height'),windowSize=this.win.width(),makeSticky=this._makeWindowSticky(windowSize),hasClass=this.header.hasClass('fl-theme-builder-header-shrink');if(this.hasAdminBar){winTop+=32;}
if(makeSticky&&(winTop>headerTop+headerHeight)){if(!hasClass){this.header.addClass('fl-theme-builder-header-shrink');this.header.find('img').each(function(i){var image=$(this),maxMegaMenu=image.closest('.max-mega-menu').length,imageInLightbox=image.closest('.fl-button-lightbox-content').length,imageInNavMenu=image.closest('li.menu-item').length;if(!(imageInLightbox||imageInNavMenu||maxMegaMenu)){image.css('max-height',shrinkImageHeight);}});this.header.find('.fl-row-content-wrap').each(function(){var row=$(this);if(parseInt(row.css('padding-bottom'))>5){row.addClass('fl-theme-builder-header-shrink-row-bottom');}
if(parseInt(row.css('padding-top'))>5){row.addClass('fl-theme-builder-header-shrink-row-top');}});this.header.find('.fl-module-content').each(function(){var module=$(this);if(parseInt(module.css('margin-bottom'))>5){module.addClass('fl-theme-builder-header-shrink-module-bottom');}
if(parseInt(module.css('margin-top'))>5){module.addClass('fl-theme-builder-header-shrink-module-top');}});}}else if(hasClass){this.header.find('img').css('max-height','');this._removeShrink();}
if('undefined'===typeof(e)&&$('body').hasClass('fl-fixed-width')){if(!this.overlay){this._adjustHeaderHeight();}}},_removeShrink:function(){var rows=this.header.find('.fl-row-content-wrap'),modules=this.header.find('.fl-module-content');rows.removeClass('fl-theme-builder-header-shrink-row-bottom');rows.removeClass('fl-theme-builder-header-shrink-row-top');modules.removeClass('fl-theme-builder-header-shrink-module-bottom');modules.removeClass('fl-theme-builder-header-shrink-module-top');this.header.removeClass('fl-theme-builder-header-shrink');},_setImageMaxHeight:function(){var head=$('head'),stylesId='fl-header-styles-'+this.header.data('post-id'),styles='',images=this.header.find('.fl-module-content img');if($('#'+stylesId).length){return;}
images.each(function(i){var image=$(this),height=image.height(),node=image.closest('.fl-module').data('node'),className='fl-node-'+node+'-img-'+i,maxMegaMenu=image.closest('.max-mega-menu').length,imageInLightbox=image.closest('.fl-button-lightbox-content').length,imageInNavMenu=image.closest('li.menu-item').length;if(!(imageInLightbox||imageInNavMenu||maxMegaMenu)){image.addClass(className);styles+='.'+className+' { max-height: '+(height?height:image[0].height)+'px }';}});if(''!==styles){head.append('<style id="'+stylesId+'">'+styles+'</style>');}},_removeImageMaxHeight:function(){$('#fl-header-styles-'+this.header.data('post-id')).remove();},};$(function(){FLThemeBuilderHeaderLayout.init();});})(jQuery);
/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */!function(name,definition){if(typeof module!='undefined'&&module.exports)module.exports=definition()
else if(typeof define=='function'&&define.amd)define(name,definition)
else this[name]=definition()}('bowser',function(){var t=true
function detect(ua){function getFirstMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[1])||'';}
function getSecondMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[2])||'';}
var iosdevice=getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),likeAndroid=/like android/i.test(ua),android=!likeAndroid&&/android/i.test(ua),nexusMobile=/nexus\s*[0-6]\s*/i.test(ua),nexusTablet=!nexusMobile&&/nexus\s*[0-9]+/i.test(ua),chromeos=/CrOS/.test(ua),silk=/silk/i.test(ua),sailfish=/sailfish/i.test(ua),tizen=/tizen/i.test(ua),webos=/(web|hpw)os/i.test(ua),windowsphone=/windows phone/i.test(ua),windows=!windowsphone&&/windows/i.test(ua),mac=!iosdevice&&!silk&&/macintosh/i.test(ua),linux=!android&&!sailfish&&!tizen&&!webos&&/linux/i.test(ua),edgeVersion=getFirstMatch(/edge\/(\d+(\.\d+)?)/i),versionIdentifier=getFirstMatch(/version\/(\d+(\.\d+)?)/i),tablet=/tablet/i.test(ua),mobile=!tablet&&/[^-]mobi/i.test(ua),xbox=/xbox/i.test(ua),result
if(/opera|opr|opios/i.test(ua)){result={name:'Opera',opera:t,version:versionIdentifier||getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}}
else if(/coast/i.test(ua)){result={name:'Opera Coast',coast:t,version:versionIdentifier||getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}}
else if(/yabrowser/i.test(ua)){result={name:'Yandex Browser',yandexbrowser:t,version:versionIdentifier||getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}}
else if(/ucbrowser/i.test(ua)){result={name:'UC Browser',ucbrowser:t,version:getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/mxios/i.test(ua)){result={name:'Maxthon',maxthon:t,version:getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/epiphany/i.test(ua)){result={name:'Epiphany',epiphany:t,version:getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/puffin/i.test(ua)){result={name:'Puffin',puffin:t,version:getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}}
else if(/sleipnir/i.test(ua)){result={name:'Sleipnir',sleipnir:t,version:getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/k-meleon/i.test(ua)){result={name:'K-Meleon',kMeleon:t,version:getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(windowsphone){result={name:'Windows Phone',windowsphone:t}
if(edgeVersion){result.msedge=t
result.version=edgeVersion}
else{result.msie=t
result.version=getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)}}
else if(/msie|trident/i.test(ua)){result={name:'Internet Explorer',msie:t,version:getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)}}else if(chromeos){result={name:'Chrome',chromeos:t,chromeBook:t,chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}else if(/chrome.+? edge/i.test(ua)){result={name:'Microsoft Edge',msedge:t,version:edgeVersion}}
else if(/vivaldi/i.test(ua)){result={name:'Vivaldi',vivaldi:t,version:getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i)||versionIdentifier}}
else if(sailfish){result={name:'Sailfish',sailfish:t,version:getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}}
else if(/seamonkey\//i.test(ua)){result={name:'SeaMonkey',seamonkey:t,version:getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)}}
else if(/firefox|iceweasel|fxios/i.test(ua)){result={name:'Firefox',firefox:t,version:getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)}
if(/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)){result.firefoxos=t}}
else if(silk){result={name:'Amazon Silk',silk:t,version:getFirstMatch(/silk\/(\d+(\.\d+)?)/i)}}
else if(/phantom/i.test(ua)){result={name:'PhantomJS',phantom:t,version:getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)}}
else if(/slimerjs/i.test(ua)){result={name:'SlimerJS',slimer:t,version:getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)}}
else if(/blackberry|\bbb\d+/i.test(ua)||/rim\stablet/i.test(ua)){result={name:'BlackBerry',blackberry:t,version:versionIdentifier||getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}}
else if(webos){result={name:'WebOS',webos:t,version:versionIdentifier||getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)};if(/touchpad\//i.test(ua)){result.touchpad=t;}}
else if(/bada/i.test(ua)){result={name:'Bada',bada:t,version:getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)};}
else if(tizen){result={name:'Tizen',tizen:t,version:getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||versionIdentifier};}
else if(/qupzilla/i.test(ua)){result={name:'QupZilla',qupzilla:t,version:getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||versionIdentifier}}
else if(/chromium/i.test(ua)){result={name:'Chromium',chromium:t,version:getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||versionIdentifier}}
else if(/chrome|crios|crmo/i.test(ua)){result={name:'Chrome',chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}
else if(android){result={name:'Android',version:versionIdentifier}}
else if(/safari|applewebkit/i.test(ua)){result={name:'Safari',safari:t}
if(versionIdentifier){result.version=versionIdentifier}}
else if(iosdevice){result={name:iosdevice=='iphone'?'iPhone':iosdevice=='ipad'?'iPad':'iPod'}
if(versionIdentifier){result.version=versionIdentifier}}
else if(/googlebot/i.test(ua)){result={name:'Googlebot',googlebot:t,version:getFirstMatch(/googlebot\/(\d+(\.\d+))/i)||versionIdentifier}}
else{result={name:getFirstMatch(/^(.*)\/(.*) /),version:getSecondMatch(/^(.*)\/(.*) /)};}
if(!result.msedge&&/(apple)?webkit/i.test(ua)){if(/(apple)?webkit\/537\.36/i.test(ua)){result.name=result.name||"Blink"
result.blink=t}else{result.name=result.name||"Webkit"
result.webkit=t}
if(!result.version&&versionIdentifier){result.version=versionIdentifier}}else if(!result.opera&&/gecko\//i.test(ua)){result.name=result.name||"Gecko"
result.gecko=t
result.version=result.version||getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)}
if(!result.msedge&&(android||result.silk)){result.android=t}else if(iosdevice){result[iosdevice]=t
result.ios=t}else if(mac){result.mac=t}else if(xbox){result.xbox=t}else if(windows){result.windows=t}else if(linux){result.linux=t}
var osVersion='';if(result.windowsphone){osVersion=getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);}else if(iosdevice){osVersion=getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);osVersion=osVersion.replace(/[_\s]/g,'.');}else if(android){osVersion=getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);}else if(result.webos){osVersion=getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);}else if(result.blackberry){osVersion=getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);}else if(result.bada){osVersion=getFirstMatch(/bada\/(\d+(\.\d+)*)/i);}else if(result.tizen){osVersion=getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);}
if(osVersion){result.osversion=osVersion;}
var osMajorVersion=osVersion.split('.')[0];if(tablet||nexusTablet||iosdevice=='ipad'||(android&&(osMajorVersion==3||(osMajorVersion>=4&&!mobile)))||result.silk){result.tablet=t}else if(mobile||iosdevice=='iphone'||iosdevice=='ipod'||android||nexusMobile||result.blackberry||result.webos||result.bada){result.mobile=t}
if(result.msedge||(result.msie&&result.version>=10)||(result.yandexbrowser&&result.version>=15)||(result.vivaldi&&result.version>=1.0)||(result.chrome&&result.version>=20)||(result.firefox&&result.version>=20.0)||(result.safari&&result.version>=6)||(result.opera&&result.version>=10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]>=6)||(result.blackberry&&result.version>=10.1)||(result.chromium&&result.version>=20)){result.a=t;}
else if((result.msie&&result.version<10)||(result.chrome&&result.version<20)||(result.firefox&&result.version<20.0)||(result.safari&&result.version<6)||(result.opera&&result.version<10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]<6)||(result.chromium&&result.version<20)){result.c=t}else result.x=t
return result}
var bowser=detect(typeof navigator!=='undefined'?navigator.userAgent:'')
bowser.test=function(browserList){for(var i=0;i<browserList.length;++i){var browserItem=browserList[i];if(typeof browserItem==='string'){if(browserItem in bowser){return true;}}}
return false;}
function getVersionPrecision(version){return version.split(".").length;}
function map(arr,iterator){var result=[],i;if(Array.prototype.map){return Array.prototype.map.call(arr,iterator);}
for(i=0;i<arr.length;i++){result.push(iterator(arr[i]));}
return result;}
function compareVersions(versions){var precision=Math.max(getVersionPrecision(versions[0]),getVersionPrecision(versions[1]));var chunks=map(versions,function(version){var delta=precision-getVersionPrecision(version);version=version+new Array(delta+1).join(".0");return map(version.split("."),function(chunk){return new Array(20-chunk.length).join("0")+chunk;}).reverse();});while(--precision>=0){if(chunks[0][precision]>chunks[1][precision]){return 1;}
else if(chunks[0][precision]===chunks[1][precision]){if(precision===0){return 0;}}
else{return-1;}}}
function isUnsupportedBrowser(minVersions,strictMode,ua){var _bowser=bowser;if(typeof strictMode==='string'){ua=strictMode;strictMode=void(0);}
if(strictMode===void(0)){strictMode=false;}
if(ua){_bowser=detect(ua);}
var version=""+_bowser.version;for(var browser in minVersions){if(minVersions.hasOwnProperty(browser)){if(_bowser[browser]){return compareVersions([version,minVersions[browser]])<0;}}}
return strictMode;}
function check(minVersions,strictMode,ua){return!isUnsupportedBrowser(minVersions,strictMode,ua);}
bowser.isUnsupportedBrowser=isUnsupportedBrowser;bowser.compareVersions=compareVersions;bowser.check=check;bowser._detect=detect;return bowser});(function($){UABBTrigger={triggerHook:function(hook,args){$('body').trigger('uabb-trigger.'+hook,args);},addHook:function(hook,callback){$('body').on('uabb-trigger.'+hook,callback);},removeHook:function(hook,callback){$('body').off('uabb-trigger.'+hook,callback);},};})(jQuery);jQuery(document).ready(function($){if(typeof bowser!=='undefined'&&bowser!==null){var uabb_browser=bowser.name,uabb_browser_v=bowser.version,uabb_browser_class=uabb_browser.replace(/\s+/g,'-').toLowerCase(),uabb_browser_v_class=uabb_browser_class+parseInt(uabb_browser_v);$('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);}
$('.uabb-row-separator').parents('html').css('overflow-x','hidden');});(function($){if($(window).width()<=768&&$(window).width()>=481){$('.fl-node-imew2zsl7qh9 .pp-heading-separator, .fl-node-imew2zsl7qh9 .pp-heading').removeClass('pp-center');$('.fl-node-imew2zsl7qh9 .pp-heading-separator, .fl-node-imew2zsl7qh9 .pp-heading').addClass('pp-tablet-');}
if($(window).width()<=480){$('.fl-node-imew2zsl7qh9 .pp-heading-separator, .fl-node-imew2zsl7qh9 .pp-heading').removeClass('pp-center');$('.fl-node-imew2zsl7qh9 .pp-heading-separator, .fl-node-imew2zsl7qh9 .pp-heading').addClass('pp-mobile-');}})(jQuery);jQuery(function($){$(function(){$('.fl-node-rxj5n430apg8 .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});;var ppcg_fsem3t8u0knl='';;(function($){var left_arrow_svg='<span aria-hidden="true"><svg role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 192 512"><path fill="currentColor" d="M25.1 247.5l117.8-116c4.7-4.7 12.3-4.7 17 0l7.1 7.1c4.7 4.7 4.7 12.3 0 17L64.7 256l102.2 100.4c4.7 4.7 4.7 12.3 0 17l-7.1 7.1c-4.7 4.7-12.3 4.7-17 0L25 264.5c-4.6-4.7-4.6-12.3.1-17z"></path></svg></span><span class="sr-only">Previous</span>';var right_arrow_svg='<span aria-hidden="true"><svg role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 192 512"><path fill="currentColor" d="M166.9 264.5l-117.8 116c-4.7 4.7-12.3 4.7-17 0l-7.1-7.1c-4.7-4.7-4.7-12.3 0-17L127.3 256 25.1 155.6c-4.7-4.7-4.7-12.3 0-17l7.1-7.1c4.7-4.7 12.3-4.7 17 0l117.8 116c4.6 4.7 4.6 12.3-.1 17z"></path></svg></span><span class="sr-only">Next</span>';var PPContentGridOptions={id:'fsem3t8u0knl',layout:'carousel',style:'custom',scrollTo:true,fields:{"layout":"carousel","post_grid_style_select":"custom","alternate_content":"no","custom_layout":{"html":"<div class=\"pp-content-grid-post-text\">\n <div class=\"pp-content-grid-post-excerpt\">\n    \t[wpbb post:content]<br >\n    <\/div>\n\n    <p class=\"pp-content-grid-post-title\">[wpbb post:title][wpbb-if post:custom_field key='position'], [wpbb post:custom_field key='position'][\/wpbb-if]\n<\/p>\n\n    \n\n\n   \n   \n\n<\/div>\n","css":".pp-content-grid-post-text {\n    padding: 20px;\n    font-family: \"DM Serif Text\",serif;\n    font-size: 24px;\n    font-style: italic;\n    text-align: center;\n}\n.pp-content-grid-post-title {\n    font-size: 24px;\n\tline-height: 26px;\n\tmargin: 0;\n\tpadding: 0;\n\tfont-family: \"Red Hat Display\", sans-serif;\n\n\tfont-style: normal;\n}\n\n@media only screen and (max-width: 600px) {\n .pp-content-grid-post-text {\n    padding: 20px;\n    font-family: \"DM Serif Text\",serif;\n    font-size: 18px;\n    font-style: italic;\n    text-align: center;\n}\n}","connections":{"html":""}},"total_post":"all","total_posts_count":"20","posts_per_page":"30","facetwp":"disable","post_slider_arrow_font_size":"36","post_content_width":"60","post_content_width_large":"","post_content_width_medium":"","post_content_width_responsive":"","pagination":"none","load_more_text":"Load More","no_results_message":"Sorry, we couldn't find any posts. Please try a different search.","show_search":"yes","pagination_nofollow":"no","title_tag":"h3","bt_condition_type":"none","bt_display_value1":"","bt_display_relationship":"equals","bt_display_value2":"","bt_cookie_name":"","bt_cookie_relationship":"equals","bt_cookie_value":"","bt_url_text":"","bt_url_type":"exists","bt_url_value":"","bt_time_schedule":"none","bt_start_date":"","bt_start_time":{"hours":"01","minutes":"00","day_period":"am"},"bt_end_date":"","bt_end_time":{"hours":"01","minutes":"00","day_period":"am"},"bt_timezone":"UTC","bt_location_type":"countrycode","bt_location_condition":"equals","bt_location_name":"","bt_display_action":"hide","bt_default_visibility":"show","visibility_logic":"[]","bt_default_module":"","export":"","import":"","type":"pp-content-grid","bb_css_code":"","bb_js_code":"","responsive_display_filtered":true,"connections":{"arrow_color":"","arrow_hover_color":"","arrow_bg_color":"","arrow_bg_hover_color":"","arrow_border":"","arrow_border_hover_color":"","post_slider_dot_bg_color":"","post_slider_dot_bg_hover":"","custom_content":"","more_link_text":"","post_grid_filters_default":"","all_filter_label":"","fallback_image_custom":"","post_bg_color":"","post_bg_color_hover":"","post_border_group":"","post_border_group_large":"","post_border_group_medium":"","post_border_group_responsive":"","post_title_divider_color":"","post_category_bg_color":"","post_category_text_color":"","post_title_overlay_color":"","post_date_day_bg_color":"","post_date_day_text_color":"","post_date_month_bg_color":"","post_date_month_text_color":"","post_date_bg_color":"","post_date_text_color":"","product_rating_color":"","product_price_color":"","button_bg_color":"","button_bg_hover_color":"","button_text_color":"","button_text_hover_color":"","button_border_group":"","button_border_group_large":"","button_border_group_medium":"","button_border_group_responsive":"","button_border_hover_color":"","filter_bg_color":"","filter_bg_color_active":"","filter_text_color":"","filter_text_color_active":"","filter_border_group":"","filter_border_group_large":"","filter_border_group_medium":"","filter_border_group_responsive":"","filter_border_hover_color":"","filter_toggle_bg":"","filter_toggle_color":"","filter_toggle_border_group":"","pagination_bg_color":"","pagination_bg_color_hover":"","pagination_color":"","pagination_color_hover":"","pagination_border_group":"","pagination_border_group_large":"","pagination_border_group_medium":"","pagination_border_group_responsive":"","title_typography":"","title_typography_large":"","title_typography_medium":"","title_typography_responsive":"","title_font_color":"","title_font_hover_color":"","content_typography":"","content_typography_large":"","content_typography_medium":"","content_typography_responsive":"","content_font_color":"","content_font_hover_color":"","meta_typography":"","meta_typography_large":"","meta_typography_medium":"","meta_typography_responsive":"","post_meta_font_color":"","post_meta_font_hover_color":"","post_meta_bg_color":"","event_date_color":"","event_venue_color":"","event_cost_color":"","button_typography":"","button_typography_large":"","button_typography_medium":"","button_typography_responsive":"","filter_typography":"","filter_typography_large":"","filter_typography_medium":"","filter_typography_responsive":"","bt_display_value1":"","bt_display_value2":"","bt_cookie_name":"","bt_cookie_value":"","bt_url_text":"","bt_url_value":"","bt_start_date":"","bt_start_time":"","bt_end_date":"","bt_end_time":"","bt_location_name":""},"pods_source_type":"pods_relation","pods_source_relation":"post_author","pods_source_settings_relation":"","data_source":"custom_query","data_source_acf_relational_type":"relationship","data_source_acf_relational_key":"","data_source_acf_order":"DESC","data_source_acf_order_by":"post__in","data_source_acf_order_by_meta_key":"","post_type":["testimonial"],"order_by":"date","order_by_meta_key":"","order":"DESC","offset":"0","exclude_current_post":"no","posts_post_matching":"1","posts_post":"","tax_post_category_matching":"1","tax_post_category":"","tax_post_post_tag_matching":"1","tax_post_post_tag":"","posts_page_matching":"1","posts_page":"","posts_testimonial_matching":"1","posts_testimonial":"","users_matching":"1","users":"","custom_field_relation":"AND","custom_field":[""],"show_title":"yes","show_content":"yes","content_type":"excerpt","custom_content":"","content_length":"300","more_link_type":"none","more_link_text":"Read More","link_target_new":"no","post_grid_filters_display":"no","post_grid_filters_type":"dynamic","post_grid_filters_terms":"","post_grid_filters_archive_terms":"","post_grid_filters_default":"","all_filter_label":"All","post_grid_filters_order_by":"name","post_grid_filters_order_by_meta_key":"","post_grid_filters_order":"ASC","show_image":"no","image_thumb_size":"large","image_thumb_crop":"","fallback_image":"default","fallback_image_custom":"","show_author":"no","show_date":"no","show_categories":"no","meta_separator":" | ","terms_separator":" \/ ","as_values_posts_post":"","as_values_tax_post_category":"","as_values_tax_post_post_tag":"","as_values_posts_page":"","as_values_posts_testimonial":"","as_values_users":"","post_grid_filters":"","fallback_image_custom_src":"","post_taxonomies":"","posts_case_study_matching":"1","posts_case_study":"","tax_case_study_industry_matching":"1","tax_case_study_industry":"","posts_portfolio_matching":"1","posts_portfolio":"","tax_portfolio_industry_matching":"1","tax_portfolio_industry":"","as_values_posts_case_study":"","as_values_tax_case_study_industry":"","as_values_posts_portfolio":"","as_values_tax_portfolio_industry":"","posts_wpdmpro_matching":"1","posts_wpdmpro":"","tax_wpdmpro_wpdmcategory_matching":"1","tax_wpdmpro_wpdmcategory":"","tax_wpdmpro_wpdmtag_matching":"1","tax_wpdmpro_wpdmtag":"","posts_news_matching":"1","posts_news":"","tax_news_news_type_matching":"1","tax_news_news_type":"","as_values_posts_wpdmpro":"","as_values_tax_wpdmpro_wpdmcategory":"","as_values_tax_wpdmpro_wpdmtag":"","as_values_posts_news":"","as_values_tax_news_news_type":""},pagination:'none',postSpacing:'20',postColumns:{"xl":1,"lg":1,"md":1,"sm":1},breakpoints:{"large":1200,"medium":992,"small":768},matchHeight:'yes',filters:false,defaultFilter:'',filterTax:'',filterType:'dynamic',carousel:{items:1,responsive:{0:{items:1,margin:0,},1201:{items:1,margin:0,},993:{items:1,margin:0,},769:{items:1,margin:0,},},slideBy:1,dots:false,autoplay:true,autoplayTimeout:8000,autoplaySpeed:1000,autoplayHoverPause:false,navSpeed:1000,dotsSpeed:1000,nav:true,lazyLoad:false,navText:[left_arrow_svg,right_arrow_svg],navContainer:'.fl-node-fsem3t8u0knl .pp-carousel-nav',navElement:'button type="button"',responsiveRefreshRate:200,responsiveBaseWidth:window,loop:true,center:false,autoHeight:false,URLhashListener:true}};PPContentGridOptions=$.extend({},PPContentGridOptions,bb_powerpack.conditionals);$(function(){ppcg_fsem3t8u0knl=new PPContentGrid(PPContentGridOptions);});var state=0;$(document).on('pp_expandable_row_toggle',function(e,selector){if(selector.is('.pp-er-open')&&state===0&&selector.parent().find('.pp-content-post-grid').length>0){if('undefined'!==typeof $.fn.isotope&&selector.parent().find('.pp-content-post-grid').data('isotope')){selector.parent().find('.pp-content-post-grid').isotope('layout');}
state=1;}});$(document).on('pp-tabs-switched',function(e,selector){if(selector.find('.pp-content-post-grid').length>0){var postsWrapper=selector.find('.pp-content-post-grid');ppcg_fsem3t8u0knl._gridLayoutMatchHeight();if('undefined'!==typeof $.fn.isotope&&postsWrapper.data('isotope')){setTimeout(function(){postsWrapper.isotope('layout');},500);}}});})(jQuery);
/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */!function(name,definition){if(typeof module!='undefined'&&module.exports)module.exports=definition()
else if(typeof define=='function'&&define.amd)define(name,definition)
else this[name]=definition()}('bowser',function(){var t=true
function detect(ua){function getFirstMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[1])||'';}
function getSecondMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[2])||'';}
var iosdevice=getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),likeAndroid=/like android/i.test(ua),android=!likeAndroid&&/android/i.test(ua),nexusMobile=/nexus\s*[0-6]\s*/i.test(ua),nexusTablet=!nexusMobile&&/nexus\s*[0-9]+/i.test(ua),chromeos=/CrOS/.test(ua),silk=/silk/i.test(ua),sailfish=/sailfish/i.test(ua),tizen=/tizen/i.test(ua),webos=/(web|hpw)os/i.test(ua),windowsphone=/windows phone/i.test(ua),windows=!windowsphone&&/windows/i.test(ua),mac=!iosdevice&&!silk&&/macintosh/i.test(ua),linux=!android&&!sailfish&&!tizen&&!webos&&/linux/i.test(ua),edgeVersion=getFirstMatch(/edge\/(\d+(\.\d+)?)/i),versionIdentifier=getFirstMatch(/version\/(\d+(\.\d+)?)/i),tablet=/tablet/i.test(ua),mobile=!tablet&&/[^-]mobi/i.test(ua),xbox=/xbox/i.test(ua),result
if(/opera|opr|opios/i.test(ua)){result={name:'Opera',opera:t,version:versionIdentifier||getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}}
else if(/coast/i.test(ua)){result={name:'Opera Coast',coast:t,version:versionIdentifier||getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}}
else if(/yabrowser/i.test(ua)){result={name:'Yandex Browser',yandexbrowser:t,version:versionIdentifier||getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}}
else if(/ucbrowser/i.test(ua)){result={name:'UC Browser',ucbrowser:t,version:getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/mxios/i.test(ua)){result={name:'Maxthon',maxthon:t,version:getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/epiphany/i.test(ua)){result={name:'Epiphany',epiphany:t,version:getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/puffin/i.test(ua)){result={name:'Puffin',puffin:t,version:getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}}
else if(/sleipnir/i.test(ua)){result={name:'Sleipnir',sleipnir:t,version:getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/k-meleon/i.test(ua)){result={name:'K-Meleon',kMeleon:t,version:getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(windowsphone){result={name:'Windows Phone',windowsphone:t}
if(edgeVersion){result.msedge=t
result.version=edgeVersion}
else{result.msie=t
result.version=getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)}}
else if(/msie|trident/i.test(ua)){result={name:'Internet Explorer',msie:t,version:getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)}}else if(chromeos){result={name:'Chrome',chromeos:t,chromeBook:t,chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}else if(/chrome.+? edge/i.test(ua)){result={name:'Microsoft Edge',msedge:t,version:edgeVersion}}
else if(/vivaldi/i.test(ua)){result={name:'Vivaldi',vivaldi:t,version:getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i)||versionIdentifier}}
else if(sailfish){result={name:'Sailfish',sailfish:t,version:getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}}
else if(/seamonkey\//i.test(ua)){result={name:'SeaMonkey',seamonkey:t,version:getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)}}
else if(/firefox|iceweasel|fxios/i.test(ua)){result={name:'Firefox',firefox:t,version:getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)}
if(/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)){result.firefoxos=t}}
else if(silk){result={name:'Amazon Silk',silk:t,version:getFirstMatch(/silk\/(\d+(\.\d+)?)/i)}}
else if(/phantom/i.test(ua)){result={name:'PhantomJS',phantom:t,version:getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)}}
else if(/slimerjs/i.test(ua)){result={name:'SlimerJS',slimer:t,version:getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)}}
else if(/blackberry|\bbb\d+/i.test(ua)||/rim\stablet/i.test(ua)){result={name:'BlackBerry',blackberry:t,version:versionIdentifier||getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}}
else if(webos){result={name:'WebOS',webos:t,version:versionIdentifier||getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)};if(/touchpad\//i.test(ua)){result.touchpad=t;}}
else if(/bada/i.test(ua)){result={name:'Bada',bada:t,version:getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)};}
else if(tizen){result={name:'Tizen',tizen:t,version:getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||versionIdentifier};}
else if(/qupzilla/i.test(ua)){result={name:'QupZilla',qupzilla:t,version:getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||versionIdentifier}}
else if(/chromium/i.test(ua)){result={name:'Chromium',chromium:t,version:getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||versionIdentifier}}
else if(/chrome|crios|crmo/i.test(ua)){result={name:'Chrome',chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}
else if(android){result={name:'Android',version:versionIdentifier}}
else if(/safari|applewebkit/i.test(ua)){result={name:'Safari',safari:t}
if(versionIdentifier){result.version=versionIdentifier}}
else if(iosdevice){result={name:iosdevice=='iphone'?'iPhone':iosdevice=='ipad'?'iPad':'iPod'}
if(versionIdentifier){result.version=versionIdentifier}}
else if(/googlebot/i.test(ua)){result={name:'Googlebot',googlebot:t,version:getFirstMatch(/googlebot\/(\d+(\.\d+))/i)||versionIdentifier}}
else{result={name:getFirstMatch(/^(.*)\/(.*) /),version:getSecondMatch(/^(.*)\/(.*) /)};}
if(!result.msedge&&/(apple)?webkit/i.test(ua)){if(/(apple)?webkit\/537\.36/i.test(ua)){result.name=result.name||"Blink"
result.blink=t}else{result.name=result.name||"Webkit"
result.webkit=t}
if(!result.version&&versionIdentifier){result.version=versionIdentifier}}else if(!result.opera&&/gecko\//i.test(ua)){result.name=result.name||"Gecko"
result.gecko=t
result.version=result.version||getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)}
if(!result.msedge&&(android||result.silk)){result.android=t}else if(iosdevice){result[iosdevice]=t
result.ios=t}else if(mac){result.mac=t}else if(xbox){result.xbox=t}else if(windows){result.windows=t}else if(linux){result.linux=t}
var osVersion='';if(result.windowsphone){osVersion=getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);}else if(iosdevice){osVersion=getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);osVersion=osVersion.replace(/[_\s]/g,'.');}else if(android){osVersion=getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);}else if(result.webos){osVersion=getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);}else if(result.blackberry){osVersion=getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);}else if(result.bada){osVersion=getFirstMatch(/bada\/(\d+(\.\d+)*)/i);}else if(result.tizen){osVersion=getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);}
if(osVersion){result.osversion=osVersion;}
var osMajorVersion=osVersion.split('.')[0];if(tablet||nexusTablet||iosdevice=='ipad'||(android&&(osMajorVersion==3||(osMajorVersion>=4&&!mobile)))||result.silk){result.tablet=t}else if(mobile||iosdevice=='iphone'||iosdevice=='ipod'||android||nexusMobile||result.blackberry||result.webos||result.bada){result.mobile=t}
if(result.msedge||(result.msie&&result.version>=10)||(result.yandexbrowser&&result.version>=15)||(result.vivaldi&&result.version>=1.0)||(result.chrome&&result.version>=20)||(result.firefox&&result.version>=20.0)||(result.safari&&result.version>=6)||(result.opera&&result.version>=10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]>=6)||(result.blackberry&&result.version>=10.1)||(result.chromium&&result.version>=20)){result.a=t;}
else if((result.msie&&result.version<10)||(result.chrome&&result.version<20)||(result.firefox&&result.version<20.0)||(result.safari&&result.version<6)||(result.opera&&result.version<10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]<6)||(result.chromium&&result.version<20)){result.c=t}else result.x=t
return result}
var bowser=detect(typeof navigator!=='undefined'?navigator.userAgent:'')
bowser.test=function(browserList){for(var i=0;i<browserList.length;++i){var browserItem=browserList[i];if(typeof browserItem==='string'){if(browserItem in bowser){return true;}}}
return false;}
function getVersionPrecision(version){return version.split(".").length;}
function map(arr,iterator){var result=[],i;if(Array.prototype.map){return Array.prototype.map.call(arr,iterator);}
for(i=0;i<arr.length;i++){result.push(iterator(arr[i]));}
return result;}
function compareVersions(versions){var precision=Math.max(getVersionPrecision(versions[0]),getVersionPrecision(versions[1]));var chunks=map(versions,function(version){var delta=precision-getVersionPrecision(version);version=version+new Array(delta+1).join(".0");return map(version.split("."),function(chunk){return new Array(20-chunk.length).join("0")+chunk;}).reverse();});while(--precision>=0){if(chunks[0][precision]>chunks[1][precision]){return 1;}
else if(chunks[0][precision]===chunks[1][precision]){if(precision===0){return 0;}}
else{return-1;}}}
function isUnsupportedBrowser(minVersions,strictMode,ua){var _bowser=bowser;if(typeof strictMode==='string'){ua=strictMode;strictMode=void(0);}
if(strictMode===void(0)){strictMode=false;}
if(ua){_bowser=detect(ua);}
var version=""+_bowser.version;for(var browser in minVersions){if(minVersions.hasOwnProperty(browser)){if(_bowser[browser]){return compareVersions([version,minVersions[browser]])<0;}}}
return strictMode;}
function check(minVersions,strictMode,ua){return!isUnsupportedBrowser(minVersions,strictMode,ua);}
bowser.isUnsupportedBrowser=isUnsupportedBrowser;bowser.compareVersions=compareVersions;bowser.check=check;bowser._detect=detect;return bowser});(function($){UABBTrigger={triggerHook:function(hook,args){$('body').trigger('uabb-trigger.'+hook,args);},addHook:function(hook,callback){$('body').on('uabb-trigger.'+hook,callback);},removeHook:function(hook,callback){$('body').off('uabb-trigger.'+hook,callback);},};})(jQuery);jQuery(document).ready(function($){if(typeof bowser!=='undefined'&&bowser!==null){var uabb_browser=bowser.name,uabb_browser_v=bowser.version,uabb_browser_class=uabb_browser.replace(/\s+/g,'-').toLowerCase(),uabb_browser_v_class=uabb_browser_class+parseInt(uabb_browser_v);$('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);}
$('.uabb-row-separator').parents('html').css('overflow-x','hidden');});(function($){if($(window).width()<=768&&$(window).width()>=481){$('.fl-node-ulf203ytx16r .pp-heading-separator, .fl-node-ulf203ytx16r .pp-heading').removeClass('pp-center');$('.fl-node-ulf203ytx16r .pp-heading-separator, .fl-node-ulf203ytx16r .pp-heading').addClass('pp-tablet-');}
if($(window).width()<=480){$('.fl-node-ulf203ytx16r .pp-heading-separator, .fl-node-ulf203ytx16r .pp-heading').removeClass('pp-center');$('.fl-node-ulf203ytx16r .pp-heading-separator, .fl-node-ulf203ytx16r .pp-heading').addClass('pp-mobile-');}})(jQuery);jQuery(function($){$(function(){$('.fl-node-jmnoprk9vw21 .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-2ewiqn6hso4j .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-80d3ghqwlcpb .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-ti3xegsvoplf .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-uiqj7fhlwp9d .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-j8fyxqw3mnor .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-2ab6iekc8myx .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-pnsudlx31ytj .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-cebmrzwoq6al .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-bza6rfp23de8 .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});jQuery(function($){$(function(){$('.fl-node-lzkc38d4msn7 .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});window._fl_string_to_slug_regex='a-zA-Z0-9';});
/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */!function(name,definition){if(typeof module!='undefined'&&module.exports)module.exports=definition()
else if(typeof define=='function'&&define.amd)define(name,definition)
else this[name]=definition()}('bowser',function(){var t=true
function detect(ua){function getFirstMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[1])||'';}
function getSecondMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[2])||'';}
var iosdevice=getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),likeAndroid=/like android/i.test(ua),android=!likeAndroid&&/android/i.test(ua),nexusMobile=/nexus\s*[0-6]\s*/i.test(ua),nexusTablet=!nexusMobile&&/nexus\s*[0-9]+/i.test(ua),chromeos=/CrOS/.test(ua),silk=/silk/i.test(ua),sailfish=/sailfish/i.test(ua),tizen=/tizen/i.test(ua),webos=/(web|hpw)os/i.test(ua),windowsphone=/windows phone/i.test(ua),windows=!windowsphone&&/windows/i.test(ua),mac=!iosdevice&&!silk&&/macintosh/i.test(ua),linux=!android&&!sailfish&&!tizen&&!webos&&/linux/i.test(ua),edgeVersion=getFirstMatch(/edge\/(\d+(\.\d+)?)/i),versionIdentifier=getFirstMatch(/version\/(\d+(\.\d+)?)/i),tablet=/tablet/i.test(ua),mobile=!tablet&&/[^-]mobi/i.test(ua),xbox=/xbox/i.test(ua),result
if(/opera|opr|opios/i.test(ua)){result={name:'Opera',opera:t,version:versionIdentifier||getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}}
else if(/coast/i.test(ua)){result={name:'Opera Coast',coast:t,version:versionIdentifier||getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}}
else if(/yabrowser/i.test(ua)){result={name:'Yandex Browser',yandexbrowser:t,version:versionIdentifier||getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}}
else if(/ucbrowser/i.test(ua)){result={name:'UC Browser',ucbrowser:t,version:getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/mxios/i.test(ua)){result={name:'Maxthon',maxthon:t,version:getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/epiphany/i.test(ua)){result={name:'Epiphany',epiphany:t,version:getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/puffin/i.test(ua)){result={name:'Puffin',puffin:t,version:getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}}
else if(/sleipnir/i.test(ua)){result={name:'Sleipnir',sleipnir:t,version:getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/k-meleon/i.test(ua)){result={name:'K-Meleon',kMeleon:t,version:getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(windowsphone){result={name:'Windows Phone',windowsphone:t}
if(edgeVersion){result.msedge=t
result.version=edgeVersion}
else{result.msie=t
result.version=getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)}}
else if(/msie|trident/i.test(ua)){result={name:'Internet Explorer',msie:t,version:getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)}}else if(chromeos){result={name:'Chrome',chromeos:t,chromeBook:t,chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}else if(/chrome.+? edge/i.test(ua)){result={name:'Microsoft Edge',msedge:t,version:edgeVersion}}
else if(/vivaldi/i.test(ua)){result={name:'Vivaldi',vivaldi:t,version:getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i)||versionIdentifier}}
else if(sailfish){result={name:'Sailfish',sailfish:t,version:getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}}
else if(/seamonkey\//i.test(ua)){result={name:'SeaMonkey',seamonkey:t,version:getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)}}
else if(/firefox|iceweasel|fxios/i.test(ua)){result={name:'Firefox',firefox:t,version:getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)}
if(/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)){result.firefoxos=t}}
else if(silk){result={name:'Amazon Silk',silk:t,version:getFirstMatch(/silk\/(\d+(\.\d+)?)/i)}}
else if(/phantom/i.test(ua)){result={name:'PhantomJS',phantom:t,version:getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)}}
else if(/slimerjs/i.test(ua)){result={name:'SlimerJS',slimer:t,version:getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)}}
else if(/blackberry|\bbb\d+/i.test(ua)||/rim\stablet/i.test(ua)){result={name:'BlackBerry',blackberry:t,version:versionIdentifier||getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}}
else if(webos){result={name:'WebOS',webos:t,version:versionIdentifier||getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)};if(/touchpad\//i.test(ua)){result.touchpad=t;}}
else if(/bada/i.test(ua)){result={name:'Bada',bada:t,version:getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)};}
else if(tizen){result={name:'Tizen',tizen:t,version:getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||versionIdentifier};}
else if(/qupzilla/i.test(ua)){result={name:'QupZilla',qupzilla:t,version:getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||versionIdentifier}}
else if(/chromium/i.test(ua)){result={name:'Chromium',chromium:t,version:getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||versionIdentifier}}
else if(/chrome|crios|crmo/i.test(ua)){result={name:'Chrome',chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}
else if(android){result={name:'Android',version:versionIdentifier}}
else if(/safari|applewebkit/i.test(ua)){result={name:'Safari',safari:t}
if(versionIdentifier){result.version=versionIdentifier}}
else if(iosdevice){result={name:iosdevice=='iphone'?'iPhone':iosdevice=='ipad'?'iPad':'iPod'}
if(versionIdentifier){result.version=versionIdentifier}}
else if(/googlebot/i.test(ua)){result={name:'Googlebot',googlebot:t,version:getFirstMatch(/googlebot\/(\d+(\.\d+))/i)||versionIdentifier}}
else{result={name:getFirstMatch(/^(.*)\/(.*) /),version:getSecondMatch(/^(.*)\/(.*) /)};}
if(!result.msedge&&/(apple)?webkit/i.test(ua)){if(/(apple)?webkit\/537\.36/i.test(ua)){result.name=result.name||"Blink"
result.blink=t}else{result.name=result.name||"Webkit"
result.webkit=t}
if(!result.version&&versionIdentifier){result.version=versionIdentifier}}else if(!result.opera&&/gecko\//i.test(ua)){result.name=result.name||"Gecko"
result.gecko=t
result.version=result.version||getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)}
if(!result.msedge&&(android||result.silk)){result.android=t}else if(iosdevice){result[iosdevice]=t
result.ios=t}else if(mac){result.mac=t}else if(xbox){result.xbox=t}else if(windows){result.windows=t}else if(linux){result.linux=t}
var osVersion='';if(result.windowsphone){osVersion=getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);}else if(iosdevice){osVersion=getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);osVersion=osVersion.replace(/[_\s]/g,'.');}else if(android){osVersion=getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);}else if(result.webos){osVersion=getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);}else if(result.blackberry){osVersion=getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);}else if(result.bada){osVersion=getFirstMatch(/bada\/(\d+(\.\d+)*)/i);}else if(result.tizen){osVersion=getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);}
if(osVersion){result.osversion=osVersion;}
var osMajorVersion=osVersion.split('.')[0];if(tablet||nexusTablet||iosdevice=='ipad'||(android&&(osMajorVersion==3||(osMajorVersion>=4&&!mobile)))||result.silk){result.tablet=t}else if(mobile||iosdevice=='iphone'||iosdevice=='ipod'||android||nexusMobile||result.blackberry||result.webos||result.bada){result.mobile=t}
if(result.msedge||(result.msie&&result.version>=10)||(result.yandexbrowser&&result.version>=15)||(result.vivaldi&&result.version>=1.0)||(result.chrome&&result.version>=20)||(result.firefox&&result.version>=20.0)||(result.safari&&result.version>=6)||(result.opera&&result.version>=10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]>=6)||(result.blackberry&&result.version>=10.1)||(result.chromium&&result.version>=20)){result.a=t;}
else if((result.msie&&result.version<10)||(result.chrome&&result.version<20)||(result.firefox&&result.version<20.0)||(result.safari&&result.version<6)||(result.opera&&result.version<10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]<6)||(result.chromium&&result.version<20)){result.c=t}else result.x=t
return result}
var bowser=detect(typeof navigator!=='undefined'?navigator.userAgent:'')
bowser.test=function(browserList){for(var i=0;i<browserList.length;++i){var browserItem=browserList[i];if(typeof browserItem==='string'){if(browserItem in bowser){return true;}}}
return false;}
function getVersionPrecision(version){return version.split(".").length;}
function map(arr,iterator){var result=[],i;if(Array.prototype.map){return Array.prototype.map.call(arr,iterator);}
for(i=0;i<arr.length;i++){result.push(iterator(arr[i]));}
return result;}
function compareVersions(versions){var precision=Math.max(getVersionPrecision(versions[0]),getVersionPrecision(versions[1]));var chunks=map(versions,function(version){var delta=precision-getVersionPrecision(version);version=version+new Array(delta+1).join(".0");return map(version.split("."),function(chunk){return new Array(20-chunk.length).join("0")+chunk;}).reverse();});while(--precision>=0){if(chunks[0][precision]>chunks[1][precision]){return 1;}
else if(chunks[0][precision]===chunks[1][precision]){if(precision===0){return 0;}}
else{return-1;}}}
function isUnsupportedBrowser(minVersions,strictMode,ua){var _bowser=bowser;if(typeof strictMode==='string'){ua=strictMode;strictMode=void(0);}
if(strictMode===void(0)){strictMode=false;}
if(ua){_bowser=detect(ua);}
var version=""+_bowser.version;for(var browser in minVersions){if(minVersions.hasOwnProperty(browser)){if(_bowser[browser]){return compareVersions([version,minVersions[browser]])<0;}}}
return strictMode;}
function check(minVersions,strictMode,ua){return!isUnsupportedBrowser(minVersions,strictMode,ua);}
bowser.isUnsupportedBrowser=isUnsupportedBrowser;bowser.compareVersions=compareVersions;bowser.check=check;bowser._detect=detect;return bowser});(function($){UABBTrigger={triggerHook:function(hook,args){$('body').trigger('uabb-trigger.'+hook,args);},addHook:function(hook,callback){$('body').on('uabb-trigger.'+hook,callback);},removeHook:function(hook,callback){$('body').off('uabb-trigger.'+hook,callback);},};})(jQuery);jQuery(document).ready(function($){if(typeof bowser!=='undefined'&&bowser!==null){var uabb_browser=bowser.name,uabb_browser_v=bowser.version,uabb_browser_class=uabb_browser.replace(/\s+/g,'-').toLowerCase(),uabb_browser_v_class=uabb_browser_class+parseInt(uabb_browser_v);$('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);}
$('.uabb-row-separator').parents('html').css('overflow-x','hidden');});;(function($){PPModalBox=function(settings){this.id=settings.id;this.settings=settings;this.type=settings.type;this.cookieKey='pp_modal_'+this.id;this.cookieTime=settings.display_after;this.cookieValue=settings.cookie_value?settings.cookie_value:this.cookieTime;this.triggerType=settings.trigger_type;this.layout=settings.layout;this.wrap=$('#modal-'+this.id);this.container=this.wrap.find('.pp-modal-container');this.element=this.wrap.find('.pp-modal');this.isPreviewing=settings.previewing;this.isVisible=settings.visible;this.eventClose=false;this.initCookieApi();this.init();};PPModalBox.prototype={id:'',settings:{},type:'',cookieKey:'',cookieTime:0,triggerType:'',layout:'',wrap:'',element:'',prevFocusedEl:'',isActive:false,isPreviewing:false,isVisible:false,eventClose:false,init:function(){if(parseInt(this.cookieTime)===0||this.cookieTime<0||this.cookieTime===''){this.removeCookie();}
if(('exit_intent'===this.triggerType||'auto'===this.triggerType)&&this.getCookie()&&!this.isPreviewing){return;}
if(!this.isPreviewing&&'undefined'!==typeof this.isVisible&&!this.isVisible){return;}
if(this.isActive){return;}
this.setResponsive();this.bindEvents();this.show();},setResponsive:function(){if(window.innerWidth<=this.settings.breakpoint){this.element.removeClass('layout-standard').addClass('layout-fullscreen');}
if(window.innerWidth<this.element.width()){this.element.css('width',window.innerWidth+'px');}},bindEvents:function(){var self=this;$(this.element).on('beforeload',this.beforeLoad.bind(this));$(document).on('keyup',function(e){if(self.settings.esc_exit&&27==e.which&&self.isActive&&$('form[data-type="pp-modal-box"]').length===0){self.eventClose=true;self.hide();}}).on('keydown',function(e){if((e.key==='Tab'||e.keyCode===9)&&self.isActive){if(e.shiftKey&&$(document.activeElement).is(self.element)){e.preventDefault();}
if($(document.activeElement).closest(self.element).length===0){self.element.trigger('focus');e.preventDefault();}}});$(document).on('click',function(e){if(self.settings.click_exit&&$(e.target).parents('.pp-modal').length===0&&self.isActive&&!self.isPreviewing&&!self.element.is(e.target)&&self.element.has(e.target).length===0&&!$(e.target).hasClass('modal-'+self.id)&&$(e.target).parents('.modal-'+self.id).length===0&&e.which){self.eventClose=true;self.hide();}});$(self.wrap).find('.pp-modal-close, .pp-modal-close-custom').on('keypress click',function(e){e.preventDefault();e.stopPropagation();if(e.which==1||e.which==13||e.which==32||e.which==undefined){self.eventClose=true;self.hide();}});$('body').on('click','#modal-'+self.id+' .pp-modal-content a[href*="#"]:not([href="#"])',function(){if($('.fl-node-'+self.id).hasClass('anchor-click-no-event')){return;}
self.eventClose=true;self.hide();});$(window).on('resize',this.setResponsive.bind(this));$(window).on('resize',this.setPosition.bind(this));},setPosition:function(){if('fullscreen'!==this.layout){if(typeof this.settings.height==='undefined'){this.wrap.addClass('pp-modal-height-auto');var modalHeight=this.element.outerHeight();this.wrap.removeClass('pp-modal-height-auto');if('photo'===this.type){this.element.find('.pp-modal-content-inner img').css('max-width','100%');}
var topPos=(window.innerHeight-modalHeight)/ 2;if(topPos<0){topPos=0;}
this.element.css('top',topPos+'px');}else{var topPos=(window.innerHeight-this.settings.height)/ 2;if(topPos<0){topPos=0;}
this.element.css('top',topPos+'px');}}},beforeLoad:function(){if(this.settings.clickedElement){var clickedElement=this.settings.clickedElement;var postId=clickedElement.attr('data-pp-modal-post')||clickedElement.parents('.pp-content-post').attr('data-id');var self=this;if('undefined'===typeof postId||''===postId){return;}
self.element.find('.pp-modal-content-inner').html('<div style="text-align: center;"><img src="'+self.settings.loaderImg+'" /></div>');self.setPosition();if('html'===self.settings.type&&''!==self.settings.content){$.ajax({url:bb_powerpack.getAjaxUrl(),type:'post',data:{action:'pp_modal_dynamic_content',content:self.settings.content,postId:postId},success:function(response){if(!response.success){return;}
self.element.find('.pp-modal-content-inner').html(response.data);self.setPosition();}});}}},show:function(){if(this.element.length===0){return;}
this.setPosition();var self=this;if('photo'===this.type){this.element.find('.pp-modal-content-inner img').css('max-width','100%');}
this.prevFocusedEl=$(document.activeElement);setTimeout(function(){self.element.trigger('beforeload');if(!self.isPreviewing){setTimeout(function(){self.element.attr('tabindex','0').trigger('focus');},100);}
$('html').addClass('pp-modal-active-'+self.id);self.wrap.addClass('pp-modal-active');self.container.removeClass(self.settings.animation_load+' animated').addClass('modal-visible').addClass(self.settings.animation_load+' animated');if(!$('body').hasClass('wp-admin')){self.container.one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend',function(){self.eventClose=false;$(this).removeClass(self.settings.animation_load+' animated');self.setup();});}else{self.setup();}
self.isActive=true;if('exit_intent'===self.triggerType||'auto'===self.triggerType){if(!self.isPreviewing){self.setCookie();}}
self.restruct();self.setPosition();self.element.trigger('afterload');$(document).trigger('pp_modal_box_rendered',[self.element]);},self.settings.auto_load?parseFloat(self.settings.delay)*1000:0);},setup:function(){if(this.element.find('.pp-modal-iframe').length>0){var original_src=this.element.find('.pp-modal-iframe').attr('src');var src=this.element.find('.pp-modal-iframe').data('url');if(original_src===undefined||original_src===''){this.element.find('.pp-modal-iframe').attr('src',src);}}
var iframeAndSource=this.element.find('iframe, source');if(iframeAndSource.length>0&&iframeAndSource.closest('.fl-module').length===0){var src='';var m_src=iframeAndSource.attr('src');if(m_src===undefined||m_src===''){src=iframeAndSource.data('url');}else{src=iframeAndSource.attr('src');}
if(src){if((src.search('youtube')!==-1||src.search('vimeo')!==-1)&&src.search('autoplay=1')==-1){if(typeof src.split('?')[1]==='string'){src=src+'&autoplay=1&rel=0';}else{src=src+'?autoplay=1&rel=0';}}
iframeAndSource.attr('src',src);}}
if(this.element.find('video').length){this.element.find('video')[0].play();}},reset:function(){var iframeAndSource=this.element.find('iframe, source');if(iframeAndSource.length>0&&iframeAndSource.closest('.fl-module').length===0){var src=iframeAndSource.attr('src');if(''!==src){iframeAndSource.attr('data-url',src).attr('src','');}}
if(this.element.find('video').length>0){this.element.find('video')[0].pause();}
if(this.element.find('mux-player').length>0){this.element.find('mux-player')[0].pause();}
this.element.attr('tabindex','-1');var self=this;setTimeout(function(){if(self.settings.clickedElement){var $clickedElement=self.settings.clickedElement;if($clickedElement.closest('.modal-'+self.id).length){$clickedElement.closest('.modal-'+self.id).trigger('focus');}else if($clickedElement.closest('#trigger-'+self.id).length){$clickedElement.closest('#trigger-'+self.id).trigger('focus');}else if(''!==self.settings.customTrigger){if($clickedElement.is(self.settings.customTrigger)){$clickedElement.trigger('focus');}else if($clickedElement.closest(self.settings.customTrigger).length){$clickedElement.closest(self.settings.customTrigger).trigger('focus');}}}},100);},restruct:function(){var mH=0,hH=0,cH=0,eq=0;var self=this;setTimeout(function(){if(self.isActive){if('fullscreen'===self.layout){var marginTop=parseInt(self.element.css('margin-top'));var marginBottom=parseInt(self.element.css('margin-bottom'));var modalHeight=$(window).height()-(marginTop+marginBottom);self.element.css('height',modalHeight+'px');}
eq=6;mH=self.element.outerHeight();hH=self.element.find('.pp-modal-header').outerHeight();if(self.settings.auto_height&&'fullscreen'!==self.layout){return;}
var cP=parseInt(self.element.find('.pp-modal-content').css('padding'));self.element.find('.pp-modal-content').css('height',mH-(hH+eq)+'px');if(!self.settings.auto_height&&self.element.find('.pp-modal-header').length===0){self.element.find('.pp-modal-content').css('height',mH+'px');}
if('url'===self.type&&self.element.find('.pp-modal-video-embed').length===0){self.element.find('.pp-modal-iframe').css('height',self.element.find('.pp-modal-content-inner').outerHeight()+'px');}
if('video'===self.type){self.element.find('iframe').css({'height':'100%','width':'100%'});}}},self.settings.auto_load?parseFloat(self.settings.delay)*1000:1);},hide:function(){var self=this;this.element.trigger('beforeclose');this.container.removeClass(self.settings.animation_exit+' animated').addClass(self.settings.animation_exit+' animated');if(!$('body').hasClass('wp-admin')){this.container.one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend',function(){if(self.eventClose){self.close();}});}else{self.close();}
if(window.location.hash){var hashVal=window.location.hash.replace('/','');if('#modal-'+self.id===hashVal){var scrollTop=self.settings.scrollTop||$(window).scrollTop();window.location.href=window.location.href.split('#')[0]+'#';$(window).scrollTop(scrollTop);}}
if(!this.isPreviewing){this.element.attr('tabindex','-1').trigger('blur');if(this.prevFocusedEl&&this.prevFocusedEl.length>0){this.prevFocusedEl.trigger('focus');}}
this.element.trigger('afterclose');$(document).trigger('pp_modal_box_after_close',[this.element,this]);},close:function(){this.container.removeClass(this.settings.animation_exit+' animated').removeClass('modal-visible');this.container.find('.pp-modal-content').removeAttr('style');this.wrap.removeClass('pp-modal-active');$('html').removeClass('pp-modal-active-'+this.id);this.isActive=false;this.eventClose=false;this.reset();},initCookieApi:function(){if('undefined'===typeof $.cookie){/*!
				 * jQuery Cookie Plugin v1.4.1
				 * https://github.com/carhartl/jquery-cookie
				 *
				 * Copyright 2013 Klaus Hartl
				 * Released under the MIT license
				*/!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a("object"==typeof exports?require("jquery"):jQuery)}(function(a){function b(a){return h.raw?a:encodeURIComponent(a)}function c(a){return h.raw?a:decodeURIComponent(a)}function d(a){return b(h.json?JSON.stringify(a):String(a))}function e(a){0===a.indexOf('"')&&(a=a.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,"\\"));try{return a=decodeURIComponent(a.replace(g," ")),h.json?JSON.parse(a):a}catch(b){}}function f(b,c){var d=h.raw?b:e(b);return a.isFunction(c)?c(d):d}var g=/\+/g,h=a.cookie=function(e,g,i){if(void 0!==g&&!a.isFunction(g)){if(i=a.extend({},h.defaults,i),"number"==typeof i.expires){var j=i.expires,k=i.expires=new Date;k.setTime(+k+864e5*j)}return document.cookie=[b(e),"=",d(g),i.expires?"; expires="+i.expires.toUTCString():"",i.path?"; path="+i.path:"",i.domain?"; domain="+i.domain:"",i.secure?"; secure":""].join("")}for(var l=e?void 0:{},m=document.cookie?document.cookie.split("; "):[],n=0,o=m.length;o>n;n++){var p=m[n].split("="),q=c(p.shift()),r=p.join("=");if(e&&e===q){l=f(r,g);break}e||void 0===(r=f(r))||(l[q]=r)}return l};h.defaults={},a.removeCookie=function(b,c){return void 0===a.cookie(b)?!1:(a.cookie(b,"",a.extend({},c,{expires:-1})),!a.cookie(b))}});}},setCookie:function(){if(parseInt(this.cookieTime)>0){return $.cookie(this.cookieKey,this.cookieValue,{expires:this.cookieTime,path:'/'});}else{this.removeCookie();}},getCookie:function(){if(this.cookieValue!=$.cookie(this.cookieKey)){this.removeCookie();}
return $.cookie(this.cookieKey);},removeCookie:function(){$.cookie(this.cookieKey,0,{expires:0,path:'/'});}};})(jQuery);var pp_modal_xe3qrmzu4igk=false;var pp_modal_xe3qrmzu4igk_config=false;;(function($){pp_modal_xe3qrmzu4igk_config={id:'xe3qrmzu4igk',type:'templates',trigger_type:'auto',auto_load:true,exit_intent:false,display_after:1,load_on_scroll:0,delay:1,animation_load:'fadeIn',animation_exit:'fadeOut',overlay_animation:true,esc_exit:true,click_exit:true,layout:'standard',auto_height:true,width:600,breakpoint:0,loaderImg:'https://mangiero.sumy-starter.us/wp-content/plugins/bbpowerpack/assets/images/ajax-loader.gif',previewing:false};$(document).on('click',function(e){if(e&&e.target.tagName==='A'&&e.target.href.indexOf('#modal-xe3qrmzu4igk')!==-1){pp_modal_xe3qrmzu4igk_config['scrollTop']=$(window).scrollTop();}});$(function(){$('#modal-xe3qrmzu4igk').appendTo(document.body);var tabHash=window.location.hash?window.location.hash.replace('/',''):false;var modalId=window.location.hash.split('#modal-')[1];if(tabHash&&tabHash.indexOf('modal-')>=0){if(modalId==='xe3qrmzu4igk'){pp_modal_xe3qrmzu4igk=new PPModalBox(pp_modal_xe3qrmzu4igk_config);}}
$(window).on('hashchange',function(){var tabHash=window.location.hash;var modalId=window.location.hash.split('#modal-')[1];if(tabHash&&tabHash.indexOf('modal-')>=0){if(modalId==='xe3qrmzu4igk'){if(pp_modal_xe3qrmzu4igk instanceof PPModalBox){pp_modal_xe3qrmzu4igk.show();}else{pp_modal_xe3qrmzu4igk=new PPModalBox(pp_modal_xe3qrmzu4igk_config);}}}});});pp_modal_xe3qrmzu4igk=new PPModalBox(pp_modal_xe3qrmzu4igk_config);pp_modal_xe3qrmzu4igk_config.customTrigger='';$(document).on('click keydown','.modal-xe3qrmzu4igk',function(e){var valid=(e.which==1||e.which==13||e.which==32||e.which==undefined);if(!valid){return;}
e.preventDefault();if(pp_modal_xe3qrmzu4igk instanceof PPModalBox){pp_modal_xe3qrmzu4igk.settings.clickedElement=$(e.target);pp_modal_xe3qrmzu4igk.show();}else{pp_modal_xe3qrmzu4igk_config.clickedElement=$(e.target);pp_modal_xe3qrmzu4igk=new PPModalBox(pp_modal_xe3qrmzu4igk_config);}});})(jQuery);var pp_modal_8wj1bp7ziqsg=false;var pp_modal_8wj1bp7ziqsg_config=false;;(function($){pp_modal_8wj1bp7ziqsg_config={id:'8wj1bp7ziqsg',type:'templates',trigger_type:'auto',auto_load:true,exit_intent:false,display_after:1,load_on_scroll:0,delay:1,animation_load:'fadeIn',animation_exit:'fadeOut',overlay_animation:true,esc_exit:true,click_exit:true,layout:'standard',auto_height:true,width:600,breakpoint:0,loaderImg:'https://mangiero.sumy-starter.us/wp-content/plugins/bbpowerpack/assets/images/ajax-loader.gif',previewing:false};$(document).on('click',function(e){if(e&&e.target.tagName==='A'&&e.target.href.indexOf('#modal-8wj1bp7ziqsg')!==-1){pp_modal_8wj1bp7ziqsg_config['scrollTop']=$(window).scrollTop();}});$(function(){$('#modal-8wj1bp7ziqsg').appendTo(document.body);var tabHash=window.location.hash?window.location.hash.replace('/',''):false;var modalId=window.location.hash.split('#modal-')[1];if(tabHash&&tabHash.indexOf('modal-')>=0){if(modalId==='8wj1bp7ziqsg'){pp_modal_8wj1bp7ziqsg=new PPModalBox(pp_modal_8wj1bp7ziqsg_config);}}
$(window).on('hashchange',function(){var tabHash=window.location.hash;var modalId=window.location.hash.split('#modal-')[1];if(tabHash&&tabHash.indexOf('modal-')>=0){if(modalId==='8wj1bp7ziqsg'){if(pp_modal_8wj1bp7ziqsg instanceof PPModalBox){pp_modal_8wj1bp7ziqsg.show();}else{pp_modal_8wj1bp7ziqsg=new PPModalBox(pp_modal_8wj1bp7ziqsg_config);}}}});});pp_modal_8wj1bp7ziqsg=new PPModalBox(pp_modal_8wj1bp7ziqsg_config);pp_modal_8wj1bp7ziqsg_config.customTrigger='';$(document).on('click keydown','.modal-8wj1bp7ziqsg',function(e){var valid=(e.which==1||e.which==13||e.which==32||e.which==undefined);if(!valid){return;}
e.preventDefault();if(pp_modal_8wj1bp7ziqsg instanceof PPModalBox){pp_modal_8wj1bp7ziqsg.settings.clickedElement=$(e.target);pp_modal_8wj1bp7ziqsg.show();}else{pp_modal_8wj1bp7ziqsg_config.clickedElement=$(e.target);pp_modal_8wj1bp7ziqsg=new PPModalBox(pp_modal_8wj1bp7ziqsg_config);}});})(jQuery);