<?php

// Defines
define( 'FL_CHILD_THEME_DIR', get_stylesheet_directory() );
define( 'FL_CHILD_THEME_URL', get_stylesheet_directory_uri() );

// Classes
require_once 'classes/class-fl-child-theme.php';

// Actions
add_action( 'fl_head', 'FLChildTheme::stylesheet' );

if (function_exists('add_image_size')) {
  add_image_size('portfolio', 428, 260, true);

	  add_image_size('news', 260, 200, true);

}
add_filter('image_size_names_choose', 'insert_custom_image_sizes'); 
function insert_custom_image_sizes($sizes) {
  global $_wp_additional_image_sizes;
  if (empty($_wp_additional_image_sizes)) {
    return $sizes;
  }
  foreach ($_wp_additional_image_sizes as $id => $data) {
    if (!isset($sizes[$id])) {
      $sizes[$id] = ucfirst(str_replace('-', ' ', $id));
    }
  }
  return $sizes;
}

add_filter( 'gform_required_legend', '__return_empty_string' );

/**
 * Remove number count from dropdown
 */

add_filter( 'facetwp_facet_dropdown_show_counts', '__return_false' );
// CREATE CATEGORY DROPDOWN
function category_dropdown_shortcode() {
    // Get all categories
    $categories = get_categories( array(
        'orderby' => 'name',
        'hide_empty' => false,
    ) );

    // Start output buffering
    ob_start();
    ?>
    <select onchange="if(this.value) window.location.href=this.value;" style="padding:5px; font-size:16px;">
        <option value="">Select a category</option>
        <?php foreach ( $categories as $category ) : ?>
            <option value="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>">
                <?php echo esc_html( $category->name ); ?>
            </option>
        <?php endforeach; ?>
    </select>
    <?php
    return ob_get_clean();
}
add_shortcode( 'category_dropdown', 'category_dropdown_shortcode' );

// CREATE TAG DROPDOWN

function tag_dropdown_shortcode() {
    // Get all tags
    $tags = get_tags( array(
        'orderby' => 'name',
        'hide_empty' => false,
    ) );

    // Start output buffering
    ob_start();
    ?>
    <select onchange="if(this.value) window.location.href=this.value;" style="padding:5px; font-size:16px;">
        <option value="">Select a tag</option>
        <?php foreach ( $tags as $tag ) : ?>
            <option value="<?php echo esc_url( get_tag_link( $tag->term_id ) ); ?>">
                <?php echo esc_html( $tag->name ); ?>
            </option>
        <?php endforeach; ?>
    </select>
    <?php
    return ob_get_clean();
}
add_shortcode( 'tag_dropdown', 'tag_dropdown_shortcode' );

// SHOW SIX BLOG POSTS

function custom_posts_per_page_archive( $query ) {
    if ( ! is_admin() && $query->is_main_query() && $query->is_home() ) {
        $query->set( 'posts_per_page', 6 );
    }
}
add_action( 'pre_get_posts', 'custom_posts_per_page_archive' );