<?php


if(!class_exists('BtZIndex')){
  
  class BtZIndex {
      /** 
       * Constructor function for the module. You must pass the
       * name, description, dir and url in an array to the parent class.
       *
       * @method __construct
       */  

      function __construct(){

        //filters
        add_filter( 'fl_builder_register_settings_form' , array($this,'add_z_settings'), 20 , 2 );
        add_filter( 'fl_builder_render_css',array($this,'bt_zindex'), 10,3 );
      }


      function bt_zindex($css, $nodes, $global_settings ){

        $ncss = '';

        foreach($nodes['rows'] as $row)
        {
          if(isset($row->settings->zindex) && $row->settings->zindex !== '')
          {
            $node = $row->node;
            $zindex = $row->settings->zindex;
            $ncss .= "body:not(.fl-builder-edit) .fl-node-$node{z-index:$zindex; position:relative;}";
          }
          
          if(isset($row->settings->zindexhover) && $row->settings->zindexhover !== '')
          {
            $node = $row->node;
            $zindex = $row->settings->zindexhover;
            $ncss .= "body:not(.fl-builder-edit) .fl-node-$node:hover{z-index:$zindex; position:relative;}";
          }

          
          
        }

        foreach($nodes['columns'] as $row)
        {
          if(isset($row->settings->zindex) && $row->settings->zindex !== '')
          {
            $node = $row->node;
            $zindex = $row->settings->zindex;
            $ncss .= "body:not(.fl-builder-edit) .fl-node-$node{z-index:$zindex; position:relative;}";
          }
          if(isset($row->settings->zindexhover) && $row->settings->zindexhover !== '')
          {
            $node = $row->node;
            $zindex = $row->settings->zindex;
            $ncss .= "body:not(.fl-builder-edit) .fl-node-$node:hover{z-index:$zindex; position:relative;}";
          }
        }
        foreach($nodes['modules'] as $row)
        {
          if(isset($row->settings->zindex) && $row->settings->zindex !== '')
          {
            $node = $row->node;
            $zindex = $row->settings->zindex;
            $ncss .= "body:not(.fl-builder-edit) .fl-node-$node{z-index:$zindex; position:relative;}";
          }
          if(isset($row->settings->zindexhover) && $row->settings->zindexhover !== '')
          {
            $node = $row->node;
            $zindex = $row->settings->zindexhover;
            $ncss .= "body:not(.fl-builder-edit) .fl-node-$node:hover{z-index:$zindex; position:relative;}";
          }
        }
        return $css .$ncss;
      }



      function add_z_settings( $form, $slug ) {

        if ( 'col' === $slug || 'row' === $slug ) {

          $form[ 'tabs' ][ 'advanced' ][ 'sections' ][ 'visibility' ][ 'fields' ][ 'zindex' ] = [
            'type'        => 'unit',
            'label'       => 'Z-index',
          ];
          $form[ 'tabs' ][ 'advanced' ][ 'sections' ][ 'visibility' ][ 'fields' ][ 'zindexhover' ] = [
            'type'        => 'unit',
            'label'       => 'Z-index on hover',
          ];
        }
        
        if('module_advanced' === $slug)
        {
          $form[ 'sections' ][ 'visibility' ][ 'fields' ][ 'zindex' ] = [
            'type'        => 'unit',
            'label'       => 'Z-index',
          ];
          $form[ 'sections' ][ 'visibility' ][ 'fields' ][ 'zindexhover' ] = [
            'type'        => 'unit',
            'label'       => 'Z-index on hover',
          ];
        }
        return $form;
      }

    }
    $btzi = new BtZIndex();
}
