<?php



if(!class_exists( 'Bt_Template_Jumper'))
{

  class Bt_Template_Jumper {

    function __construct() {
      //add filters
      add_filter( 'wp_enqueue_scripts', array( $this,'link_jumper_scripts'),10, 2);
      add_action( 'wp_footer', array( $this,'custom_BB_border_colors'),10 );
      add_action( 'admin_init', array( $this,'jump_to_builder'),10, 3 );

    }

    // jump directly to the page builder from the post id edit page
    function jump_to_builder(){

        if(isset($_GET['launch_builder']) && isset($_GET['post'])) // if its a post page and has the special launch builder param
        {
          if(get_post_meta($_GET['post'],'_fl_builder_enabled',true)) // if bb is enabled
          {
            wp_redirect(get_the_permalink($_GET['post']) . '?fl_builder' ); // redirect to the builderr
            exit; //gotta exit
          }
        }
    }


    function link_jumper_scripts() {

      if(FLBuilderUserAccess::current_user_can( 'theme_builder_editing' ))
      {
        wp_enqueue_script( 'link-jumper', plugins_url('template-jumper.js', __FILE__ ), array('jquery') );
        wp_enqueue_style( 'link-jumper-style', plugins_url( 'template-jumper.css', __FILE__ ));
      }
    }


  function custom_BB_border_colors(){
    if(!isset($_GET['fl_builder']))
      return; // only in builder

    $newcss = '';
    $developerSettings = get_option('bt_developer_settings');

    
    if(!isset($developerSettings))
      return; // only w settings

      if($developerSettings['bt-template-jumper-template'] == '')
        $developerSettings['bt-template-jumper-template'] == '03cea4';
    
    //bt-template-jumper-default

    $defaultBorder = $developerSettings['bt-template-jumper-default'];
    $defaultBorder = trim(str_replace('#','',$defaultBorder));

    //bt-template-jumper-nested
    $nestedBorder = $developerSettings['bt-template-jumper-nested'];
    $nestedBorder = trim(str_replace('#','',$nestedBorder));
    //bt-template-jumper-nested
    $templateBorder = $developerSettings['bt-template-jumper-template'];
    $templateBorder = trim(str_replace('#','',$templateBorder));
    //bt-template-jumper-global
    $globalBorder = $developerSettings['bt-template-jumper-global'];
    $globalBorder = trim(str_replace('#','',$globalBorder));
    
    if($defaultBorder !== '')
    {
      $newcss .= "
      :root { /* update vars */
        --fl-builder-radius:0;
      	--fl-builder-accent-color: #$defaultBorder;
      	--overlay-tint: #$defaultBorder;
        }
      .fl-row-overlay, .fl-module-overlay{
          border-color:#$defaultBorder !important;
          outline-color:#$defaultBorder !important;
        }

        .fl-block-overlay-actions{
          background-color:#$defaultBorder !important;
          outline-color:#$defaultBorder !important;
        }";
    }

    if($nestedBorder !== '')
    {
      $newcss .="
      .fl-col-group-nested .fl-col-highlight .fl-col-content, .fl-col-group-nested .fl-col-overlay, .fl-col-group-nested .fl-module-overlay{
        border-color:#$nestedBorder !important;
        outline-color:#$nestedBorder !important;
      }
        .fl-col-group-nested .fl-block-overlay-actions{
          background:#$nestedBorder !important;
        }
        .fl-col-group-nested .fl-block-overlay-actions ul.fl-builder-submenu{
          background:#$nestedBorder !important;
        }
        .fl-col-group-nested .fl-block-col-resize-handle{
          border-color:#$nestedBorder !important;
          }
      ";      

    }

    if($globalBorder !== '')
    {
      $newcss .="
      .fl-block-overlay-global, .fl-block-overlay-global{
        border-color:#$globalBorder !important;
        outline-color:#$globalBorder !important;
      }
      .fl-block-overlay-global .fl-block-overlay-actions{
        background:#$globalBorder !important;
      }
      ";      
    }

    
    if($templateBorder !== '')
    {
      $newcss .="
        .bt-row-overlay {
            background: rgba(190, 239, 255, 0);
            border: 2px solid #$templateBorder !important;
            border-radius: 4px;
            box-sizing: border-box !important;
            -moz-box-sizing: border-box !important;
            -webkit-box-sizing: border-box !important;
            color: #fff;
            position: absolute;
            left: 2px;
            top: 2px;
            bottom: 2px;
            right: 2px;
            z-index: 100006;
        }
        .bt-row-overlay .fl-block-overlay-actions{
          background:#$templateBorder !important;
        }
      ";
    }



    echo "<style>" . $newcss . "</style>";
    } // end custom_BB_border_colors
  } // end class
  
  $bttj = new Bt_Template_Jumper();
}
