<?php

//add filters


if(! class_exists ( 'Bt_Pattern_Backgrounds'))
{

  class Bt_Pattern_Backgrounds{

    function __construct() {
              
      add_filter( 'fl_builder_register_settings_form' , array( $this,'bt_pro_register_settings'),11,2);
      add_filter( 'fl_builder_render_css' , array($this,'btbb_row_gradient_css'), 10 , 4 );
      
    }



  function bt_pro_register_settings( $form, $slug ) {


    if ( 'row' == $slug || 'col' == $slug) {

      include(__DIR__."/data.php");

      $patternList = array();

      foreach($patterns as $p)
      {			
        $patternList[$p['name']] = $p['name'];
      }

      $form['tabs']['style']['sections']['background']['fields']['bg_type']['options']['bt_pattern_bg'] = __('Pattern Background', 'btbb');
      $form['tabs']['style']['sections']['background']['fields']['bg_type']['toggle']['bt_pattern_bg'] = array(
          'sections'  => array('bt_pattern_bg')
      );

      $form['tabs']['style']['sections']['bt_pattern_bg'] = array(
          'title'     => __('Pattern Background', 'btbb'),
          'fields'    => array(
              'btbb_pattern' => array(
                'type'          => 'select',
                'label'         => __( 'Pattern', 'btbb' ),
                'default'       => '',
                'options'       => $patternList,
              ),
              'btbb_pattern_color'    => array(
                  'type'              => 'color',
                  'label'             => __('Pattern Color', 'btbb'),
                  'show_reset'        => true,
                  'default'           => 'grey',
                  'show_alpha'    => true
              ),
              'btbb_background_color'    => array(
                  'type'              => 'color',
                  'label'             => __('Pattern Background', 'btbb'),
                  'show_reset'        => true,    
                  'default'           => 'whitesmoke',
                  'show_alpha'    => true

              ),
              'btbb_pattern_size' => array(
                  'type'        			=> 'unit',
                  'label'       			=> __('Pattern Size', 'btbb'),
                  'description' 			=> 'px',
                  'default'						=> '',
              ),

          )
      );
    }

     //Now we pass back the form to the filter
    return $form;
  }




  //render the CSS for the 

  function btbb_row_gradient_css($css, $nodes, $global_settings){

    $btbb_css = "";

    foreach ( $nodes['rows'] as $row ) {
      if(isset($row->settings->bg_type) && $row->settings->bg_type == "bt_pattern_bg")
      {
        $btbb_css .= $this->create_pattern_bg_css($row->node, $row->settings->btbb_pattern, $row->settings->btbb_pattern_color, $row->settings->btbb_background_color, $row->settings->btbb_pattern_size);
      }
    }

    foreach ( $nodes['columns'] as $column ) {
      if(isset($column->settings->bg_type) && $column->settings->bg_type == "bt_pattern_bg")
      {
        $btbb_css .= $this->create_pattern_bg_css($column->node, $column->settings->btbb_pattern, $column->settings->btbb_pattern_color, $column->settings->btbb_background_color, $column->settings->btbb_pattern_size);
      }
    }

    return $css . $btbb_css;
  }




    function create_pattern_bg_css($node, $pattern, $pattern_color, $background_color, $background_size){

      include(__DIR__."/data.php");

      if(!(strpos($pattern_color, 'rgba') !== false))
        $pattern_color = "#".$pattern_color;  

      if(!(strpos($background_color, 'rgba') !== false))
        $background_color = "#".$background_color;     

      ob_start();

      foreach($patterns as $key => $var)
      {
        if($var['name'] == $pattern)
        {
          $var['image'] = str_replace('#000', $pattern_color,$var['image']);
          ?>
          .fl-node-<?php echo $node; ?>>.fl-row-content-wrap,    .fl-node-<?php echo $node; ?>>.fl-col-content{ 
            background-color: <?php echo $background_color;?>;
            background-image: url("data:image/svg+xml;base64,<?php echo base64_encode($var['image']);?>");
            background-size: <?php echo $background_size;?>px;
          }
          <?php
        }
      }
      return ob_get_clean();
    }
  }
  
  $btpb = new Bt_Pattern_Backgrounds();

}











