<?php


if(! class_exists ( 'Bt_Sticky_Column') && class_exists('FLBuilder'))
{
  class Bt_Sticky_Column{

    function __construct(){

      //filters
      add_filter( 'fl_builder_register_settings_form' , array($this,'add_sticky_settings'), 20 , 2 );
      add_filter( 'fl_builder_column_attributes' , array( $this,'add_column_attributes'), 10, 2);
      add_filter( 'fl_builder_row_attributes' , array( $this,'add_column_attributes'), 10, 2);
      add_filter( 'wp_enqueue_scripts' , array($this,'bt_sticky_column_scripts'), 20 , 2 );
      
    }

    function add_sticky_settings( $form, $slug ) {

      
      if ( 'col' === $slug || 'row' === $slug ) {
        if($slug == 'col')
          $label = 'Sticky Column';
        if($slug == 'row')
          $label = 'Sticky Row';

        $form[ 'tabs' ][ 'advanced' ][ 'sections' ][ 'visibility' ][ 'fields' ][ 'sticky' ] = [
          'type'    => 'select',
          'label'   => $label,
          'help' => 'Choose screen sizes that you want sticky to happen on.',
          'default' => 'false',
          'options'       => array(
            'false'      => __( 'Never', 'fl-builder' ),
            'true'      => __( 'All Screen Sizes', 'fl-builder' ),
            'large'      => __( 'Large Only', 'fl-builder' ),
            'large-med'      => __( 'Large + Medium', 'fl-builder' ),
            'med'      => __( 'Medium Only', 'fl-builder' ),
            'med-small'      => __( 'Small + Medium', 'fl-builder' ),
            'small'      => __( 'Small Only', 'fl-builder' ),
            
          ),
          'toggle'        => array(
            'true'      => array(
                'fields'  => array( 'stickyOffset' ,'stickPosition', 'stickToBody')
             ),
            'large'      => array(
                'fields'  => array( 'stickyOffset' ,'stickPosition', 'stickToBody')
             ),
            'large-med'      => array(
                'fields'  => array( 'stickyOffset' ,'stickPosition', 'stickToBody')
             ),
            'med'      => array(
                'fields'  => array( 'stickyOffset' ,'stickPosition', 'stickToBody')
             ),
            'med-small'      => array(
                'fields'  => array( 'stickyOffset' ,'stickPosition', 'stickToBody')
             ),
            'small'      => array(
                'fields'  => array( 'stickyOffset' ,'stickPosition', 'stickToBody')
             ),
            'false'   => array()
          )
        ];
        $form[ 'tabs' ][ 'advanced' ][ 'sections' ][ 'visibility' ][ 'fields' ][ 'stickPosition' ] = [
          'type'    => 'select',
          'label'   => 'Sticky Position',
          'help' => 'Stick to the top of bottom of the screen.',
          'default' => 'top',
          'options'       => array(
            'top'      => __( 'Top', 'fl-builder' ),
            'bottom'      => __( 'Bottom', 'fl-builder' ),           
          ),
        ];

        $form[ 'tabs' ][ 'advanced' ][ 'sections' ][ 'visibility' ][ 'fields' ][ 'stickyOffset' ] = [
          'type'        => 'unit',
          'label'       => 'Offset from the top or bottom of the window',
          'help'        => 'If you have another sticky item that you want to avoid, use offset to bump the sticky item up or down.',
          'default'     => '50',
          'description' => 'px',
        ];

        if($slug == 'row')
        {
          $form[ 'tabs' ][ 'advanced' ][ 'sections' ][ 'visibility' ][ 'fields' ][ 'stickToBody' ] = [
            'type'    => 'select',
            'label'   => 'Sticky Parent',
            'help'    => 'If you want your sticky row to not be constrained inside its parent Beaver Builder editor area, select the location to move it to, or leave inline.',
            'default' => 'inline',
            'options'       => array(
              'inline'      => __( 'Leave inline', 'fl-builder' ),
              'before-header'      => __( 'Before Header', 'fl-builder' ),        
              'after-header'      => __( 'After Header', 'fl-builder' ),        
              'before-footer'      => __( 'Before Footer', 'fl-builder' ),        
              'after-footer'      => __( 'After Footer', 'fl-builder' ),           
            ),
          ];
        }


      }

      /**
       * Now we pass back the form to the filter
       */
      return $form;
    }


    function add_column_attributes( $attrs, $column ) {
      // if there is a data sticky attribute set, then add the atts to the page
      if ( isset( $column->settings->sticky )  &&  'false' !== $column->settings->sticky)  {
        $attrs[ 'bt-sticky' ] = $column->settings->sticky;
        $attrs[ 'bt-sticky-offset' ] = $column->settings->stickyOffset;
        $attrs[ 'bt-sticky-position' ] = $column->settings->stickPosition;
        $attrs['bt-sticky-to-body'] = isset($column->settings->stickToBody) ? $column->settings->stickToBody : '';

      }

      return $attrs;
    }

    //enqueue js
    function bt_sticky_column_scripts() {
        wp_enqueue_script( 'sticky_script', plugin_dir_url( __FILE__ ) . 'js/sticky-column.js', array('jquery') );
        wp_enqueue_style( 'sticky_style', plugin_dir_url( __FILE__ ) . 'css/sticky-column.css' );
    }
  }
  $btsc = new Bt_Sticky_Column();
}

