<?php


// add a scss tab to BB Global Options. Output after standard BB CSS


use SsScssPhp\SsScssPhp\Compiler;

if(! class_exists ( 'Bt_Global_Scss') && class_exists('FLBuilder'))
{
  class Bt_Global_Scss{

    function __construct(){
        // enqueue things
        add_filter( 'fl_builder_render_css', [$this,'my_builder_render_css'], 10, 3 );
        add_action( 'wp_ajax_render_scss', [$this,'render_scss_ajax'] );
        add_filter( 'fl_builder_register_settings_form', [$this,'sitespot_dev_add_scss_tab'], 10, 2 );
        add_filter( 'fl_ace_editor_settings', [$this,'ace_show_line_numbers'], 10, 2 );
        add_action( 'wp_enqueue_scripts', [$this,'enqueue_scripts'] );
    }

    function ace_show_line_numbers($defaults){
        $defaults['showLineNumbers'] = true;
        return $defaults;
    }

    /** 
    * Filter the Global Settings Options with array_merge.
    * Media breakpoints and form title have been changed.
    */
    function sitespot_dev_add_scss_tab( $form, $id ) {
        $form2 = array();
        if ( 'global' == $id ) {
            //return $form;
            $form['tabs']['scss']  = array(
                'title'         => __('Smart CSS', 'fl-builder'),
                'sections'      => array(
                    'scss_section'  			=> array(
                        'title'         => '',
                        'fields'        => array(
                            'scss_input'    => array(
                                'type'      => 'code',
                                'editor'        => 'css',
                                'rows'          => '6',
                                'label'     => 'SCSS input',
                                'description' => '<div id="scss-vars">View SCSS variables</div><div id="scss-vars-list">'.$this->get_scss_smart_vars().'</div>',
                                
                                'preview'   => [
                                    'type'  => 'none'
                                ]
                            ),
                            'scss_output'    => array(
                                'type'      => 'code',
                                'editor'        => 'css',
                                'label'     => 'CSS Output:',
                                'description' => 'Do not edit, this will be overwritten on save.',
                                'placeholder'   => __( 'Your generated CSS (or error) will be displayed here.', 'fl-builder' ),
                                'readonly' => true,
                                'preview'   => [
                                    'type'  => 'none'
                                ]
                            )
                        )
                    )
                )
            );
        }
    return $form;
    }

    // hook into save

    function my_builder_render_css( $css, $nodes, $global_settings ) {

        $scss_input = $global_settings->scss_input;

        // turn the shortcodes into stuff, then render it.
        $compiled = $this->render_scss(do_shortcode($scss_input));

        return $css . "
        /* BEGIN SCSS */
        " .$compiled . "
        /* END SCSS */
        ";
    }

    function render_scss($scss_input) {

        require_once "scssphp/scss.inc.php";

        // INCLUDE THE GLOBAL VARS FROM FL BUILDER
        $scss_input = $this->get_scss_smart_vars() . $scss_input;
        $scss = new Compiler();
        try {
            $compiled =  @$scss->compile(do_shortcode($scss_input));
        } catch (Exception $e) {
            $compiled =  "/* COMPILE ERROR: " . $e->getMessage() . " */";
        }

        return $compiled;
    }

    function render_scss_ajax(){
        die($this->render_scss($_REQUEST['scss']));
    }

    //function to include global variables etc. also sace as css vars?
    function get_scss_smart_vars(){

        $color_presets = get_option('_fl_builder_color_presets');
        $scss = "";

        if(!empty($color_presets))
        {
            foreach($color_presets as $index => $color)
            {
                if (!(strpos($color, 'rgb') !== false) && !(substr( $color, 0, 1 ) === "#"))
                    $color = "#".$color;

                $scss .= '$color-preset-'.$index.': '.$color.";\n";
            }
            $scss .= "\n";
        }
        $builder_settings = get_option('_fl_builder_settings');

        if(!empty($builder_settings))
        {        
            $scss .= '$responsive_base_fontsize: '.$builder_settings->responsive_base_fontsize."px;\n";
            $scss .= '$medium_breakpoint: '.$builder_settings->medium_breakpoint ."px;\n";
            $scss .= '$responsive_breakpoint: '.$builder_settings->responsive_breakpoint ."px;\n\n";

            $scss .= '$row_width: '.$builder_settings->row_width . $builder_settings->row_width_unit.";\n\n";

//            $scss .= '$row_margins: '.$builder_settings->row_margins . $builder_settings->row_margins_unit.";\n";
  //          $scss .= '$row_margins_medium: '.$builder_settings->row_margins_medium . $builder_settings->row_margins_medium_unit . ";\n";
    //        $scss .= '$row_margins_responsive: '.$builder_settings->row_margins_responsive . $builder_settings->row_margins_responsive_unit . ";\n\n";

//            $scss .= '$row_padding: '.$builder_settings->row_padding . $builder_settings->row_padding_unit.";\n";
  //          $scss .= '$row_padding_medium: '.$builder_settings->row_padding_medium . $builder_settings->row_padding_medium_unit.";\n";
    //        $scss .= '$row_padding_responsive: '.$builder_settings->row_padding_responsive . $builder_settings->row_padding_responsive_unit.";\n\n";

      /*      $scss .= '$column_margins: '.$builder_settings->column_margins . $builder_settings->column_margins_unit.";\n";
            $scss .= '$column_margins_medium: '.$builder_settings->column_margins_medium . $builder_settings->column_margins_medium_unit.";\n";
            $scss .= '$column_margins_responsive: '.$builder_settings->column_margins_responsive . $builder_settings->column_margins_responsive_unit.";\n\n";
            
            $scss .= '$column_padding: '.$builder_settings->column_padding . $builder_settings->column_padding_unit.";\n";
            $scss .= '$column_padding_medium: '.$builder_settings->column_padding_medium . $builder_settings->column_padding_medium_unit.";\n";
            $scss .= '$column_padding_responsive: '.$builder_settings->column_padding_responsive . $builder_settings->column_padding_responsive_unit.";\n\n";

            $scss .= '$module_margins: '.$builder_settings->module_margins . $builder_settings->module_margins_unit.";\n";
            $scss .= '$module_margins_medium: '.$builder_settings->module_margins_medium . $builder_settings->module_margins_medium_unit.";\n";
            $scss .= '$module_margins_responsive: '.$builder_settings->module_margins_responsive . $builder_settings->module_margins_responsive_unit.";\n";*/
        }
        
        return  $scss;
    }

    function enqueue_scripts(){
        // Check if Beaver Builder is active FLBuilderModel
        if ( class_exists('FLBuilderModel') && FLBuilderModel::is_builder_active() ) {
            wp_enqueue_script('btscssjs',plugin_dir_url( __FILE__ ) . 'js/mode-scss.js', array('jquery') );
            wp_enqueue_style('btscsscss',plugin_dir_url( __FILE__ ) . 'css/mode-scss.css' );        
        }
     }

  }

    $btsc = new Bt_Global_Scss();

}



