<?php

/**
 * @class ReadTimeModule
 */



define( 'FL_READ_TIME_DIR', plugin_dir_path( __FILE__ ) );
define( 'FL_READ_TIME_URL', plugins_url( '/', __FILE__ ) );

if(! class_exists ( 'ReadTimeModule'))
{

  class ReadTimeModule extends FLBuilderModule {

      /** 
       * Constructor function for the module. You must pass the
       * name, description, dir and url in an array to the parent class.
       *
       * @method __construct
       */  
      public function __construct()
      {
          parent::__construct(array(
              'name'          => __('Time To Read', 'fl-builder'),
              'description'   => __('Creates a medium style \'time to read\' text output.', 'fl-builder'),
              'category'		  => __('Utilities', 'fl-builder'),
              'group'         => 'Beaver Team Pro',
              'dir'           => FL_READ_TIME_DIR . '/',
              'url'           => FL_READ_TIME_URL . '/',
          ));
      }
  }


  add_action( 'init',function(){

    /**
     * Register the module and its form settings.
     */
    FLBuilder::register_module('ReadTimeModule', array(
        'general'       => array( // Tab
            'title'         => __('General', 'fl-builder'), // Tab title
            'sections'      => array( // Tab Sections
                'general'       => array( // Section
                    'title'         => __('Setup', 'fl-builder'), // Section Title
                    'fields'        => array( // Section Fields
                        'read_time'     => array(
                            'type'          => 'text',
                            'label'         => __('Selector', 'fl-builder'),
                            'default'       => 'article',
                            'placeholder'   => 'article',
                            'help'          => 'The jQuery selector for your article. The default usually works fine.',
                        ),
                        'read_time_pre'     => array(
                            'type'          => 'text',
                            'label'         => __('Text before', 'fl-builder'),
                            'default'       => 'Read time:',
                            'placeholder'   => '10',
                            'default'       => 'Read time:',
                            'help'          => 'The text you want displayed before the read time.',
                        ),
                        'read_time_post'     => array(
                            'type'          => 'text',
                            'label'         => __('Text after', 'fl-builder'),
                            'default'       => 'minutes',
                            'help'          => 'The text you want displayed before the read time.',
                        ),
                      )
                  ),
                  'style'     => array(
                      'title'    => 'Style',
                      'fields'   => array(
                        'read_time_font'     => array(
                            'type'          => 'font',
                            'default'       => '',
                            'label'         => __('Font', 'fl-builder'),
                        ),
                        'read_time_font_size' => array(
                          'type'        => 'unit',
                          'label'       => 'Font Size',
                            'default'       => '14',
                          'description' => 'px',
                        ),
                        'read_time_color'     =>array(
                            'type'            => 'color',
                            'label'           => "Color",
                            'default'       => '',
                            'show_reset'    => true,

                        ),
                    )
                )
            )
        )
    ));
  });
}