<?php

/**
 * This file should be used to render each module instance.
 * You have access to two variables in this file: 
 * 
 * $module An instance of your module class.
 * $settings The module's settings.
 *
 */

$style = '';
if(empty($settings->read_time_font)){
  echo "Read Time: x minutes";
  return;
}

if(!empty($settings->read_time_font))
{
  $fw = $settings->read_time_font['weight'];
  $ff = $settings->read_time_font['family'];
}
$fc = $settings->read_time_color;
$fs = $settings->read_time_font_size;

if(! empty($fc))
  $style .= " color:#".$fc.";";
if(! empty($fw))
  $style .= " font-weight:".$fw.";";
if(! empty($ff))
  $style .= " font-family:".$ff.";";
if(! empty($fs))
  $style .= " font-size:".$fs."px;";

?>

<div class="sp-read-time" style="<?php echo $style ?>">
  <span class="sp-read-time-pre"><?php echo $settings->read_time_pre; ?></span>
  <span class="sp-read-time-time"></span>
  <span class="sp-read-time-post"><?php echo $settings->read_time_post; ?></span>
    
  <script>
  jQuery(document).ready(function(){
    	jQuery('<?php echo $settings->read_time; ?>').readingTime({
        readingTimeAsNumber: true,
        readingTimeTarget: jQuery('.sp-read-time-time'),
  	});
  });
  </script>
</div>