<?php
/* Add the notes field to all BB modules, rows, columns. Updated, now on the 'Home Tab'
 * With love from https://sitespot.dev
 */


if(!function_exists('bt_register_notes'))
{
  
  
  add_filter( 'fl_builder_register_settings_form', 'bt_register_notes', 9999999999999999, 2 );
  add_action( 'wp_enqueue_scripts','bt_notes_load_scripts');
  
  function bt_notes_load_scripts(){

    $bt_pro_settings = bt_pro_settings();

    // do the tooltip thing
    if($bt_pro_settings['bt-notes-tooltip'])
    {
      //enqueue style
      wp_enqueue_script('jquery-tiptip', plugin_dir_url( __FILE__ ) . 'js/tiptip.js', array('jquery')); 
      wp_enqueue_script( 'notes-tooltips', plugin_dir_url( __FILE__ ) . 'js/notes-tooltips.js', array('jquery'));
      wp_enqueue_style( 'notes-tooltip', plugin_dir_url( __FILE__ ) . 'css/notes-tooltips.css');
      add_filter( 'fl_builder_module_attributes', 'bt_notes_row_attributes',10,2 );
    }


    // swaptextarea for text and replace video url's with embeds
    if($bt_pro_settings['bt-notes-restrict-editing'] && !is_super_admin())
    {
      wp_enqueue_style( 'notes-helper', plugin_dir_url( __FILE__ ) . 'css/notes-helper.css');
      wp_enqueue_style( 'notes-tiptip', plugin_dir_url( __FILE__ ) . 'css/tiptip.css');
      wp_enqueue_script( 'notes-helper', plugin_dir_url( __FILE__ ) . 'js/notes-helper.js', array('jquery', 'jquery-tiptip')); 
    }

    // hide notes all together - they'll still show in the tooltip of you have it enabled
    if($bt_pro_settings['bt-notes-restrict-viewing'] && !is_super_admin())
    {
      wp_enqueue_style( 'notes-hider', plugin_dir_url( __FILE__ ) . 'css/notes-hide.css');
    }
  }
  
  
  
  function bt_notes_row_attributes($attrs, $row){
    
    //ditch if no note
    if(!isset($row->settings->bt_notes))
      return $attrs;
    
    if(is_user_logged_in()) // only show to logged in users
    {
      //add the bt_note attribute
      $attrs['bt-note'] = $row->settings->bt_notes;
    }
    return $attrs;
  }
  
  
  function bt_register_notes( $form, $slug ) {
  
    $key = key($form);

    $excluded_modules = array(
      'user_template', 
      'node_template', 
      'uabb-global',
      'global',
      'layout',
      'module_advanced',
      'custom_post_layout');

    if ( 'col' === $slug || 'row' === $slug ) {

      $form[ 'tabs' ][ 'style' ][ 'sections' ][ 'general' ][ 'fields' ][ 'bt_notes' ] = [
              'type'          => 'textarea',
              'label'         => 'Your Notes (Not displayed on website)',
              'placeholder'   => 'Notes',
              'rows'          => '6'
          ];  
    }
    elseif( !in_array($slug,$excluded_modules) && isset($form[$key]['sections'])  )
    {
      
      $form[$key][ 'sections' ]['bt_notes_section'] = [
        'title' => 'Notes',
        'fields' => [
          'bt_notes' => [
                'type'          => 'textarea',
                'label'         => 'Your Notes (Not displayed on website)',
                'placeholder'   => 'Notes',
                'rows'          => '6'
            ]
          ]
        ];
    }

    return $form;    
  }

}
