<?php

/* ADDS MEGA MENU OPTIONS TO MENU MODULE AND LOADS CSS / JS */

if( !class_exists('SS_Mega_Menu') ) {

  class SS_Mega_Menu{

    function __construct(){
      add_filter( 'wp_enqueue_scripts' , array($this,'load_scripts_styles') , 20 , 2 );
      add_filter( 'fl_builder_register_settings_form', array($this,'my_builder_register_settings_form'), 10, 2 );
      add_filter( 'fl_builder_module_attributes', array($this,'add_mega_row_attributes'),10,2 ); // add ab settings to module
    }

    function load_scripts_styles(){
      wp_enqueue_script( 'ss_mega_menu', plugin_dir_url( __FILE__ ) . 'js/mega-menu.js', array('jquery'),SS_BEAVER_TEAM_PRO_VERSION);
      wp_enqueue_style( 'ss_mega_menu', plugin_dir_url( __FILE__ ).'css/mega-menu.css');
    }

    // add to menu  qas
    function my_builder_register_settings_form( $form, $id ) {
        if ( 'menu' == $id ) {
           // add mega menu checkbox
            $form['general']['sections']['general']['fields']['megamenu'] = array(
              'type' => 'select',
              'label' => 'Mega Menu',
              'default' => 0,
              'options' => array(
                1 => 'Yes',
                0 => 'No',
              ),
              'toggle' => array(
                1 => array(
                  'fields'  => array('megaposition','megastyle','megaAnimateSpeed')
                )
              )
            );
            $form['general']['sections']['general']['fields']['megaposition'] = array(
              'type' => 'select',
              'label' => 'Position',
              'default' => 'fixed',
              'options' => array(
                'absolute' => 'Absolute',
                'fixed' => 'Fixed',
              ),
            );
            $form['general']['sections']['general']['fields']['megastyle'] = array(
              'type' => 'select',
              'label'   => 'Show Mega Menu on',
              'default' => 'click',
              'options' => array(
                  'click'    => 'Click',
                  'hover'  => 'Hover',
              )
          );
            $form['general']['sections']['general']['fields']['megaAnimateSpeed'] = array(
              'type'        => 'unit',
              'label'   => 'Fade in speed',
              'default' => '0',
              'description' => 'ms',
          );
        }
        return $form;
    }

    function add_mega_row_attributes($attrs, $row){
    
      if(empty($row->settings->megamenu))
        return $attrs;

      if($row->settings->megamenu == 1)
      {
          $attrs['bt-mega'] = "1";
          $attrs['bt-mega-position'] = $row->settings->megaposition;
          $attrs['bt-mega-style'] = $row->settings->megastyle;
          $attrs['bt-mega-animate-speed'] = isset($row->settings->megaAnimateSpeed) ? $row->settings->megaAnimateSpeed : '2000';
      }

      return $attrs;
    }

  } /*  end class */

  $SS_Mega_Menu = new SS_Mega_Menu;
}

