// mega menu js

var menuElement = "[bt-mega] :not('.sub-menu')>.menu-item";
var mobileToggle = '[bt-mega] .fl-menu-mobile-toggle';

function megaMenuTitle(theText){

    //v2 thanks Zack Pyle for inspo
    theText = theText.replace(/[^0-9a-z]/gi, ' ').trim().replace(" ","-").replace(/[^\w-]+/g,"-").replace("---","-").replace("--","-");
    return theText.toLowerCase();
}

function isMegaMobile(){

    breakpoint = FLBuilderLayoutConfig.breakpoints.small

    if(jQuery('.fl-menu-responsive-toggle-medium-mobile').length){
        breakpoint = FLBuilderLayoutConfig.breakpoints.medium;
    }

    if(jQuery('.fl-menu-responsive-toggle-always').length){
        return true;
    }

    var status = breakpoint > jQuery(window).width();
    
    return status;
}


function megaDebug(){
    jQuery(menuElement).each(function(){
        console.log("mega-"+megaMenuTitle(jQuery(this).text()));
    });
}

jQuery(document).ready(function(){

    // dont do if bb is running
    if(jQuery('body').hasClass('fl-builder-edit'))
        return true; 

    if(jQuery('[id^="mega-"]').length == 0)
        return;

    //add the helper parent class to the mega menu for mobile
    jQuery('[id^="mega-"]').first().parent().addClass('mega-mobile-container');

    window.megaWidthCurrentScreenWidth = isMegaMobile(); // save current width to global

    //set location of megas on resize
    jQuery(window).on('resize', function () {

        // refresh if screensize changes to from responsive 

        if(window.megaWidthCurrentScreenWidth !== isMegaMobile()){
            window.megaWidthCurrentScreenWidth = isMegaMobile();
            hideMega();
        }

        if(isMegaMobile())// set init value 
        { 
            //set top value of container 
            topValue = jQuery('[bt-mega]')[0].getBoundingClientRect().bottom;  
            if(jQuery('#wpadminbar').length){ 
                topValue += jQuery('#wpadminbar')[0].getBoundingClientRect().bottom; 
            } 
            jQuery('.mega-mobile-container').css('top',topValue + 'px'); 
        } 
        else 
        { 
            topValue = 0; 
            jQuery('.mega-mobile-container').css('top',topValue); 
            jQuery('.show-mega-mobile').removeClass('show-mega-mobile'); 
        } 
         
    }).resize();

    jQuery(menuElement).each(function(){

        //get attrs about mega menu
        var menuItem = jQuery(this);
        var megaItem = jQuery("#"+"mega-"+megaMenuTitle(menuItem.text()));
        var nextItem;

        if(megaItem.length) // if its mega anything
        {
            megaMouse = menuItem.parents('[bt-mega-style]').attr('bt-mega-style');
            if(megaMouse == 'hover')
                menuItem.addClass('has-mega-menu').addClass('hover-mega-menu');
            else
                menuItem.addClass('has-mega-menu').addClass('click-mega-menu');

            menuItem.addClass('has-mega-menu').children('a').attr('aria-expanded', 'false').attr('role', 'button').append('<span class="fl-menu-toggle"></span>');

            //set up click listeners for menu items ################################################################################################################################################
            menuItem.children().on('mouseenter mousedown click focus',function(event) {

                megaMouse = menuItem.parents('[bt-mega-style]').attr('bt-mega-style'); // get mega style
                if(megaMouse == 'click') // prevent default click if its a click mega menu
                {
                    event.preventDefault();
                    event.stopPropagation();
                }

                if(event.type == 'mousedown' && megaMouse == 'click') 
                    return;

                if(event.type == 'focus' && megaMouse == 'click') 
                    return;

                if(event.type == 'focus' && megaMouse == 'click') 
                    return;

                if (event.type == 'click' && megaMouse == 'click') {
                    mm = jQuery("#" + "mega-" + megaMenuTitle(jQuery(this).text()));
            
                    if (mm.hasClass('show-mega')) {
                        hideMega();
                        return;
                    }
                }
                
                if(event.type == 'click' && megaMouse == 'click' && jQuery(this).attr('class') == 'meg-exit') // ignore clicks, unles its a focus click kinda hacky but no issues sofa
                    hideMega();

                if(event.type == 'click' && megaMouse == 'hover') // dont interfere with clicks on hover menus
                    return;

                if(event.type == 'mouseenter' && megaMouse == 'click') // ignore hovers on click megas
                    return;

                //pause a little to allow for the hide function to hide stuff
                setTimeout(() => { //() => { fun method to pass 'this' 

                    mm = jQuery("#mega-"+megaMenuTitle(jQuery(this).text()));
                    // if it has a mega menu
                    if(mm.length && !isMegaMobile())
                    {
                        // ok we're ready to do the showing
                        if(!mm.hasClass('show-mega'))
                        {
                            hideMega();
                            megaSpeed = parseInt(jQuery('[bt-mega-animate-speed]').attr('bt-mega-animate-speed') || 0); // get mega style
                            mm.addClass('show-mega').animate({opacity: 1}, megaSpeed); // show it
                            jQuery("body").trigger( "mega-menu-open" ).addClass('showing-mega-menu');

                            if(megaMouse == 'hover'){
                                //add 
                                mm.addClass('hover-mega-menu');
                                menuItem.find('a').attr('tabindex',101);
                                // previous item add meg-exit
                                prevItem = menuItem;
                                foundPrev = false;
                                // get the next row with an a or button, but not if its a megas menu div
                                while(foundPrev == false){

                                    if( prevItem.prev().find('a:visible,button:visible').last().parents('.mega-mobile-container').length)
                                    {
                                        //console.log('its in a mega menu, ignorin');
                                    }
                                    else if( (prevItem.prev().find('a:visible,button:visible').last().length) )
                                    {
                                        foundPrev = true;
                                        prevItem = prevItem.prev().find('a:visible,button:visible').last();
                                    }

                                    // move the pointer 
                                    if(!foundPrev)
                                        if(prevItem.prev().length)
                                            prevItem = prevItem.prev();
                                        else
                                            prevItem = prevItem.parent();

                                }
                                prevItem.attr('tabindex',100).addClass('meg-exit');

                            }
                            else
                                menuItem.find('a').attr('tabindex',100).addClass('meg-exit');

                            menuItem.children('a').attr('aria-expanded', 'true');// ariaaaaal

                            mm.find('a, button, input, select, textarea').attr('tabindex',101);
                            
                            nextItem = menuItem;
                            foundNext = false;
                            // get the next row with an a or button, but not if its a megas menu div
                            while(foundNext == false){

                                if( nextItem.next().find('a:visible,button:visible').first().parents('.mega-mobile-container').length)
                                {
                                    //its in a mega menu, ignorin
                                }
                                else if( (nextItem.next().find('a:visible,button:visible').first().length) )
                                {
                                    foundNext = true;
                                    nextItem = nextItem.next().find('a:visible,button:visible').first();
                                }
                                                            // move the pointer 
                                if(!foundNext)
                                    if(nextItem.next().length)
                                        nextItem = nextItem.next();
                                    else
                                        nextItem = nextItem.parent();

                            }
                            nextItem.attr('tabindex',102).addClass('meg-exit');


                            if(menuItem.parents('[bt-mega]').attr('bt-mega-position') == 'absolute')
                            {
                                mm.addClass('mega-absolute');
                            }
                            
                            jQuery(window).trigger('resize'); //  for other code to resize themselves on show
                        }
                    }

                },20);
            });

            if(megaMouse == 'hover' )
            {
                menuItem.addClass('mega-hover');

                menuItem.on('mouseleave',function(event) {
                                        
                    if (jQuery('.mega-mobile-container:hover, .mega-hover:hover').length == 0)

                        hideMega();

                });
            }


                

            if(isMegaMobile())
            {
                megaItem.css('top',  topValue + 'px');
                topValue += megaItem.height();
            }
            else
            {
                jQuery('body').removeClass('show-mega-mobile');
                topValue = menuItem.children()[0].getBoundingClientRect().bottom; 
                if(jQuery('#wpadminbar').length)
                    topValue = topValue + jQuery("#wpadminbar").height();
                megaItem.css('top',  topValue + 'px');
            }
        }
            
    });
        
    jQuery(mobileToggle).on('click',function(event){
        event.preventDefault(); // stop the inbuilt stuff from stuffin
        event.stopPropagation();
        jQuery('body').toggleClass('show-mega-mobile');
        setTimeout(function(){
            jQuery(window).trigger('resize');
        },100);
    });

   //close mega menu stuff

    // on mouseleave of hover megas
    jQuery('body').on('mouseleave','.hover-mega-menu',function(event) {
        if (jQuery('.mega-hover:hover, .mega-mobile-container:hover ').length == 0)
            hideMega();
    });

    jQuery('.has-mega-menu a').on('keypress', function (e) { // if space bar on button click it
        if (e.keyCode === 32) { // if space
            e.preventDefault();
            jQuery(this).click(); // click it
        }
    });

    // accessibility tab out of mega
    jQuery('body').on('focus','.meg-exit',function(){
        hideMega();
    });    
    
    // escape click    
    jQuery(document).on('keyup', function(e) {
      if (e.key == "Escape" && jQuery('.showing-mega-menu').length)
      {
        var  returnFocus = jQuery(menuElement + ".focus").find('a,button').first();
        // focus on parent
        setTimeout(function(){
                returnFocus.focus();
                hideMega();
        },10);
      }
    });
    
    jQuery(document).on('click', function (e) {

        //click outside of mega menu
        if (jQuery(e.target).closest('[id^="mega-"], .mega-mobile-container').length === 0) {
            if(jQuery('body').hasClass('showing-mega-menu'))
                hideMega();
        }
        else
        {
            if (jQuery(this).attr('href')) 
            {
                var anchor = jQuery(this).attr('href').split('#').pop();
                if (jQuery("#"+anchor).length && jQuery('body').hasClass('showing-mega-menu'))
                    hideMega();
            }
        }
    
    });

    setInterval(() => {
        if (scrolling) {
            scrolling = false;
            // place the scroll handling logic here
                jQuery(window).trigger('resize');
        }
/*
        if(!isMegaMobile())
        {
            jQuery('body').removeClass('show-mega-mobile');
            if (!jQuery('.mega-absolute').length)
            {
                if(jQuery(".mega-hover, .has-mega-menu").length)
                {
                    topValue = jQuery(".mega-hover, .has-mega-menu").first()[0].getBoundingClientRect();
                    jQuery("[id*='mega-']").css('top',  topValue.bottom + 'px');
                }                
            }
        }   */
    },300);

});

// scroll handler
let scrolling = false;

window.scroll = () => {
    scrolling = true;
};

function hideMega(){
    // dont do anything if theres nothing to do
//    if(!jQuery('.showing-mega-menu').length)
  //      return;
    
    jQuery('.has-mega-menu [aria-expanded="true"]').attr('aria-expanded','false');
    jQuery('.mega-touched').removeClass('mega-touched');
    jQuery('.show-mega').css('opacity', 0).removeClass('show-mega');
    jQuery('.mega-hover').removeClass('mega-hover');
    jQuery('body').removeClass('show-mega-mobile').removeClass('showing-mega-menu');
    
    jQuery('[id^="mega-"] a, [bt-mega] a, .meg-exit').removeAttr('tabindex'); //kill tabindex on mega
    jQuery('.meg-exit').removeClass('meg-exit');
}
