<?php


// align left center right

// default width to half of row width

if(! class_exists ( 'Ss_Max_Width_Column') && class_exists('FLBuilder'))
{
  class Ss_Max_Width_Column{

    function __construct(){
      //filters
      add_filter( 'fl_builder_register_settings_form' , array($this,'add_max_width_settings'), 220 , 2 );
      add_filter( 'fl_builder_render_css' , array( $this,'bt_max_width_column_css'), 110, 3);
    }


  function add_max_width_settings( $form, $slug ) {
    if ( 'col' === $slug) {
      $form['tabs']['style']['sections']['general']['fields']['bt_stick_side'] = array(
            'type'          => 'button-group',
            'label'         => 'Max Width Column Align',
            'default'       => 'false',
            'help'          => 'Choose an alignment to activate max-width column',
            'options'       => array(
                'false'      => 'Off',
                'right'      => 'Left',
                'center'      => 'Center',
                'left'      => 'Right',
            ),
            'toggle'        => array(
              'right'      => array(
                'fields'        => array( 'bt_column_max_width'),
              ),
              'center'      => array(
                'fields'        => array( 'bt_column_max_width'),
              ),
              'left'      => array(
                'fields'        => array( 'bt_column_max_width'),
              ),
            ),
          );
      $form['tabs']['style']['sections']['general']['fields']['bt_column_max_width'] = array(
            'type'  => 'unit',
            'label' => 'Column Max Width',
            'units'          => array( 'px', 'vw', '%' , 'vh' ),
            'default_unit' => 'px', // Optional
            'default' => '600',
            'help' => 'Uses CSS calc() to create column padding to simulate max-width. Any padding you add in the advanced tab will reduce the width of your max-width column',
            'responsive'  => true,
          );
    }
    return $form;
  }

  function bt_max_width_column_css($css, $nodes, $global_settings){
    $large_breakpoint = $global_settings->large_breakpoint;
    $medium_breakpoint = $global_settings->medium_breakpoint;
    $responsive_breakpoint = $global_settings->responsive_breakpoint;
    
    $bt_mwr_css = "";
      
    foreach ( $nodes['columns'] as $column ) {
      
      $node = $column->node;
      
      if(isset($column->settings->bt_stick_side) && $column->settings->bt_stick_side != 'false')
      {
        $side = $column->settings->bt_stick_side; // its inverted, as thats how the padding will work      
        if(empty($side))
          $side = 'left';

        $padding_side =  "padding_".$side;

        $padding_unit = $column->settings->padding_unit;
        $additional_padding = 0;
        if(!empty($column->settings->{$padding_side}))
          $additional_padding = $column->settings->{$padding_side};

        if(empty($column->settings->bt_column_max_width))
        {
          $max_width = 100;
          $max_unit = '%';
        }
        else
        {
          $max_width = $column->settings->bt_column_max_width;
          $max_unit = $column->settings->bt_column_max_width_unit;
        }

        $size = $column->settings->size;
        
        if($side !== 'center'){
          $bt_mwr_css .= "@media screen and (min-width:".$responsive_breakpoint."px){
            .fl-node-$node>.fl-col-content{
              padding-$side: calc(100% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
            }
          }
          ";
        }
        else
        {
          $max_width = $max_width / 2;
          $bt_mwr_css .= "@media screen and (min-width:".$responsive_breakpoint."px){
            .fl-node-$node>.fl-col-content{
              padding-left: calc(50% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
              padding-right: calc(50% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
            }
          }
          ";
        }
        
      }
      
      if(isset($column->settings->bt_column_max_width_large) && $column->settings->bt_column_max_width_large !== '')
      {
        $side = $column->settings->bt_stick_side; // its inverted, as thats how the padding will work      

        if(empty($side) || $side == 'false')
          $side = 'left';

        $padding_side =  "padding_".$side."_large";
        
        $padding_unit = $column->settings->padding_unit;
        $additional_padding = $column->settings->{$padding_side} ?? 0;
        $max_width = $column->settings->bt_column_max_width_large;
        $max_unit = $column->settings->bt_column_max_width_large_unit;

        if($additional_padding == "")
          $additional_padding = 0;

  
        $size = $column->settings->size_large;      
        if($side !== 'center'){

          $bt_mwr_css .= "@media screen and (min-width:".$medium_breakpoint."px) and (max-width:".$large_breakpoint."px){
            .fl-node-$node>.fl-col-content{
              padding-$side: calc(100% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
            }
          }
          ";
        }
        else
        {
          $max_width = $max_width / 2;
          $bt_mwr_css .= "@media screen and (min-width:".$medium_breakpoint."px) and (max-width:".$large_breakpoint."px){
            .fl-node-$node>.fl-col-content{
              padding-left: calc(50% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
              padding-right: calc(50% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
            }
          }
          ";
        }
      }

      

      if(isset($column->settings->bt_column_max_width_medium) && $column->settings->bt_column_max_width_medium !== '')
      {
        $side = $column->settings->bt_stick_side; // its inverted, as thats how the padding will work      

        if(empty($side) || $side == 'false')
          $side = 'left';

        $padding_side =  "padding_".$side."_medium";
        
        $padding_unit = $column->settings->padding_unit;
        $additional_padding = $column->settings->{$padding_side};
        $max_width = $column->settings->bt_column_max_width_medium;
        $max_unit = $column->settings->bt_column_max_width_medium_unit;

        if($additional_padding == "")
          $additional_padding = 0;
        
        $size = $column->settings->size_medium;      
        if($side !== 'center'){

          $bt_mwr_css .= "@media screen and (min-width:".$responsive_breakpoint."px) and (max-width:".$medium_breakpoint."px){
            .fl-node-$node>.fl-col-content{
              padding-$side: calc(100% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
            }
          }
          ";
        }
        else
        {
          $max_width = $max_width / 2;
          $bt_mwr_css .= "@media screen and (min-width:".$responsive_breakpoint."px) and (max-width:".$medium_breakpoint."px){
            .fl-node-$node>.fl-col-content{
              padding-left: calc(50% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
              padding-right: calc(50% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
            }
          }
          ";
        }

      }
      
      if(isset($column->settings->bt_column_max_width_responsive) && $column->settings->bt_column_max_width_responsive !== '')
      {
        
        $side = $column->settings->bt_stick_side; // its inverted, as thats how the padding will work      
        if(empty($side)|| $side == 'false')
          $side = 'left';

        $padding_side =  "padding_".$side."_responsive";
        
        $padding_unit = $column->settings->padding_unit;
        $additional_padding = $column->settings->{$padding_side};
        $max_width = $column->settings->bt_column_max_width_responsive;
        $max_unit = $column->settings->bt_column_max_width_responsive_unit;

        if($additional_padding == "")
          $additional_padding = 0;
        
        $size = $column->settings->size_responsive;      
        
        if($side !== 'center'){
          $bt_mwr_css .= "@media screen and (max-width:".$responsive_breakpoint."px){
            .fl-node-$node>.fl-col-content{
              padding-$side: calc(100% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
            }
          }
          ";
        }
        else
        {
          $max_width = $max_width / 2;
          $bt_mwr_css .= "@media screen and (max-width:".$responsive_breakpoint."px){
            .fl-node-$node>.fl-col-content{
              padding-left: calc(50% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
              padding-right: calc(50% - ".$max_width.$max_unit." + ".$additional_padding.$padding_unit." ) !important;
            }
          }
          ";
        }
      }
    }
    return $css . $bt_mwr_css;
  }
  }
  $btsc = new Ss_Max_Width_Column();
}


