<?php


/** *
 * @link              https://sitespot.dev
 * @package           Ss_Bb_Lottie
 * 
 */
  define( 'SS_BB_LOTTIE_PRO_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
  define( 'SS_BB_LOTTIE_PRO_PLUGIN_URI', plugins_url('/', __FILE__) );


if( class_exists('FLBuilderModule')  && !class_exists('SS_BB_Lottie') ) {

  class SsBbLottieModule extends FLBuilderModule{
    
      public function __construct()
      {
        parent::__construct(array(
          'name'          => __('Lottie', 'fl-builder'),
          'description'   => __('Insert a Lottie animation.', 'fl-builder'),
          'category'		  => __('Animations', 'fl-builder'),
          'group'         => 'SiteSpot.DEV',
          'dir'           => SS_BB_LOTTIE_PRO_PLUGIN_DIR . '/',
          'url'           => SS_BB_LOTTIE_PRO_PLUGIN_URI . '/',
        ));
      }
  }

  class SS_BB_Lottie{

    function __construct(){

      add_filter( 'init' , array( $this,'register_lottie_module'), 10, 2);
      add_filter( 'fl_builder_should_refresh_on_publish', '__return_true' );

    }

    function register_lottie_module(){

      $moduleSettings = array(
        'lottie_general_tab'      => array(
          'title'         => __( 'General', 'fl_builder' ),
          'sections'      => array(
            'lottie_basic_settings'  => array(
              'title'         => __( 'Settings', 'fl-builder' ),
              'fields'        => array(
                'lottie_json_url'     => array(
                  'type'          => 'text',
                  'label'         => __( 'Input JSON URL', 'fl-builder' ),
                ),
                'lottie_play'     => array(
                  'type'    => 'button-group',
                  'label'   => 'Play Mode',
                  'default' => 'load',
                  'options' => array(
                      'load'    => 'On Load',
                      'hover'    => 'On Hover',
                  ),
                  'toggle' => array(
                    'load'      => array(
                      'fields'        => array( 'lottie_lazy'),
                    ),
                    'hover'      => array(
                      'fields' => array( 'lottie_lazy'),
                    )
                  )
                ),
                'lottie_controls'     => array(
                  'type'    => 'button-group',
                  'label'   => 'Controls',
                  'default' => 'hide',
                  'options' => array(
                      'show'    => 'Show',
                      'hide'    => 'Hide',
                  ),
                ),
                'lottie_size'     => array(
                  'type'         => 'unit',
                  'label'        => 'Width',
                  'units'          => array( 'px', 'vw', '%' ),
                  'default_unit' => 'px', // Optional
                  'responsive' => true,
                  'preview'    => array(
                    'type'          => 'css',
                    'selector'      => '.ss-bb-lottie',
                    'property'      => 'width',
                  ),
                ),
                'lottie_loop'     => array(
                  'type'    => 'button-group',
                  'label'   => 'Loop',
                  'default' => 'loop',
                  'options' => array(
                      'once'    => 'Play once',
                      'loop'    => 'Loop',
                      'bounce'    => 'Bounce',
                  ),
                ),
                'lottie_lazy'     => array(
                  'type'    => 'button-group',
                  'description'    => 'Cursor position and Scroll play modes will disable lazyload.',
                  'label'   => 'Lazy Load',
                  'default' => 'false',
                  'options' => array(
                      'false'    => 'Off',
                      'true'    => 'On',
                  ),
                ),
                'lottie_link'     => array(
                  'type'          => 'link',
                  'label'         => __('Link', 'fl-builder'),
                ),
              )
            )
          )
        )
      );
      
      // filter for pro
      FLBuilder::register_module( 'SsBbLottieModule', apply_filters( 'ss_lottie_module_settings', $moduleSettings) );
    }
  }
  $SS_BB_Lottie = new SS_BB_Lottie;

}