<?php

// pro extension for lottie

// enqueue up scripts for scroll handler

// add additional fields

// add fields as attributes

if( !class_exists('SS_BB_Lottie_Pro')  && class_exists('SS_BB_Lottie') ) {

  class SS_BB_Lottie_Pro{

    function __construct(){
      
      add_filter( 'ss_lottie_module_settings', array( $this,'lottie_pro'), 10, 2);
      add_filter( 'wp_enqueue_scripts' , array($this,'load_scripts_styles'), 20 , 2 );
    }

    function load_scripts_styles(){
      wp_enqueue_script( 'ss_lottie', plugin_dir_url( __FILE__ ) . 'js/lottie.js'); 
      wp_enqueue_script( 'ss_lottie_interactivity', plugin_dir_url( __FILE__ ).'js/lottie-interactivity.js', array('ss_lottie'));
    }

    function lottie_pro( $moduleSettings ) {

      $inserted =  array(
          'type' => 'textarea',
          'label' => 'Paste in JSON here',
          'description' => '<p>Pasting JSON here will override the JSON URL</p><p>Your JSON will be converted upon pasting in, edit elsewhere.</p>',
      );

      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields'] = ss_array_insert_after('lottie_json_url', $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields'] , 'lottie_paste_json',$inserted ); // splice in at position 3

      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields']['lottie_play']['options']['scroll'] = "Scroll";
      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields']['lottie_play']['options']['mouse'] = "Cursor Position";
      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields']['lottie_play']['toggle']['scroll'] =[
                      'fields'        => [],
                    ];
      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields']['lottie_play']['toggle']['mouse'] = [
                      'fields' => [],
                    ];
  


      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields']['lottie_mouse_direction'] = array(
        'type' => 'button-group',
        'label' => 'Mouse control direction',
        'default' => 'horizontal',
        'options' => array(
                'vertical' => 'Vertical',
                'horizontal' => 'Horizontal',
        ),
      );

      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields']['lottie_start_position'] = array(
        'type' => 'unit',
        'label' => 'Start Frame',
        'default' => '0',
        'description' => 'Start frame of animation',
      );
      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields']['lottie_end_position'] = array(
        'type' => 'unit',
        'label' => 'End Frame',
        'default' => '100',
        'description' => 'End frame of animation',
      );
  
      //add in toggles to show hide relevant sh

      $moduleSettings['lottie_general_tab']['sections']['lottie_basic_settings']['fields']['lottie_play']['toggle'] = array(
        'mouse'      => array(
          'fields'        => array( 'lottie_mouse_direction','lottie_start_position','lottie_end_position' ),
        ),
        'scroll'      => array(
          'fields'        => array( 'lottie_start_position','lottie_end_position' ),
        ),
        'load'      => array(
          'fields'        => array( 'lottie_controls', 'lottie_loop'),
        ),
        'hover'      => array(
          'fields'        => array( 'lottie_controls', 'lottie_loop'),
        ),
      );
                                  
      return $moduleSettings;
    }
  }
  $SS_BB_Lottie_Pro = new SS_BB_Lottie_Pro;

}

function ss_array_insert_after($key, array &$array, $new_key, $new_value) {
  if (array_key_exists($key, $array)) {
    $new = array();
    foreach ($array as $k => $value) {
      $new[$k] = $value;
      if ($k === $key) {
        $new[$new_key] = $new_value;
      }
    }
    return $new;
  }
  return FALSE;
}
