<?php

/**
 * $module An instance of your module class.
 * $settings The module's settings.
 *
 */


$src = "lottie-player";

$playerConfig = '';
if( $settings->lottie_play == 'load')
    $playerConfig .= " autoplay";
if( $settings->lottie_play == 'hover')
    $playerConfig .= " hover";

if( $settings->lottie_play == 'mouse' || $settings->lottie_play == 'scroll')
     $settings->lottie_lazy = false;

if($settings->lottie_mouse_direction &&  $settings->lottie_play == 'mouse')
    $playerConfig .= " bt-mouse='".$settings->lottie_mouse_direction."'";

if( $settings->lottie_loop == 'loop')
    $playerConfig .= " loop";
if( $settings->lottie_loop == 'bounce' )
    $playerConfig .= " loop mode=\"bounce\"";

if( $settings->lottie_controls == 'show')
    $playerConfig .= " controls";

if( !empty($settings->lottie_link))
    $settings->lottie_link = "<a href='".$settings->lottie_link."'>";

if( empty($settings->lottie_json_url) && empty($settings->lottie_paste_json))
    $settings->lottie_json_url = 'https://assets8.lottiefiles.com/packages/lf20_eMqO0m.json'; // preview animation div

if(!empty($settings->lottie_paste_json))
{
    //$playerConfig .= "lottieJSON='".$settings->lottie_paste_json."' ";
    $settings->lottie_json_url = ''; // remove the src so we gotta do it w js
}

if( $settings->lottie_lazy == 'true'){
    $src = "lottie-lazy";
}
if( !empty($settings->lottie_play)  && ($settings->lottie_play == 'mouse' || $settings->lottie_play == 'scroll') ){
    $src .= " data-interactive='true'";
}
if( !empty($settings->lottie_play)  &&  $settings->lottie_play == 'scroll' ){
    $src .= " data-hide-before-load='true'";
}
?>
<?php echo $settings->lottie_link; ?>
<div class="ss-bb-lottie">
<<?php echo $src; ?> id="l<?php echo $module->node; ?>" src="<?php echo $settings->lottie_json_url; ?>"  background="transparent"  speed="1"  style="width: 100%; height: auto;"  <?php echo $playerConfig; ?> ></<?php echo $src; ?>>
</div>
<?php
if( !empty($settings->lottie_link))
    echo "</a>";
?>
<style>
.fl-node-<?php echo $id;?> .ss-bb-lottie{
    width:<?php echo $settings->lottie_size . $settings->lottie_size_unit; ?>;
}
 [data-hide-before-load]{
    transition: opacity 0.1s ease-in-out;
}
body:not(.fl-builder-edit) .fl-node-<?php echo $id;?> [data-hide-before-load='true']{
    opacity: 0;
    pointer-events: none;
}
</style>

<?php
if(!empty($settings->lottie_paste_json)) // fire up the pasted json
{
?>
<script>
var l<?php echo $module->node; ?> = <?php echo urldecode($settings->lottie_paste_json); ?>;
</script>
<?php
}
?>
<script>

<?php

if( $settings->lottie_play == 'scroll' && !FLBuilderModel::is_builder_active()){
?>

    jQuery(document).ready(function($){
    if (!document.body.classList.contains('fl-builder-edit')) // if its not in BB edit mode
    {

        LottieInteractivity.create({
            mode:"scroll",
            player:'#l<?php  echo $module->node; ?>',
            actions: [
                {
                    visibility:[0,1],
                    type: "seek",
                    frames: [<?php echo $settings->lottie_start_position;?>, <?php echo $settings->lottie_end_position;?>],
                },
            ]
        });
        window.addEventListener('load', () => {
            // Dispatch a scroll event to trigger interactivity update
            window.dispatchEvent(new Event('scroll'));
            jQuery('[data-hide-before-load]').attr('data-hide-before-load', false);

        });
    }
});

<?php
}else if( $settings->lottie_play == 'mouse' && !FLBuilderModel::is_builder_active()){

?>
    //check 
    jQuery(document).ready(function($){

        if (!document.body.classList.contains('fl-builder-edit')) // if its not in BB edit mode
        {
            var mdirection = "<?php echo $settings->lottie_mouse_direction; ?>";
            //create array
            var lpos;
            if(mdirection == "vertical") // vertical
                lpos = { x: [-1, 2], y: [0, 1] };
            else // horizontal
                lpos = { x: [0, 1], y: [-1, 2] };


            LottieInteractivity.create({
                mode:"cursor",
                player:'#l<?php  echo $module->node; ?>',
                actions: [
                    {
                        position: lpos,
                        type: "seek",
                        frames: [<?php echo $settings->lottie_start_position;?>, <?php echo $settings->lottie_end_position;?>],
                    },
                    {
                        position: { x: -1, y: -1 },
                        type: 'stop',
                        frames: [<?php echo $settings->lottie_start_position;?>],
                    },
                ]
            });
        }
    });

    <?php
}?>
</script>
<?php


