<?php

if(! class_exists ( 'SS_Global_Builder_Settings'))
{

  class SS_Global_Builder_Settings{

    function __construct(){

        add_filter( 'fl_builder_register_settings_form', [$this,'add_global_tabs'], 10, 2 );
        add_filter( 'fl_builder_color_presets', [$this,'global_builder_color_presets'],1,20 );
        add_action( 'wp_footer',[$this,'global_css']);

    } // end construct

    /**
    * add to the Global Settings Options.
    */
    function add_global_tabs( $form, $id ) {

        if ( 'global' == $id ) {

          $newthings = array(
            'ss_brand' => array(
              'title'         => 'Global Colors',
              'description'   => 'Site wide colors.',
              'fields'        => array(
                'ss_primary_color' => array(
                  'type'          => 'color',
                  'label'         => __( 'Primary Color', 'fl-builder' ),
                  'default'       => 'blue',
                  'show_reset'    => true,
                  'show_alpha'    => false
                ),
                'ss_secondary_color' => array(
                  'type'          => 'color',
                  'label'         => __( 'Secondary Color', 'fl-builder' ),
                  'default'       => 'grey',
                  'show_reset'    => true,
                  'show_alpha'    => false
                ),

              )
            ),
        );

        $form['tabs']['general']['sections'] = array_merge($newthings, $form['tabs']['general']['sections']);

        }
    return $form;
    }


    function global_builder_color_presets( $colors ) {

//remove #'s


        foreach($colors as $color => $index)
        {
          if(substr( $color, 0, 1 ) === "#") // remove the # from the thing
            $colors[$index] = preg_replace("/[^a-zA-Z 0-9]+/", "", $color );
        }

        if(!empty(get_option('_fl_builder_settings')->ss_secondary_color) )
            $colors[] = get_option('_fl_builder_settings')->ss_secondary_color;

        if(!empty(get_option('_fl_builder_settings')->ss_primary_color))
            $colors[] = get_option('_fl_builder_settings')->ss_primary_color;

        return array_unique($colors);
    }

    // add as global vars and utility classes
    function global_css(){
            echo "<style id='global-colors'>
            :root {
                --brand-primary: #".primary_color_getter().";
                --brand-secondary: #".secondary_color_getter().";
            }
            .text-primary{ color:var(--brand-primary);}
            .text-secondary{ color:var(--brand-secondary);}
            .bg-primary{ background-color:var(--brand-primary);}
            .bg-secondary{ background-color:var(--brand-secondary);}
            </style>";
        }
    } //end SS_Global_Builder_Settings  

  $SS_Global_Builder_Settings = new SS_Global_Builder_Settings();

}


add_action( 'fl_page_data_add_properties', function() {

    FLPageData::add_post_property( 'br_primary', array(
        'label'   => 'Color - Primary',
        'group'   => 'general',
        'type'    => 'color',
        'getter'  => 'primary_color_getter',
    ) );
    FLPageData::add_post_property( 'br_secondary', array(
        'label'   => 'Color - Secondary',
        'group'   => 'general',
        'type'    => 'color',
        'getter'  => 'secondary_color_getter',
    ) );

} );


function primary_color_getter() {
  if(!empty(get_option('_fl_builder_settings')->ss_primary_color))
    return get_option('_fl_builder_settings')->ss_primary_color;
  return false;
}
function secondary_color_getter() {
  if(!empty(get_option('_fl_builder_settings')->ss_secondary_color))
    return get_option('_fl_builder_settings')->ss_secondary_color;
  return false;
}
