<?php



// add filters to modules, rows and columns

if(! class_exists('Bt_Filters'))
{
  class Bt_Filters{
    
    function __construct(){
      add_filter( 'fl_builder_register_settings_form' , array($this,'add_filter_settings'),99,2 ); // register settings forms 
      add_filter( 'fl_builder_render_css', array($this,'render_css'), 10, 3 ); // render css to hide the inactive test items       
      add_action( 'wp_ajax_imgfilter', array($this,'bt_pro_img_filter') ); // render filtered image
      add_action( 'wp_ajax_nopriv_imgfilter', array($this,'bt_pro_img_filter') ); // render filtered image dont think its necessary
      add_action( 'fl_builder_after_save_layout', array($this,'after_save_layout'), 10, 4 );
    }
    
    function after_save_layout( $post_id, $publish, $data, $settings ) {
      
      $upload = wp_upload_dir();
      $upload_dir = $upload['basedir'];
      $upload_dir = $upload_dir . '/bt-image-filters/';
      
      foreach($data as $node => $module)
      {
        if(isset($module->settings->bt_filters_on) && $module->settings->bt_filters_on == 'true' && $module->settings->bt_filter_1 !== '')
        {
          $nd = $module->node;
          $bg_image = $this->base64_url_encode($module->settings->bg_image_src);
          $extension = pathinfo($module->settings->bg_image_src, PATHINFO_EXTENSION);

          $filter1= $module->settings->bt_filter_1;
          $f1v1 = $module->settings->bt_input_1;
          $filter2 = $module->settings->bt_filter_2;
          $f2v1 = $module->settings->bt_input_2;
          
          $filename = $upload_dir . "$nd.$extension";
               
          
          $url = get_admin_url() . "admin-ajax.php";
          $query = "action=imgfilter&i=$bg_image&m1=$filter1&v1=$f1v1&m2=$filter2&v2=$f2v1&e=.$extension";
          
          //keep folder semi clean
          if(file_exists("$upload_dir$nd.jpeg"))
            unlink("$upload_dir$nd.jpeg");
          if(file_exists("$upload_dir$nd.jpg"))
            unlink("$upload_dir$nd.jpg");
          if(file_exists("$upload_dir$nd.png"))
            unlink("$upload_dir$nd.png");
          if(file_exists("$upload_dir$nd.gif"))
            unlink("$upload_dir$nd.gif");
          
          
          //do it with curl to avoid the 255 chars issue
          $ch = curl_init();
          $fp = fopen ($filename, 'w+');
          $ch = curl_init($url);
          curl_setopt($ch, CURLOPT_TIMEOUT, 50);
          curl_setopt($ch, CURLOPT_POST, 1);
          curl_setopt($ch, CURLOPT_POSTFIELDS, $query);
          curl_setopt($ch, CURLOPT_FILE, $fp);
          curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
          curl_setopt($ch, CURLOPT_ENCODING, "");
          curl_exec($ch);
          curl_close($ch);
          fclose($fp);

          // clear the cache, now when its re-rendered, the file will exist, and the url will be updated
          FLBuilderModel::delete_asset_cache_for_all_posts(); 
        }
      }
    }
  
    
    // add settings
  function add_filter_settings( $form, $slug ) {
    
    if($slug != 'row' && $slug != 'col')
      return $form;
    
    $filters = array(
      ''  => 'None',
      'IMG_FILTER_GAUSSIAN_BLUR'  => 'Blur',
      'IMG_FILTER_BRIGHTNESS'  => 'Brightness',
      'IMG_FILTER_CONTRAST'  => 'Contrast',
      'IMG_FILTER_GRAYSCALE'  => 'Grayscale',
      'IMG_FILTER_NEGATE'  => 'Invert',
      'IMG_FILTER_EMBOSS'   => 'Emboss',
      'IMG_FILTER_EDGEDETECT' => 'Edge Detect',
      'IMG_FILTER_PIXELATE' => 'Pixelate'
    );
    
      $form['tabs']['style']['sections']['background']['fields']['bg_type']['toggle']['photo']['sections'][] = 'bt_pro_filters';
      
      $form['tabs']['style']['sections']['bt_pro_filters'] = [
        'title' => 'Background Photo Filters',
        'fields' => [
          'bt_filters_on' => [
            'type'          => 'select',
            'label'         => __( 'Turn on Filters', 'fl-builder' ),
            'default'       => 'false',
            'options'       => array(
                'false'      => __( 'Off', 'fl-builder' ),
                'true'      => __( 'On', 'fl-builder' )
            ),
            'toggle'        => array(
                'true'      => array(
                  'fields'        => array( 
                    'bt_filter_1',
                    'bt_input_1',
                    'bt_filter_on_1',
                    'bt_filter_2',
                    'bt_input_2',
                    'bt_filter_on_2',
                   )
                 )
              )
          ],
          'bt_filter_1'  =>  [
            'type'          =>'select',
            'label'        =>  'Filter 1 Type',
            'default'      => '',
            'options'      => $filters,
          ],
          'bt_input_1'  =>  [
              'type'   => 'unit',
              'label'  => 'Amount',
              'default' => 0,
              'slider' => [
                'min'  	=> -100,
                'max'  	=> 100,
                'step' 	=> 1,
              ],
            ],
          'bt_filter_2'  =>  [
            'type'          =>'select',
            'label'        =>  'Filter 2 Type',
            'default'      => '',
            'options'      => $filters,
          ],  
          'bt_input_2'  =>  [
              'type'   => 'unit',
              'label'  => 'Amount',
              'default' => 0,
              'slider' => [
                'min'  	=> -100,
                'max'  	=> 100,
                'step' 	=> 1,
              ],
          ],
        ]
      ];
    
    return $form;
  } // end add filter settings
    
    
    function render_css( $css, $nodes, $global_settings ) {
      
      
      //check the cached filtered image folder exists - create if not 
      $ncss = ''; // new css
      $upload = wp_upload_dir();
      $upload_dir = $upload['baseurl'];     
      $upload_dir = $upload_dir . '/bt-image-filters/';
      $upload_path = $upload['basedir']. '/bt-image-filters/'; 
      if (! is_dir($upload_path)) {
         mkdir( $upload_path, 0755 );
      }
      
      
      // for the rows
      foreach ( $nodes['rows'] as $module ) {        

        //skip if its not us
        if(!isset($module->settings->bt_filters_on) || $module->settings->bt_filters_on == 'false' || $module->settings->bt_filter_1 == '')
          continue;
        
        $node = $module->node;
        $bg_image = $this->base64_url_encode($module->settings->bg_image_src);
        $extension = pathinfo($module->settings->bg_image_src, PATHINFO_EXTENSION);

        $filter1= $module->settings->bt_filter_1;
        $f1v1 = $module->settings->bt_input_1;
        $filter2 = $module->settings->bt_filter_2;
        $f2v1 = $module->settings->bt_input_2;

        $filename = $upload_dir . "$node.$extension";
        $filepath = $upload_path . "$node.$extension";
        $url = get_admin_url()."admin-ajax.php?action=imgfilter&i=$bg_image&m1=$filter1&v1=$f1v1&m2=$filter2&v2=$f2v1&e=.$extension";
        
        if(!file_exists($filepath)) // doesnt exist, render it
        {
          $ncss .=  "
          .fl-node-$node > .fl-row-content-wrap{
            background-image:url($url) !important;
          }
          ";
        } 
        else // it exists, so lets use it
        {
          $ncss .=  "
          .fl-node-$node > .fl-row-content-wrap{
            background-image:url($filename) !important;
          }
          /* always show ajax'd for BB active */
          .fl-builder-edit .fl-node-$node > .fl-row-content-wrap{
            background-image:url($url) !important;
          }
          ";
        }
      }
      return $css . $ncss;
    }// end render css

    
    //render image
    function bt_pro_img_filter() {
      
      if(!empty($_POST))
      {
        $imageId = $this->base64_url_decode($_POST['i']);
        $method = $_POST['m1'];
        $v1 =  intval($_POST['v1']);
        $m2 = $_POST['m2'];
        $v2 =  intval($_POST['v2']);
      }
      if(!empty($_GET))
      {
        $imageId = $this->base64_url_decode($_GET['i']);
        $method = $_GET['m1'];
        $v1 =  intval($_GET['v1']);
        $m2 = $_GET['m2'];
        $v2 =  intval($_GET['v2']);
      }

      $image_extension = strtolower(pathinfo($imageId, PATHINFO_EXTENSION));
      $result = explode('?',$image_extension);
      $image_extension = $result[0];
            
      $upload = wp_upload_dir();
      $upload_dir = $upload['baseurl'];     
      $upload_dir = $upload_dir . '/bt-image-filters/';
      $upload_path = $upload['basedir']. '/bt-image-filters/'; 
      if (! is_dir($upload_path)) {
         mkdir( $upload_path, 0755 );
      }
    
      $cid = explode('?',$imageId);
      $cleanid = $cid[0];
            
      if(empty($imageId) || empty($method))
      {
        wp_die();
      }

        switch ($method) {
          case "IMG_FILTER_PIXELATE":
          case "IMG_FILTER_SMOOTH":
          case "IMG_FILTER_CONTRAST":
          case "IMG_FILTER_BRIGHTNESS":
          if(!isset($v1))
          {
              wl("need 1 filter value!");
              wp_die();
          }
        }

        $im = $this->imagecreatefromfile($imageId);
      
        if(!$im)      
          wl(' imagecreatefromfile FAIL');
        
          //add filter to img
          if(imagefilter($im,constant($method),$v1))
          {
            if(!empty($m2))
            {
              if(!imagefilter($im,constant($m2),$v2))
              {
                wl('image filter TWO failed :/');
                wp_die();
              }
            }
            
            
            $ftype = image_type_to_mime_type(exif_imagetype($cleanid));
                        
            header('Content-Type: '.$ftype);
            
              switch ($image_extension) {
                case 'jpeg':
                case 'jpg':
                  imagejpeg($im, NULL);
                  break;
                case 'png':
                  imagepng($im, NULL);
                  break;
              }
            imagedestroy($im);
          }
          else
          {
            wl('image filter failed');
          }

          wp_die(); // terminate immediately and return a proper response
      
        } // end bt_pro_img_filter()


      function imagecreatefromfile( $filename ) {
        
        $image_extension = strtolower( pathinfo( $filename, PATHINFO_EXTENSION ));
        
        $result = explode('?',$image_extension);
        $image_extension = $result[0];
        
        
        switch ($image_extension ) {
            case 'jpeg':
            case 'jpg':
                return imagecreatefromjpeg($filename);
            break;

            case 'png':
                return imagecreatefrompng($filename);
            break;

            case 'gif':
                return imagecreatefromgif($filename);
            break;

            default:
              return false;
            break;
        }
    } // end imagecreatefromfile()
    
    
function base64_url_encode($input) {
 return strtr(base64_encode($input), '+/=', '._-');
}

function base64_url_decode($input) {
 return base64_decode(strtr($input, '._-', '+/='));
}

    
    
  }
  
  $btfilters = new Bt_Filters();
}


if ( ! function_exists('wl')) {
   function wl ( $log )  {
      if ( is_array( $log ) || is_object( $log ) ) {
         error_log( print_r( $log, true ) );
      } else {
         error_log( $log );
      }
   }
}
if ( ! function_exists('pr')) {

  function pr($data){
    echo "<pre>";
    print_r($data);
    echo "</pre>";
  }

}
if ( ! function_exists('mailme')) {

  function mailme($message, $title = 'mail me message')
  {
    //print_r if array
    if(is_array ($message) || is_object($message))
      $message = print_r($message,true);

    wp_mail('support@sitespot.dev',$title,$message);
  }

}



