<?php

/**
 * Beaver Team Pro Module Defaults  
 * Description: A Beaver Builder plugin that allows you to use any module as a default. applying that style to all new modules of that type.
 */

if(! class_exists ( 'Bt_Default_Modules'))
{

  class Bt_Default_Modules{

    function __construct(){

      //filters
      add_filter( 'fl_builder_settings_form_defaults' , array($this,'bt_apply_defaults'), 20 , 2 );
      
      //old skewl
      //add_filter( 'fl_builder_after_save_layout' , array( $this,'updateDefaults'),99999,2);

      //new ajax button!
      add_action( 'wp_ajax_default_module', array($this,'set_defaults') );
      add_action( 'fl_builder_ui_enqueue_scripts', [$this,'enqueue_default_module_scripts'] );
      add_action( 'wp_enqueue_scripts', [$this,'enqueue_default_module_scripts'] );
      add_filter( 'fl_builder_register_settings_form' , array($this,'register_settings_form'), 20 , 2 );
    }

    function enqueue_default_module_scripts(){
      
      if ( class_exists( 'FLBuilderModel' ) && FLBuilderModel::is_builder_active() ) { // if BB is active    
        wp_enqueue_script( 'default-module-settings', plugin_dir_url( __FILE__ ) . 'js/default-module-settings.js', array('jquery')); 
        wp_enqueue_script( 'btp-toast', SS_BEAVER_TEAM_PRO_URL . 'admin/js/toast.min.js', array('jquery')); 
      }
    }



  // ajax handler
  function set_defaults()
  {
    //print_r( $_POST);
    $moduleSettings = $_POST['settings'];
    $moduleSettings['settings']['type'] = $_POST['settings']['type']; // add dtype to the settings array
    if($this->update_defaults($moduleSettings['settings']))
    {
      echo $moduleSettings['settings']['type']." default settings updated";
    }
    else
      echo "error updating default: " . $moduleSettings['settings']['type'];

    die(); // fin

    // since $debugArray is an array, so 
    // die(json_encode($debugArray)); // last line

  }
  
    function register_settings_form($form, $slug ) {
      if ( 'module_advanced' === $slug ) {
        $form[ 'sections' ][ 'css_selectors' ][ 'fields' ][ 'bt_default_module' ] = [
          'type'    => 'raw',
          'label'   => 'Default Module',
          'content' => '<button id="set-module-default" class="fl-builder-button fl-builder-button-small">Set as Default</button><!--<a href="!" id="view-module-changes">View 3 Changes></a><div class="changes"></div>-->',
        ];
      }
      return $form;
    }


    function updateDefaults($post_id, $publish ='', $data='', $settings=''){

        $var->settings->bt_default_module = "no";
        $postData[0][$key]->settings->bt_default_module = "no";
        $updatePostMeta = true;
        //we have a default... update the defaults
        $this->update_defaults($var->settings);
        //wl("update defaults: " . $var->settings->type);        
          
    
      //remove the default module dropdown value if necessary
      if($updatePostMeta)
      {
        //update live data
        update_post_meta($post_id, "_fl_builder_data", $postData[0]); // update live data
        if(isset($draftData[0]))
          update_post_meta($post_id, "_fl_builder_draft", $draftData[0]); //update draft data
        FLBuilderModel::delete_asset_cache_for_all_posts(); // clear cache
      }
    }



    
    //requires $moduleSettings array with 'type' key to apply the default
    function update_defaults($moduleSettings){

      $bt_defaults = json_decode(json_encode(get_option("bt_defaults")), true);

      $moduleSettings = (array) json_decode(json_encode($moduleSettings), true);
      
      $moduleType = $moduleSettings['type'];

      if(!$bt_defaults)
        $bt_defaults = [];
      
      if(!isset($bt_defaults[$moduleType]))
        $bt_defaults[$moduleType] = [];
      
      if(!is_array($bt_defaults[$moduleType]))
        $bt_defaults[$moduleType] = [];
        
      $bt_defaults[$moduleType] = (object)array_merge($bt_defaults[$moduleType],$moduleSettings);

      //rebuild to correct format, hacky todo - fix this array object fiasco
      foreach($bt_defaults as $b => $a)
        $bt_defaults[$b] = (object)$bt_defaults[$b];
      
      update_option("bt_defaults",$bt_defaults);
      
      FLBuilderModel::delete_asset_cache_for_all_posts();
      
      return true; // must've worked
    }
    
    
    
    function bt_apply_defaults($defaults, $type){

      $bt_defaults = get_option("bt_defaults");
      
      //if(isset($defaults->bt_default_module)) // if its a module, we'' have the 'bt-default-module' value, otherwise its not a module we care about!
     // {
        //$defaults->bt_default_module = "no";
        
        $type = str_replace("-module","",$type);
      
        //if no defaults, then exit
        if(!isset($bt_defaults))
          return $defaults;

        if(isset($bt_defaults[$type]) && $bt_defaults[$type] !=='')
        {
          $module_defaults = $bt_defaults[$type];
          foreach($defaults as $k => $v)
          {
            if(is_array($v))
            {
              foreach($v as $a => $b)
              {
                if(is_array($b))
                {
                  foreach($b as $c => $d)
                  {
                    $defaults->{$k}[$a][$c] = (isset($module_defaults->{$k}[$a][$c]) ? $module_defaults->{$k}[$a][$c] : $defaults->{$k}[$a][$c] );
                  }
                }
                else
                {
                  $defaults->{$k}[$a] = (isset($module_defaults->{$k}[$a]) ? $module_defaults->{$k}[$a] : $defaults->{$k}[$a] );
                  //wl($defaults->{$k}[$a] . "-> " . $module_defaults->{$k}[$a]);
                }
              }
            }
            else
            {
              $defaults->{$k} = (isset($module_defaults->{$k}) ? $module_defaults->{$k} : $defaults->{$k});
              //wl($defaults->{$k} . " -- " . $module_defaults->{$k});
            }
          }
        }
      //}
      return $defaults;
    }
    
    
    // go through modules, and remove default module settings
    function clear_default_dropdown(){
      
    }
    
    
  }
  $btdm = new Bt_Default_Modules();

}








