jQuery(document).ready(function(){

  
  //todo minimize this
  if(jQuery('body').hasClass('fl-builder-edit') )
    return false;
  
  bt_cookie_check(); // check for custom display cookies
  bt_time_check();
  bt_query_check();
  
  if(jQuery("[bt_location_name]").length)
  {
    if(getConditionalCookie("bt_user_c") == undefined) // if the country isnt defined, update
      btGetLocation();
    else
      check_locations();
  }
});
  
function bt_time_check(){
    
  jQuery("[bt_time_start]").each(function(index,value){
    var time_schedule = jQuery(this).attr('bt_time_schedule');
    var timeStart = jQuery(this).attr('bt_time_start');
    var timeEnd = jQuery(this).attr('bt_time_end');
    var timeNow = Date.now()/1000;
    var bt_display_action = jQuery(this).attr('bt_display_action') ;


    if(time_schedule == 'none' || !time_schedule)
    {
      if((timeNow > timeStart) && timeNow < timeEnd )
      {
        if(bt_display_action == 'show')
          jQuery(this).show();
        else
          jQuery(this).hide();
      }  
      else
      {
        if(bt_display_action == 'hide')
          jQuery(this).show();
        else
          jQuery(this).hide();
      }
    }

    if(time_schedule == 'daily')
    {
      //need time
      timeStart = time_from_stamp(timeStart);
      timeEnd = time_from_stamp(timeEnd);

    }


    if(time_schedule == 'weekly')
    {

      //need day of week and time
      timeStart = day_of_week_from_stamp(timeStart);
      timeEnd = day_of_week_from_stamp(timeEnd);


    }

    if(time_schedule == 'monthly')
    {
      timeStart = day_of_month_from_stamp(timeStart);
      timeEnd = day_of_month_from_stamp(timeEnd);

    }

    if((timeNow > timeStart) && timeNow < timeEnd )
    {
      if(bt_display_action == 'show')
        jQuery(this).show();
      else
        jQuery(this).hide();
    }  
    else
    {
      if(bt_display_action == 'hide')
        jQuery(this).show();
      else
        jQuery(this).hide();
    }

  });
}

function time_from_stamp(timestamp){
  //get timestamp

  newTime = new Date(timestamp*1000);

  h = newTime.getHours();
  m = newTime.getMinutes();


  now = new Date();
  now.setHours(h);
  now.setHours(m);
  //convert to hours and minutes
  return Math.floor(now.getTime() / 1000)
}

function day_of_month_from_stamp(timestamp){
  //get timestamp
  newTime = new Date(timestamp*1000);
  now = new Date();

  nowDay = now.getDate();
  d = newTime.getDate(); // day of month

  now.setDate(newTime.getDate());
  now.setHours(newTime.getHours());
  now.setMinutes(newTime.getMinutes());

  //convert to hours and minutes
  return Math.floor(now.getTime() / 1000)
}


function day_of_week_from_stamp(timestamp){
  //get timestamp
  newTime = new Date(timestamp*1000);
  now = new Date();

  nowDay = now.getDay();
  d =  newTime.getDay() - nowDay; // does the day of week offset calc

  console.log('offset',d);

  now.setDate(now.getDate() + d);
  now.setHours(newTime.getHours());
  now.setMinutes(newTime.getMinutes());

  //convert to hours and minutes
  return Math.floor(now.getTime() / 1000);
}


function bt_query_check(){
  
  jQuery("[bt_url_text]").each(function(index,value){
    var urlName = jQuery(this).attr('bt_url_text');
    var urlType = jQuery(this).attr('bt_url_type');
    var urlValue = jQuery(this).attr('bt_url_value');
    var bt_display_action = jQuery(this).attr('bt_display_action') ;
    var queryMatch = false;
    
    
    if(urlType == 'exists')
      if(getParameterByName(urlName) != null)
         queryMatch = true;

    if(urlType == 'notexist')
      if(getParameterByName(urlName) == null)
        queryMatch = true;

    if(urlType == 'equals')
      if(getParameterByName(urlName) == urlValue)
        queryMatch = true;

    if(urlType == 'notequals')
      if(getParameterByName(urlName) != urlValue)
        queryMatch = true;

    if(queryMatch)
    {
      if(bt_display_action == 'show')
        jQuery(this).show();
      else
        jQuery(this).hide();
    }  
    else
    {
      if(bt_display_action == 'hide')
        jQuery(this).show();
      else
        jQuery(this).hide();
    }
  });
}

function check_locations(){



  var eu_countries = "ad,al,at,ba,be,bg,by,ch,cs,cz,de,dk,ee,es,fi,fo,fr,fx,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,se,si,sj,sk,sm,ua,va";
  var bt_user_loc = getConditionalCookie("bt_user_loc");
  var bt_user_s = getConditionalCookie("bt_user_s");
  var bt_user_c = getConditionalCookie("bt_user_c");
  var bt_user_city = getConditionalCookie("bt_user_city");
  var bt_user_timezone = getConditionalCookie("bt_user_timezone");
  var bt_user_continent = getConditionalCookie("bt_user_continent");
  var bt_user_continentCode = getConditionalCookie("bt_user_continentCode");
  var bt_user_currency = getConditionalCookie("bt_user_currency");
  var bt_user_zip = getConditionalCookie("bt_user_zip");

  
  jQuery("[bt_location_name]").each(function(index,value){
    
    var bt_location_type = bt_lc(jQuery(this).attr('bt_location_type'));
    var bt_location_condition = jQuery(this).attr('bt_location_condition');
    var bt_location_name = bt_lc(jQuery(this).attr('bt_location_name'));
    var bt_display_action = jQuery(this).attr('bt_display_action');
    var nodeId  = jQuery(this).attr('data-node');
    
    if(bt_location_type == "state")
      bt_user_loc = bt_user_s;
    if(bt_location_type == "countrycode")
      bt_user_loc = bt_user_c;
    if(bt_location_type == "city")
      bt_user_loc = bt_user_city;
    if(bt_location_type == "timezone")
      bt_user_loc = bt_user_timezone;
    if(bt_location_type == "continent")
      bt_user_loc = bt_user_continent;
    if(bt_location_type == "continentCode")
      bt_user_loc = bt_user_continentCode;
    if(bt_location_type == "currency")
      bt_user_loc = bt_user_currency;
    if(bt_location_type == "zip")
      bt_user_loc = bt_user_zip;

    //EU tweak todo APAC?  
    if((bt_location_type == "country" || bt_location_type == "countrycode") && (bt_location_name == "eu" || bt_location_name == "europe"))
    {
      bt_location_type = 'countrycode'; //force countrycode 
      bt_location_name = eu_countries;
      if(bt_location_condition == 'equals')
        bt_location_condition = 'contains'; // fix equals -> contains
      if(bt_location_condition == 'notequal')
        bt_location_condition = 'doesnotcontain'; //fix contains -> not contain
    }
    
    if(bt_display_action == 'show')
      bt_display_action = true;
    else
      bt_display_action = false;
    
    if(bt_location_condition == 'equals')
    {
      btShowElement(nodeId, bt_user_loc == bt_location_name, bt_display_action);
    }
    else if (bt_location_condition == 'notequal')
    {
      btShowElement(nodeId,  bt_user_loc != bt_location_name, bt_display_action);
    }
    else if (bt_location_condition == 'contains')
    {
      btShowElement(nodeId,  bt_location_name.indexOf(bt_user_loc) !== -1, bt_display_action);
    }
    else if (bt_location_condition == 'doesnotcontain')
    {
      btShowElement(nodeId,  bt_location_name.indexOf(bt_user_loc) == -1, bt_display_action);
    }
  });
  
}

function bt_cookie_check(){
    
  jQuery("[bt_cookie_name]").each(function(index,value){
    
    var bt_cookie_name = bt_lc(jQuery(this).attr('bt_cookie_name'));
    var bt_cookie_relationship = jQuery(this).attr('bt_cookie_relationship');
    var bt_cookie_value = bt_lc(jQuery(this).attr('bt_cookie_value'));
    var bt_display_action = jQuery(this).attr('bt_display_action');
    var nodeId  = jQuery(this).attr('data-node');
    
    // empty handler
    if(!bt_cookie_value)
      bt_cookie_value = "";
    else
      bt_cookie_value = bt_lc(bt_cookie_value);
        
    var visitor_cookie_value = bt_lc(getConditionalCookie(bt_cookie_name));
    
    if(bt_display_action == 'show')
      bt_display_action = true;
    else
      bt_display_action = false;
    
    if(bt_cookie_relationship == 'equals')
    {
      btShowElement(nodeId, visitor_cookie_value == bt_cookie_value, bt_display_action);
    }
    else if (bt_cookie_relationship == 'notequal')
    {
      btShowElement(nodeId,  visitor_cookie_value != bt_cookie_value, bt_display_action);
    }
    else if (bt_cookie_relationship == 'contains')
    {
      btShowElement(nodeId,  bt_cookie_value.indexOf(visitor_cookie_value) !== -1, bt_display_action);
    }
    else if (bt_cookie_relationship == 'doesnotcontain')
    {
      btShowElement(nodeId,  bt_cookie_value.indexOf(visitor_cookie_value) == -1, bt_display_action);
    }
    else if (bt_cookie_relationship == 'exists')
    {
      btShowElement(nodeId,  visitor_cookie_value !== null , bt_display_action);
    }
    else if (bt_cookie_relationship == 'doesnotexist')
    {
      btShowElement(nodeId,  visitor_cookie_value == null, bt_display_action);
    }
  });
}

function bt_lc(text)
{
  if(text == null)
    return text;
  if(text !== '')
    return text.toLowerCase();
  return text;
}

function btShowElement(node, result, show ){
  
  if(result === true)
  {
    if(show === true)
      jQuery('.fl-node-'+node).show();
    else
      jQuery('.fl-node-'+node).hide();
  }
  else
  {
    if(show === true)
      jQuery('.fl-node-'+node).hide();
    else
      jQuery('.fl-node-'+node).show();
  }
}


/*
    'country'      => __( 'Country Name', 'btbb' ),
    'countrycode'      => __( 'Country Code', 'btbb' ),
    'state'      => __( 'State / Province / Region', 'btbb' ),
    'city'      => __( 'City', 'btbb' ),
    'timezone'      => __( 'Timezone', 'btbb' ),
    'continent'      => __( 'Continent', 'btbb' ),
    'continentCode'      => __( 'Continent Code', 'btbb' ),
    'currency'      => __( 'Currency', 'btbb' ),
  */

function btGetLocation(){
  //get the users location with JS

  var ipURL = "aHR0cHM6Ly9wcm8uaXAtYXBpLmNvbS9qc29uP2ZpZWxkcz1zdGF0dXMsbWVzc2FnZSxjb250aW5lbnQsY29udGluZW50Q29kZSxjb3VudHJ5LGNvdW50cnlDb2RlLHJlZ2lvbixyZWdpb25OYW1lLGNpdHksemlwLHRpbWV6b25lLGN1cnJlbmN5JmtleT1CSmZ3UG5GVGFNQTRId0o=";
  jQuery.ajax({
    url: atob(ipURL),
    jsonpCallback: "callback",
    crossDomain: true,
    dataType: "jsonp",        
    success: function( location ) {
      createCookie('bt_user_loc',bt_lc(location.countryCode),4);
      createCookie('bt_user_c',bt_lc(location.country),4);
      createCookie('bt_user_s',bt_lc(location.region),4);
      createCookie('bt_user_city',bt_lc(location.city),4);
      createCookie('bt_user_timezone',bt_lc(location.timezone),4);
      createCookie('bt_user_continent',bt_lc(location.continent),4);
      createCookie('bt_user_continentCode',bt_lc(location.continentCode),4);
      createCookie('bt_user_currency',bt_lc(location.currency),4);
      createCookie('bt_user_zip',bt_lc(location.zip),4);
      check_locations();
    },
    error: function( error ) {
      console.log('bt location error');
      console.log(error.message);
    }
  });
}


// Cookies
function createCookie(name, value, hours) {
  var expires = "";                 
  if (hours) {
    var date = new Date();
    date.setTime(date.getTime() + (hours * 60 * 60 * 1000));
    expires = "; expires=" + date.toGMTString();
  }
  
  document.cookie = name + "=" + value + expires + "; path=/";
}

function getConditionalCookie(c_name) {
    var i, x, y, ARRcookies = document.cookie.split(';');
    for (i = 0; i < ARRcookies.length; i++) {
        x = ARRcookies[i].substr(0, ARRcookies[i].indexOf('='));
        y = ARRcookies[i].substr(ARRcookies[i].indexOf('=') + 1);
        x = x.replace(/^\s+|\s+$/g, '');
        if (x == c_name) {
            return decodeURI(y);
        }
    }
}


function getParameterByName(name, url) {
    if (!url) url = window.location.href;
    name = name.replace(/[\[\]]/g, '\\$&');
    var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, ' '));
}
