<?php

// add actions
//add_action( 'customize_save_after', 'bt_pro_color_sync_after_customizer_save' );
add_action( 'customize_controls_print_footer_scripts','bt_pro_color_sync_customizer_colors');
add_action( 'admin_enqueue_scripts', 'bt_pro_color_sync_admin_sync' );




//uses filter 'bt_color_sync_in_admin' to include on all admin pages if 
function bt_pro_color_sync_admin_sync() {
  $bt_color_sync_in_admin =  apply_filters('bt_color_sync_in_admin', false);
  if($bt_color_sync_in_admin)
    bt_pro_color_sync_customizer_colors();
}

           
function bt_pro_color_sync_customizer_colors(){
	
	$presetColors = get_option('_fl_builder_color_presets'); //get presets
  
	if(empty($presetColors))
		return;

  foreach($presetColors as $k => $c)
  {
    $presetColors[$k] = fixRgba($c);
  }
  
  $presetColors = array_unique($presetColors);
  
  foreach($presetColors as $k => $v)
  {
    if (bt_contains("rgb", $v) || bt_contains("hsv", $v) || bt_contains("#", $v))
    {
      $presetColors[$k] = "'$v'";      
    }
    else
    {
      $presetColors[$k] = "'#$v'";
    }
  }
  
	$colorPresets = "<script>var bt_bb_color_presets = ["; //setup
	$colorPresets .= implode(",",$presetColors);	 // add colors
	$colorPresets .= "];";
	$colorPresets .= "</script>"; // shut er down
  
	echo $colorPresets;
};

function bt_contains($needle, $haystack)
{
    return strpos($haystack, $needle) !== false;
}


function fixRgba($c){
  $o = $c;
  if(substr( $c, 0, 4 ) == 'rgba')
  {
    $c = str_replace("rgba(","",$c);
    $c = str_replace(")","",$c);
    
    $rgba = explode(",",$c);
    $r = $rgba[0];
    $g = $rgba[1];
    $b = $rgba[2];
    
    $c = fromRGB($r,$g,$b);
  }
  return $c;
}


function fromRGB($R, $G, $B)
{

    $R = dechex($R);
    if (strlen($R)<2)
    $R = '0'.$R;

    $G = dechex($G);
    if (strlen($G)<2)
    $G = '0'.$G;

    $B = dechex($B);
    if (strlen($B)<2)
    $B = '0'.$B;

    return $R . $G . $B;
}





function bt_pro_color_palettes() {
    if(wp_script_is('wp-color-picker', 'enqueued'))
    {
      
      $presetColors = get_option('_fl_builder_color_presets'); //get presets

      if(isset($presetColors) && !empty($presetColors))
      {

        foreach($presetColors as $k => $c)
        {
          $presetColors[$k] = fixRgba($c);
        }

        $presetColors = array_unique($presetColors);

        foreach($presetColors as $k => $v)
        {
          if (bt_contains("rgb", $v))
          {
            $presetColors[$k] = "'$v'";      
          }
          else if(bt_contains("#", $v))
          {
            $presetColors[$k] = "'$v'";      
          }
          else
          {
            $presetColors[$k] = "'#$v'";
          }
        }

        $colorPresets = "<script> var bt_bb_color_presets = ["; //setup
        $colorPresets .= implode(",",$presetColors);	 // add colors
        $colorPresets .= "];";
        $colorPresets .= "</script>"; 



      ?>
          <script  type="text/javascript">
              jQuery(document).ready(function(){

                if(typeof bt_bb_color_presets == 'undefined')
                  return;

                if(bt_bb_color_presets.length >0)
                {
                  jQuery.wp.wpColorPicker.prototype.options = {
                      palettes: bt_bb_color_presets
                  };
                }
              });
          </script>
      <?php
      }
    }
}
add_action('admin_footer', 'bt_pro_color_palettes');
add_action('customize_controls_print_scripts', 'bt_pro_color_palettes');


/*  one way SUPPORT FOR AASTRA */

function bt_pro_color_sync_astra_color_palettes($palettes) {

      $presetColors = get_option('_fl_builder_color_presets'); //get presets

      if(isset($presetColors) && !empty($presetColors))
      {
        return $presetColors;        
      }

      return $palettes;
}

add_filter( 'astra_color_palettes', 'bt_pro_color_sync_astra_color_palettes' );



/*   SUPPORT FOR AASTRA */