<?php

// search and replace db to replace colors anywhere in BB.


include_once( plugin_dir_path(__FILE__) . 'color-replace-admin.php');  

function bt_update_colors_manager($old_color, $new_color, $post_types){

  if(!bt_has_permission()) // dont load user facing modules without permission
    return;

  $updatedSettings = 0;
  
  //check they are colors. hex only for now.
  if(!(check_color_is_hex($old_color) && check_color_is_hex($new_color)))
    return "Those inputs dont look right, please input the hex color code you want to replace and the replacement color. e.g. #F0F0F0";
  
  if(isset($old_color) && isset($new_color) && isset($post_types))
  {
    
    $post_types_array = explode(',',$post_types);
    
    if(empty($post_types_array))
      $post_types_array = array('page','post','fl-builder-template');
    
    //we've got colors, do the update
    //todo add post types
    
    // get all BB posts
    $args = array(
      'post_type' => $post_types_array,
      'meta_query' => array(
        array(
          'key' => '_fl_builder_enabled',
          'value' => 1,
          'compare' => '=',
        )
      ),
      'suppress_filters' => true,
      'posts_per_page' => -1
    );

    $query = new WP_Query($args);

    $posts = $query->posts;
    //loop through posts
    if ( $query->have_posts() )
    {
      while ( $query->have_posts() )
      {
        $query->the_post();
        $updatedSettings += bulk_update_colors($old_color, $new_color, get_the_ID());
      }
    }
  }
  return $updatedSettings;
}



function bulk_update_colors($old_color, $new_color, $post_id){
  
  //strip hashtag #yolo
  $old_color = strtolower(trim(str_replace('#','',$old_color)));
  $new_color = strtolower(trim(str_replace('#','',$new_color)));

  //pr("color update: old color: $old_color, new color:  $new_color, post id: $post_id");
  $updated_colors = 0;
  
  //get builder data
  $builderData['_fl_builder_data'] = get_post_meta($post_id,"_fl_builder_data");
  
  //get the drafts to if they exist
  if(get_post_meta($post_id,"_fl_builder_draft") !== null) // if they exist
    $builderData['_fl_builder_draft'] = get_post_meta($post_id,"_fl_builder_draft"); // add to the array  
  
  //pr($builderData);
  
  foreach($builderData as $k => $v)
  {
    $newBuilderData = $v;
    foreach($newBuilderData[0] as $module_key => $module_data)
    {
      //skip if the settings array is empty
      if(empty($module_data->settings))
        continue;
      
      foreach($module_data->settings as $module_settings_key => $module_settings_value)
      {
        if(is_array($module_settings_value))
        {          
          //do sub array stuffs
          foreach($module_settings_value as $sub_settings_key => $sub_settings_var)
          {
            if(is_array($sub_settings_var))
            {
              foreach($module_settings_value as $sub_sub_settings_key => $sub_sub_settings_var)
              {
                if($sub_sub_settings_var === $old_color)
                {
                  $newBuilderData[0][$module_key]->settings->$module_settings_key[$sub_settings_key][$sub_sub_settings_key] = $new_color;
                  $updated_colors++;
                }
              }
            }
            else if($sub_settings_var === $old_color)
            {
              $newBuilderData[0][$module_key]->settings->$module_settings_key[$sub_settings_key] = $new_color;
              $updated_colors++;
              //wl("Pretend updated color on post ID: " . $post_id . ", type: " . $module_data->type . ", module setting: " . $module_settings_key . ", oldcolor: " . $module_settings_value );
            }
            
          }
          
        }
        else
        {
          if($module_settings_value === $old_color)
          {
            $newBuilderData[0][$module_key]->settings->$module_settings_key = $new_color;
            $updated_colors++;
            //wl("Pretend updated color on post ID: " . $post_id . ", type: " . $module_data->type . ", module setting: " . $module_settings_key . ", oldcolor: " . $module_settings_value );
          }
        }
      }
    }
    update_post_meta($post_id,$k,$newBuilderData[0]); // save changes... drafts to drafts, live as live
  }
  
  FLBuilderModel::delete_asset_cache_for_all_posts(); // clear bb cache 
  
  return $updated_colors;
}


function check_color_is_hex($color){
  if(preg_match('/^#[a-f0-9]{6}$/i', $color))
  {
      return true;
  }
  else if(preg_match('/^[a-f0-9]{6}$/i', $color)) //hex color is valid
  {
      return true;
  }
  return false;
}

