<?php


add_action( 'admin_menu', 'bt_add_admin_menu' );


function bt_add_admin_menu(  ) { 

  if(!bt_has_permission()) // dont load user facing modules without permission
    return;

	add_management_page( 'Page Builder Bulk Color Update', 'Page Builder Bulk Color Update', 'manage_options', 'page_builder_color_update', 'bt_options_page' );

}


function bt_options_page(  ) {  
  
  if(!bt_has_permission()) // dont load user facing modules without permission
    return;

  if (isset($_POST['oldcolor']) && isset($_POST['newcolor']) && isset($_POST['post_types']))
  {
    //get the post types, remove spaces etc;
    $post_types = preg_replace('/\s*/m','',sanitize_text_field($_POST['post_types']));    
    $old_color = trim(sanitize_text_field($_POST['oldcolor']));
    $new_color = trim(sanitize_text_field($_POST['newcolor']));
    $response = bt_update_colors_manager($old_color, $new_color, $post_types);
    if(is_int($response))
      $message = $response . " color settings updated.";
    else
      $message = $response;
  }
  elseif(!isset($_POST['oldcolor']) && !isset($_POST['newcolor']))
  {
    $message = false;
  }
  else
  {
    $message = "Those inputs dont look right, please input the hex color code you want to replace and the replacement color.";
  }
  
  $post_types = 'page,post,fl-builder-layout,fl-theme-layout';
  //todo add themer conditional
  
	?>
	<form id="bt-color-replace-form" method='post'>
		<h2>Page Builder Bulk Color Update</h2>
    <P>
      Input the color you want to replace, with the new color below. Make sure you take a backup first, as there is no undo!
    </P>
    <p>
      Currently only accepts HEX colors, rgba coming soon.
    </p>
    <?php 
    if($message){
      echo "<p><strong>$message</strong></p>";
    }
    ?>
    <hr>
    <p>
      <label for="post_types">Post Types</label>
      <input type="text" name="post_types" value="<?php echo $post_types;?>" placeholder="<?php echo $post_types;?>" class="regular-text">
      <BR>
        <small>comma separated values. <a class="see_post_types"> Click to see your post types</a></small>
        <div class="post_types_list">
          <ul>
            <?php

            foreach(get_post_types() as $pt)
            {
              echo "<li>$pt</li>";
            }
            ?>
          </ul>
        </div>
    </p>
    <p>
      <label for="oldcolor">Existing color to be replaced</label>
      <input type="text" name="oldcolor" placeholder="#C0FFEE" class="regular-text">
    </p>
    <p>
      <label for="oldcolor">New color</label>
     <input type="text" name="newcolor" placeholder="#BADA55" class="regular-text">
    </p>
    <p>
      <input type="submit" name="submit" value="Replace colors" class="button-primary">
    </p>
	</form>
<script>
jQuery(document).ready(function(){  
  jQuery('.see_post_types').click(function(){
    jQuery('.post_types_list').fadeToggle();
  });
});
</script>
<style>
  
  .see_post_types:hover{
    cursor:pointer;
    text-decoration:underline;
  }
  .post_types_list{
    display:none;
    max-width:800px;
  }  
  .post_types_list li{
    display: inline-block;
    padding: 4px 8px;
    background: white;
    border: thin solid #d6d6d6;
    margin: 2px;
    border-radius: 3px;
  }

#bt-color-replace-form label {
    font-weight: 700;
    line-height: 1.5;
    padding-bottom: .5em;
    display: block;
}
</style>
	<?php

}
