/* 

called on builder end

sends postid to WP, responds with beaver builder draft meta

loops through draft meta to find changes

//check inside arrays

create options to update. with json again

*/

var bt_updates = {}, bt_update_node_id;

jQuery(document).ready(function(){
  //jQuery('body').on('click','.fl-builder-update-existing-button',btGetChanges);
  jQuery('body').on('click','.bt-update-all-label-button', bt_update_all_label);
  jQuery('body').on('click','.fl-builder-bt-update-all', bt_update_all_button);
  jQuery('body').on('click','.fl-builder-bt-update-all-cancel', bt_cancel_update_all);
  
  jQuery('body').on('change','.bt-setting-name', bt_update_setting_filter_dropdown_change);
  jQuery('body').on('change','#update-area', bt_update_condtional_dropdown);
  
  jQuery('body').on('click','.fl-lightbox-content button',function(){
    //bt_update_all_modules(jQuery(this).attr('data.module'), jQuery(this).attr('data.key'), jQuery(this).attr('data.childkey'),  jQuery(this).attr('data.value'),this);
    //jQuery(this).text(updated_modules + " modules updated");
  });
  
  if(window.FLBuilder)
    FLBuilder.addHook('didShowLightbox', bt_show_bulk_update_setting);
});


function bt_update_setting_filter_dropdown_change(){

  if(jQuery('.bt-setting-name').val() != '')
  {
    jQuery('.bt-condition-value').parents('tr').show();
    jQuery('.bt-where-conditions-type').parents('tr').show();
  }
  else
  {
    jQuery('.bt-where-conditions-type').parents('tr').hide();    
    jQuery('.bt-condition-value').parents('tr').hide();    
  }
}

function bt_update_condtional_dropdown(){
  val = jQuery('#update-area').val();
  jQuery('.bt-area-value').closest('tr').hide();
    
  if(val == 'post-type')
    jQuery('.bt-area-value').closest('tr').show();
  else if(val == 'post-slug')
    jQuery('.bt-area-value').closest('tr').show();
}

//show the small 'update all' text that opens lightbox

function bt_show_bulk_update_setting(){
  
  var excludedLightboxPages = ["Save Module", "Global Settings", "Layout CSS / Javascript", "SCSS"];
  
  setTimeout(function(){//pause to allow render
    var lightboxTitle = jQuery('.fl-lightbox-header h1').text().trim();
    if( !excludedLightboxPages.includes(lightboxTitle) )
    {
      jQuery('.bt-update-all-label-button').remove();
      jQuery('.fl-builder-settings-section-content label').not('#fl-field-bt_default_module .fl-field-label, #fl-field-id .fl-field-label, .fl-dimension-field-unit label').append("<a class='bt-update-all-label-button' href='#'>Update All</a>");

      //settings without labels, i mean really?
      //jQuery('.fl-typography-field-shadow').append("<a class='bt-update-all-label-button' href='#'>Update All</a>");
    }
  },2000);
}



function bt_update_all_label(e){

  e.preventDefault();
  
  var form      = jQuery( '.fl-builder-settings-lightbox .fl-builder-settings' );
  var nodeId    = form.attr( 'data-node' );
  //console.log('nid ' + nodeId);
  var settings  = FLBuilder._getSettings( form );
  
  bt_updates = {};
  bt_update_node_id = nodeId;

  var module = jQuery(this).closest('form.fl-builder-settings').attr('data-form-id');
  var moduleId = jQuery(this).closest('tr').attr('id').replace("fl-field-", "");
  
  var compoundField = jQuery(this).parent().parent().hasClass('fl-compound-field-setting');
  var isResponsive = jQuery(this).siblings('i.fl-field-responsive-toggle').length !== 0;
  var dataType = jQuery(this).closest('tr').attr('data-type');
  var responsiveSelector = false;
  

  
  jQuery(this).closest('.fl-compound-field-setting, tr').find('input:visible, select:visible, textarea:visible, input[type=hidden]').each(function(){
    
    if(jQuery(this).hasClass('fl-field-connection-value')) // skip if its a field connection
      return true; // skip if its a field connection
    
    //get the aray keys
    var elementName = jQuery(this).attr('name').split(/\]|\[/g);    
    
    //remove the blanks in the array
    elementName = elementName.filter(n => n); 

    //merge those arrays
    if(elementName.length == 3)
    {
      var1 = elementName[0];
      var2 = elementName[1];
      var3 = elementName[2];
      bt_updates[var1] = bt_updates[var1] || {}; 
      bt_updates[var1][var2] = bt_updates[var1][var2] || {}; 
      bt_updates[var1][var2][var3] = bt_updates[var1][var2][var3] || {}; 
      
      bt_updates[var1][var2][var3] = settings[var1][var2][var3];
    }
    else if(elementName.length == 2)
    {
      var1 = elementName[0];
      var2 = elementName[1];
      bt_updates[var1] = bt_updates[var1] || {}; 
      bt_updates[var1][var2] = bt_updates[var1][var2] || {}; 
      
      bt_updates[var1][var2] = settings[var1][var2];
    }
    else if(elementName.length == 1)
    {
      var1 = elementName[0];
      bt_updates[var1] = bt_updates[var1] || {}; 
      
      bt_updates[var1] = settings[var1];
    }
  });  
  
  
    
  
  var dims = ['_left','_right','_top','_bottom'];
  
  //bt_updates[moduleId] = settings[moduleId];
  
  jQuery('.fl-builder-settings-save').click();
  
  if(dataType == 'photo')
  {
    bt_updates['photo'] = settings['photo'];
    bt_updates['photo_src'] = settings['photo_src'];
  }
  
  if(false)
  {
    jQuery(this).parent().parent().parent().find('input, select').each(function(){
      console.log(jQuery(this).attr('name'));
    });
    /*
    jQuery.each(bt_updates, function( ui, uv ){
        bt_updates[ui+"_medium"] = settings[ui+"_medium"];
        bt_updates[ui+"_responsive"] = settings[ui+"_responsive"];
    });
    */
  }
  
  if(false)//compoundField)
  {
    jQuery(this).parent().parent().find('input, select').each(function(){
      console.log(jQuery(this).attr('name'));
      console.log(jQuery(this).attr('value'));
      console.log( jQuery(this).attr('name').replace("/\[\]/g",".").replace("/\[/g","").replace("/\]/g","")  );
      
    });
  }
  
  
  console.log("final bt_updates");
  console.log(bt_updates);
  
  var lightboxcontent = [];
  
  lightboxcontent.push('<h1 module="'+module +'">Update All: ' + module + '</h1></div></div>');
  
  jQuery.each(bt_updates, function(i, v){
    if(typeof v === 'object')
    {
      jQuery.each(v, function(a, b){
        if(typeof b === 'object')
        {
          jQuery.each(b, function(c, d){
           lightboxcontent.push("<span class='bt-update-setting-list-item'>" + i + " | " + a + " | " + c + " = " + d + "</span>");
          });
        }
        else
        {
          lightboxcontent.push("<span class='bt-update-setting-list-item'>" + i + " | " + a + " = " + b + "</span>");
        }
        
      });
    }
    else
    {
      lightboxcontent.push("<span class='bt-update-setting-list-item'>" + i + " = " + v + "</span>");
    }
  });

  lightboxcontent.push('<label for="update-area">Update Area</label> <select name="update-area" id="update-area"><option value="all" selected>Entire Website</option><option value="post-type">Post Type</option> <option value="post-slug">Page Slug</option><option value="this-page" selected>This Page</option> <option value="this-row">This Row</option> <option value="this-column">This Column</option> <option value="this-child-column">This Child Column</option> </select>');
  lightboxcontent.push('<label>Value</label> <input class="bt-area-value" name="bt-area-value" type="text" placeholder="">');

  lightboxcontent.push(updateConditions());
  lightboxcontent.push(whereConditions());

  if((typeof bt_is_defaults_active !== 'undefined') && (bt_is_defaults_active === true))
  {
    lightboxcontent.push('<label><input type="checkbox" name="set-as-default" id="set-as-default" value="true"> Set as default</label>');    
  }
  
  lightboxcontent.push(saveButtons());
  
  
  //save draft for us to reload after doing our thing
  FLBuilder.ajax( {
    action          : 'save_settings',
    node_id         : nodeId,
    settings        : settings
  }, function(){ // on succesful settings save

    bt_update_node_id = nodeId;
    
    showLightBox(lightboxcontent);
    
    //add in options for dropdown settings type
    jQuery.each( settings,function(key, val){
      if(key !== 'bt_default_module' && key !== 'class' && key !== 'id')
        jQuery('select.bt-setting-name').append('<option value="'+key+'">' + key + '</option>');
    });
    jQuery('select.bt-setting-name').prepend('<option value="" selected>-------</option><option value="class">Class</option><option value="id">ID</option>');
    
    bt_update_condtional_dropdown();
    bt_update_setting_filter_dropdown_change();
    FLBuilder.hideAjaxLoader();

  });
  
}


function showLightBox(lightboxcontent){
  
  var output = '';
  
  jQuery.each(lightboxcontent, function( index, value ) {
    
    if(index === 0)
    {//header
      output += "<div class='fl-lightbox-header-wrap'><div class='fl-lightbox-header'><tr><th>" + value + "</th></tr></div></div><div class='fl-lightbox-content-wrap'><div class='fl-builder-settings-fields fl-nanoscroller has-scrollbar'><table class='fl-form-table fl-builder-settings-fields bt-update-settings'><tbody>";
    }
    else
    {
      output += "<tr><td>" + value + "</tr></td>";
    }
    
  });
  
  output += "</tbody></div>";
  
  FLBuilder._showLightbox();
  FLBuilder._setLightboxContent(output);
  
}

function updateConditions(){
// <label>Conditions</label><select class="bt-where-conditions-dropdown" ><option value="all">-----</option> <option value="module-setting">Module Setting</option> </select> </td></tr><tr><td>
  return '<label>Setting slug</label> <select class="bt-setting-name" name="bt-setting-name" placeholder="Setting"></select>';  

}

function whereConditions(){  
// area condition label
  return '<label>Where</label><select class="bt-where-conditions-type" ><option value="equals">Equals</option><!-- <option value="notequals">Does Not Equal</option> <option value="contains">Contains</option> <option value="doesnotcontain">Does Not Contain</option>--> </select></td></tr><tr><td><label>Value</label> <input class="bt-condition-value" name="bt-condition-value" type="text" placeholder="">';

}

function saveButtons(){  

  return '<div class="fl-lightbox-footer"><button class="fl-builder-bt-update-all fl-builder-button fl-builder-button-large" href="javascript:void(0);" onclick="return false;">Update All</button><button class="fl-builder-bt-update-all-cancel fl-builder-button fl-builder-button-large" href="javascript:void(0);" onclick="return false;">Cancel</button></div>';

}


function bt_update_all_button(){
  //fired on click of do update all button
  
  var module = jQuery('.fl-lightbox-header h1').attr('module');
  var nodeId = bt_update_node_id;
  var condition = jQuery('.bt-where-conditions-dropdown').val();
  var settingName = jQuery('.bt-setting-name').val();
  var settingValue = jQuery('.bt-condition-value').val();
  var settingWhereCondition = jQuery('.bt-where-conditions-type').val();
  var areaValue = jQuery('.bt-area-value').val();
  var updateArea = jQuery('#update-area').val();
  var setAsDefault = jQuery('#set-as-default').is(":checked").toString();

  if((updateArea == 'this-row') || (updateArea == 'this-column') || (updateArea == 'this-child-column') ){
    areaValue = getModuleIdList(nodeId,updateArea);
    //console.log(areaValue);
  }
  
  var updateData = {
    'action': 'bt_update_module',
    'module'  : module, 	
    'moduleId'  : nodeId, 	
    'changes'  : bt_updates, 	
    'areaValue'  : areaValue,
    'settingName' : settingName,
    'settingWhereCondition' : settingWhereCondition,
    'settingValue' : settingValue,
    'updateArea' : updateArea,
    'setAsDefault' : setAsDefault
  };

  send_update(updateData).then(
    function(value) {
      value = JSON.parse(value);
      console.log(value);
      bt_toast(value.modulesUpdated + " modules updated, refreshing the page.");

      FLBuilder.ajax({
        action: "render_layout"
      }, bt_bu_layoutRendered);      
    }
  );
}


function getModuleIdList(nodeId,updateArea){

  if(updateArea == 'this-row')
    areaValue = jQuery('.fl-node-'+nodeId).parents('.fl-row').find('.fl-module, .fl-col');
  if(updateArea == 'this-column')
  {
      var parentCol = jQuery('.fl-node-'+nodeId).parents('.fl-col').last(); // get higherst fl-col
      if(!parentCol.length) // if no higher, then it is it
        parentCol = jQuery('.fl-node-'+nodeId);
    areaValue = parentCol.find('.fl-module, .fl-col').add(parentCol);
  }
  if(updateArea == 'this-child-column')
    areaValue = jQuery('.fl-node-'+nodeId).parents('.fl-col-group-nested').find('.fl-col, .fl-module');

  return areaValue.map(function(){
    return jQuery(this).attr("data-node");
  }).get().toString();

}

function bt_cancel_update_all(){
  //fired on click of the update all cancel button
  FLBuilder._lightbox.close();
}



async function send_update(updateData){
  //console.log('send update');
  
  var updateRequest = jQuery.ajax({
    url: ajaxurl,
    type: "POST",
    data: updateData
  });

return updateRequest;

}



/*
bt_update_all_modules(data);

returns number of modules updated (int)

  var data = {
    'action': 'bt_update_module',
    'module'  : module, 	
    'changes'  : changes, 	
    'condition'  : condition, 	
    'where' : whereCondition,
    'areaValue'  : areaValue,
    'settingName' : settingName,
    'updateArea' : updateArea,
    'setAsDefault' : setAsDefault
  }
  */
function bt_update_all_modules(updateData){
  
  //console.log(updateData);

  var updateRequest = jQuery.ajax({
    url: ajaxurl,
    type: "POST",
    data: updateData
});

  updateRequest.success = function(data, textStatus, jqXHR){
      
      var responseData = JSON.parse(data);
      
      bt_toast(responseData.modulesUpdated + " modules updated");
      //console.info(responseData);

      FLBuilderSettingsConfig.nodes = responseData.settings;
      return responseData.settings;
    };
    updateRequest.error =  function(jqXHR, textStatus, errorThrown) {
        // report error
      console.error(jqXHR);
      console.error(textStatus);
      console.error(errorThrown);

      bt_toast(textStatus + ". Check the JS console for more info.");      

      return false;
    } // end error

}

  
function bt_bu_layoutRendered(data){
  FLBuilder._lightbox.close();
  FLBuilder.hideAjaxLoader();
  FLBuilder._renderLayout(data);
  //console.log(JSON.parse(data));
}

function bt_toast(toast){
  iqwerty.toast.toast(toast);
}