<?php
if(! class_exists ( 'Bt_Bulk_Updates'))
{

  class Bt_Bulk_Updates{
    
    function __construct(){

          //add actions
          add_action( 'wp_enqueue_scripts', [$this,'enqueue_update_all_scripts'] );
          add_action( 'fl_builder_ui_enqueue_scripts', [$this,'enqueue_update_all_scripts'] );
          add_action( 'wp_ajax_bt_changes', [$this,'bt_getChanges'] );
          add_action( 'wp_ajax_bt_update_module', [$this,'bt_update_module'] );
          add_action( 'fl_builder_ui_enqueue_scripts', [$this,'enqueue_update_all_scripts'] );

        }

    function enqueue_update_all_scripts(){

      if(!bt_has_permission())
        return; //exit without correct permissions
      
      
      if ( class_exists( 'FLBuilderModel' ) && FLBuilderModel::is_builder_active() ) { // if BB is active    
        wp_enqueue_script( 'bt-update-all', plugin_dir_url( __FILE__ ) . 'js/bulk-updates.js', array('jquery'),time()); 
        wp_enqueue_script( 'btp-toast', SS_BEAVER_TEAM_PRO_URL . 'admin/js/toast.min.js', array('jquery')); 
        wp_enqueue_style( 'bt-modal', plugin_dir_url( __FILE__ ) . 'css/bulk-updates.css'); 
            
        $developerSettings = get_option('bt_developer_settings');
        if($developerSettings['bt-default-modules-enabled'] == 1 && !wp_doing_ajax())
        {
          echo "<script>
    var bt_is_defaults_active = true;
    </script>";
        }
      }
    }
    

    //need to enqueue update-all js when on module template
    //wp ajax to return builder draft data
    /*

        {
        'action': 'bt_update_module',
        'module'  : module, 	
        'moduleId'  : nodeId, 	
        'changes'  : bt_updates, 	
        'condition'  : condition,
        'areaValue'  : conditionValue,
        'settingName' : settingName,
        'where' : whereCondition,
        'settingValue' : settingValue,
        'updateArea' : updateArea,
        'setAsDefault' : setAsDefault
      }
      */

    function bt_update_module(){
      // exit if module isnt set

      //wl($_POST);

      if((!isset($_POST['module']) && !isset($_POST['row']) && !isset($_POST['column']) ) || !bt_has_permission()) // ONLY ALLOW ROWS COLS AND MODULES
      {
        echo "0";
        wp_die();
      }
      
      $changes = $_POST['changes'];
      $module = $_POST['module'];
      $moduleId = $_POST['moduleId'];
      $settingName = $_POST['settingName'];
      $settingWhereCondition = $_POST['settingWhereCondition']; // = != etc
      $settingValue = $_POST['settingValue'];

      $updateArea = $_POST['updateArea'];
      $areaValue = trim($_POST['areaValue']);
      
      $setAsDefault = $_POST['setAsDefault'] == "true";

      $modulesUpdated = 0;
      
      $bt_options = get_option( 'bt_developer_settings');
      
      // post types to edit
      if($updateArea == "post-type" && !empty($areaValue))
      {
        $post_types = array_map('trim', explode(',', $areaValue));
      }
      elseif(isset($bt_options['bt-update-all-post-types']))
      {
        $post_types = explode(',',$bt_options['bt-update-all-post-types']);
      }
      else
      {
        $post_types = array('page');
      }

      // get all BB posts
      $args = array(
        'post_type' => $post_types,
        'meta_query' => array(
          array(
            'key' => '_fl_builder_enabled',
            'value' => 1,
            'compare' => '=',
          )
        ),
        'suppress_filters' => true,
        'posts_per_page' => -1
      );
      
      $url     = wp_get_referer();
      $post_id = url_to_postid( $url );

      // only get current page if thats where we are working.
      if($updateArea == 'this-page' || $updateArea == 'this-row' || $updateArea == 'this-column' || $updateArea == 'this-child-column')
      {
        $args['p'] = $post_id;
      }

      if($updateArea == 'this-row' || $updateArea == 'this-column' || $updateArea == 'this-child-column')
      {
        $updateModules  = explode(",",$areaValue);
      }
      
      wl('args');
      wl($args);

      $query = new WP_Query($args);
      $posts = $query->posts;
      wl($posts);
      //loop through posts  
      if ( $query->have_posts() )
      {
              wl('333');

        while ( $query->have_posts() )
        {
          $query->the_post();
          $updatePostId = get_the_ID();
          $slug = get_post_field( 'post_name', $updatePostId );
          
          // if post type doesnt match then skip
          if($updateArea == "post-type" && (get_post_type() !== trim($areaValue)) ) {
            continue;
          }
          
          // if slug doesnt match, continue
          if( $updateArea == "post-slug" &&  ($slug !== trim($areaValue) ) )
          {
            continue;
          }

          //    Get the data
          $builderData['_fl_builder_data'] = get_post_meta($updatePostId,"_fl_builder_data");
          wl($builderData);
          //do it for the drafts too if they exist
          $draftData = get_post_meta($updatePostId,"_fl_builder_draft");
          if(!empty($draftData)) // if they exist
            $builderData['_fl_builder_draft'] = $draftData; // add to the array

          foreach($builderData as $k => $v)
          {
            $newBuilderData = $v[0];

            foreach($newBuilderData as $currentModuleId => $obj)
            {
              if(($obj->type == "module" && $obj->settings->type == $module)  || ($obj->type == "row" && $module == "row")  || ($obj->type == "column" && $module == "col")  || ($obj->type == "column-group" && $module == "col"))
              {
                // skip if settings dont match
                if(!empty($settingName))
                {
                  if($obj->settings->$settingName !== $settingValue)
                  {
                    continue; // skip this item
                  }
                }
                
                //skip if not in  column / row
                if(!empty($updateModules))
                {
                  if(!in_array($currentModuleId,$updateModules))
                    continue; //skip
                }

                $modulesUpdated++;
          //    all is well, merge the settings
                $obj->settings = (object)array_replace_recursive((array)$obj->settings, (array)$changes);
                $newBuilderData[$currentModuleId]->settings = $obj->settings;

              } // end if correct module
            } // end  foreach module

            //save the updates
            update_post_meta($updatePostId,$k,$newBuilderData); // save changes... drafts to drafts, live as live
            
          }
          $builderData = [];
        }// end of while loop
      wl('zzzz');

//        FLBuilderModel::delete_asset_cache_for_all_posts(); // clear bb cache
        
      }
      
      // ##############
      // set as default (as long as its not a row, for now)
      // ##############
      if($setAsDefault && !($module == "row") && !($module == "col"))
      {
        //create the object to send to the default adder
        $updatedDefaults = new stdClass();
        foreach($changes as $c => $v)
        {
          $updatedDefaults->{$c} = $v;
        }
        $updatedDefaults->type = $module;
                
        $btdm = new Bt_Default_Modules();
        $btdm->update_defaults($updatedDefaults);
        
      }
      
      //generate settings config to return
      $nodeSettings = array();
      
      foreach(get_post_meta($post_id,"_fl_builder_draft")[0] as $k => $v)
      {
        $nodeSettings[$k] = $v->settings;
      }
      
      $response = array('success'=> true,
                      'settings' => $nodeSettings,
                      'modulesUpdated' => $modulesUpdated);
      
      FLBuilderModel::delete_asset_cache_for_all_posts(); // clear bb cache
      
      echo json_encode($response);
      
      wp_reset_postdata();
      
      wp_die();
    }
  }
  $btdm = new Bt_Bulk_Updates();
}

