<?php


if(! class_exists ( 'Bt_Border_Radius'))
{

  class Bt_Border_Radius{

    function __construct() {
      
      //filters
      add_filter( 'fl_builder_register_settings_form' , array($this,'register_settings_form'), 20 , 2 );
      add_filter( 'fl_builder_render_css' , array( $this,'bt_border_radius_css'), 10,4);
    }


    function register_settings_form(){

      if ( 'row' === $slug || 'col' === $slug) {
        $form['tabs']['style']['sections']['border_radius'] = array(
          'title' => 'Rounded Corners',
          'fields' => array(
            'bt_border_radius' => array(
              'type'  => 'unit',
              'label' => 'Border Radius',
              'default' => '0',
              'description' => 'px'
            )
          )
        );
      }
      return $form;
    }



    //render the CSS for the 

    function bt_border_radius_css($css, $nodes, $global_settings){

      $bt_br_css = "";

      foreach ( $nodes['rows'] as $row ) {

        if($row->settings->bt_border_radius !== "0")
        {
          $radius = $row->settings->bt_border_radius;
          $node = $row->node;
          $bt_br_css .= ".fl-node-$node>.fl-row-content-wrap{
            border-radius: ".$radius."px;
          }
          ";
        }
      }

      foreach ( $nodes['columns'] as $column ) {
        if($column->settings->bt_border_radius !== "0")
        {
          $radius = $column->settings->bt_border_radius;
          $node = $column->node;
          $bt_br_css .= ".fl-node-$node>.fl-col-content{
            border-radius: ".$radius."px;
          }
          ";
        }
      }

      return $css . $bt_br_css;

    }
    
  }
  
}

