<?php
/**
 * NOW IN CORE
 * Version: 1.4
 * License: GNU General Public License v2.0
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

if(! class_exists ( 'FL_Cache_Buster'))
{

  class FL_Cache_Buster {
    public static function init() {
      add_action( 'upgrader_process_complete',           array( __class__, 'clear_caches' ) );
      add_action( 'fl_builder_after_save_layout',        array( __class__, 'clear_caches' ) );
      add_action( 'fl_builder_after_save_user_template', array( __class__, 'clear_caches' ) );
      add_action( 'fl_builder_cache_cleared',            array( __class__, 'clear_caches' ) );
      add_action( 'bt_pro_clear_cache',                  array( __class__, 'clear_caches' ) );
      add_action( 'template_redirect',                   array( __class__, 'donotcache' ) );
      
    }

    /**
     * Clear the various cache plugins.
     * @since 1.0
     */
    public static function clear_caches() {
      //rocket cache
      if ( function_exists( 'rocket_clean_domain' ) ) {
        rocket_clean_domain();
      }
      // wp-super-cache
      if ( function_exists( 'wp_cache_clear_cache' ) ) {
        wp_cache_clear_cache();
      }
      // WPEngine
      if ( class_exists( 'WpeCommon' ) ) {
        WpeCommon::purge_memcached();
        WpeCommon::clear_maxcdn_cache();
        WpeCommon::purge_varnish_cache();
      }
      // w3 total crash
      if ( function_exists( 'w3tc_pgcache_flush' ) ) {
        w3tc_pgcache_flush();
      }
      // siteground
      if ( function_exists( 'sg_cachepress_purge_cache' ) ) {
        sg_cachepress_purge_cache();
      }
      // varnish
      @wp_remote_request( get_site_url(), array( 'method' => 'BAN' ) );
      // LiteSpeed
      if( class_exists( 'LiteSpeed_Cache_API' ) ) {
        LiteSpeed_Cache_API::purge_all();
      }
      // Cache Enabler
      if( class_exists( 'Cache_Enabler' ) ) {
        Cache_Enabler::clear_total_cache();
      }
      // Pagely
      if ( class_exists( 'PagelyCachePurge' ) ) {
        PagelyCachePurge::purgeAll();
      }
      // wp fastest cache
      if( class_exists( 'WpFastestCache' ) ) {
        global $wp_fastest_cache;
        $wp_fastest_cache->deleteCache( true );
      }
      // autoptimize
      if( class_exists( 'autoptimizeCache' ) ) {
        autoptimizeCache::clearall();
      }
      //comet cache (formerly zencache)
      if( class_exists( 'comet_cache' ) ) {
        comet_cache::clear();
      }
      wl( 'Cleared Caches' );
    }
    /**
     * Set DONOTCACHEPAGE if builder is active.
     * @since 1.0
     */
    public static function donotcache() {
      if ( ! defined( 'DONOTCACHEPAGE' )
        && class_exists( 'FLBuilderModel' )
        && FLBuilderModel::is_builder_active() ) {
          define( 'DONOTCACHEPAGE', true );
      }
    }    
  }
  FL_Cache_Buster::init();
}