<?php


// AI AI AI AI 
if(! class_exists ( 'Bt_Ai'))
{

  class Bt_Ai{
    
    function __construct(){

          //add actions
          add_action( 'wp_enqueue_scripts', [$this,'enqueue_update_all_scripts'] );
          add_action( 'fl_builder_ui_enqueue_scripts', [$this,'enqueue_update_all_scripts'] );

        }

    function enqueue_update_all_scripts(){

      if(!bt_has_permission())
        return; //exit without correct permissions
            
      if ( class_exists( 'FLBuilderModel' ) && FLBuilderModel::is_builder_active() ) { // if BB is active    
        wp_enqueue_script( 'btai', SS_BEAVER_TEAM_PRO_URL . 'includes/ai/ai.js', array('jquery')); 
        wp_enqueue_style( 'btai', SS_BEAVER_TEAM_PRO_URL . 'includes/ai/btai.css');      
      }
    }
  }

  $btai = new Bt_Ai();
}

// Add the AJAX action to handle the API request
add_action('wp_ajax_bt_ai_string', 'send_to_openai_bt_ai_string');

function send_to_openai_bt_ai_string() {
    // Get the input text from the request
    $suggestions = isset($_POST['suggestions']) ? $_POST['suggestions'] : false;
    $text = isset($_POST['text']) ? $_POST['text'] : false;

    // Send the request to the OpenAI API
    $response = bt_send_request_to_openai($text,$suggestions);

    // Return the result as JSON
    wp_send_json($response);
    wp_die();
}

function bt_send_request_to_openai($text,$prompts) {
    $developerSettings = get_option( 'bt_developer_settings');

    $api_key = trim($developerSettings['bt-ai-key']);
    if(empty($api_key))
      return array('error' => 'no api key');
    if(empty($text))
      return array('error' => 'Please provide text to rewrite');
      
    $url = 'https://api.openai.com/v1/chat/completions'; 

    //messages array of arrays.
    $messages = [];
    //set $temperature with a filter 
    $temperature = apply_filters('bt_ai_temperature', 1);

    $responses = 5;

    $messages[] = 
    [
    "role" => "user", 
    "content" => "You are a website conversion optimization specialist. You are trained to rewrite strings of text to make them more compelling and improve conversions. Please read the text and think of a way to be more compelling. This text is usually a heading, button, link, paragraph text or similar. It is never code.  When you answer, please only output the rewritten text, do not include introductory text, prefixes, suffixes or quotation marks",
    ];
    if(!empty($prompts))
        $messages[] = 
        [
        "role" => "user", 
        "content" => "Also, when rewriting, please make it: " . $prompts,
        ];
    $messages[] = 
    [
    "role" => "assistant", 
    "content" => "Please enter your text and i will provide a single rewrite to make it more compelling.",
    ];
    $messages[] = 
    [
    "role" => "user", 
    "content" => $text,
    ];

    // add filter to messages array 
    $model = $developerSettings['bt-ai-model'] ?? 'gpt-4';

    $request_body = array(
        'model'=>$model,
        'messages' => $messages,
        'temperature' => $temperature,
        'n' =>$responses,
    );
    $args = array(
        'method' => 'POST',
        'timeout'     => 60, // a long time
        'headers' => array(
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $api_key
        ),
        'body' => json_encode($request_body)
    );

    $response = wp_remote_post($url, $args);
  wl($response);
    if (is_wp_error($response)) {
        return array('error' => $response->get_error_message());
    }

    return json_decode(wp_remote_retrieve_body($response), true);
}


