<?php

/**
 *
 * @link              https://sitespot.dev
 * @package           Bt_Pro
 *
 * Plugin Name:       Beaver Team Pro
 * Plugin URI:        https://sitespot.dev/downloads/beaver-team-pro/
 * Description:       The Beaver Builder power user plugin, to help you increase dev speed, and reduce boring work.
 * Version:           1.4.13
 * Author:            SiteSpot Dev
 * Author URI:        https://sitespot.dev
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       bt-pro
 * Domain Path:       /languages
 * 
 */

require 'admin/licence.php';

define( 'SS_BEAVER_TEAM_PRO_VERSION', '1.4.13' );
define( 'SS_BEAVER_TEAM_PRO_STORE_URL', 'https://sitespot.dev' );
define( 'SS_BEAVER_TEAM_PRO_ITEM_ID', 128214 );
define( 'SS_BEAVER_TEAM_PRO_ITEM_NAME', 'Beaver Team Pro' );
define( 'SS_BEAVER_TEAM_PRO_DIR', plugin_dir_path( __FILE__ ) );
define( 'SS_BEAVER_TEAM_PRO_URL', plugin_dir_url( __FILE__ ) );

if( !class_exists( 'SS_SL_Plugin_Updater' ) ) {
	include( dirname( __FILE__ ) . '/SS_SL_Plugin_Updater.php' );
}

// init licence checker on admin pages
add_action( 'admin_init', function (){
    $license_key = bt_pro_licence_key();
  	$edd_updater = new SS_SL_Plugin_Updater( SS_BEAVER_TEAM_PRO_STORE_URL, __FILE__,
		array(
			'version' => SS_BEAVER_TEAM_PRO_VERSION,   // current version number
			'license' => $license_key,                      // license key 
			'item_id' => SS_BEAVER_TEAM_PRO_ITEM_ID,   // ID of the product
			'author'  => 'SiteSpot.DEV',                    // author of this plugin
			'beta'    => false,
		)
	);
});

//always show notices
add_action('network_admin_notices', 'bt_pro_admin_notice');
add_action( 'admin_notices', 'bt_pro_admin_notice');
// activation hook
register_activation_hook( __FILE__, 'bt_pro_activate');
// on deactivate
register_deactivation_hook( __FILE__, 'bt_pro_deactivation');

// only useful stuff is beaver builder is active.
if ( class_exists( 'FLBuilder' ) ) {
  // include dependancies
  if(is_admin()){
    include_once( plugin_dir_path(__FILE__) . 'admin/bt-pro-admin.php');
    // admin hooks
    add_action('fl_builder_admin_settings_nav_items','bt_add_developer_menu_item');
    add_action('fl_builder_admin_settings_render_forms','bt_add_developer_settings_form');
    add_action('fl_builder_admin_settings_save', 'bt_admin_settings_save');
  }
  // define public hooks
  add_action( 'after_setup_theme', 'bt_load_modules'); // load modules as necessary
}

 /* Shows an admin notice if the builder isn't active */
function bt_pro_admin_notice() {
  $message = null;
    
  if ( ! is_admin() ) {
    return;
  } elseif ( ! is_user_logged_in() ) {
    return;
  } elseif ( ! current_user_can( 'update_core' ) ) {
    return;
  }

  if ( ! class_exists( 'FLBuilder' ) ) {
    $url = admin_url( 'plugins.php' );
    $message = "The Beaver Builder plugin must be active in order to use Beaver Team Pro. Please <a href='$url'>activate it</a> before continuing.";
    echo '<div class="error bt-pro-error">';
    echo '<p>' . $message. '</p>';
    echo '</div>';
  }
  
  $licence = bt_pro_get_licence();
  
  if((int)$licence->active == 0)
  {
    if(is_multisite())
      $url = network_admin_url( 'settings.php?page=fl-builder-multisite-settings#developer');
    else
      $url = admin_url('options-general.php?page=fl-builder-settings#developer');

    $message = "Enable automatic updates to Beaver Team Pro by <a href='$url'>adding your licence key.</a>";
    echo '<div class="error bt-pro-error">';
    echo '<p>' . $message. '</p>';
    echo '</div>';
  }
}


//load modules as necessary
function bt_load_modules(){
    
  $developerSettings = bt_pro_settings();
  
  if($developerSettings['bt-auto-cache-clear'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/auto-cache-clear/auto-cache-clear.php');
  
  if($developerSettings['bt-update-all-enabled'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/bulk-updates/bulk-updates.php');
  
  if($developerSettings['bt-default-modules-enabled'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/default-module-settings/default-module-settings.php');
  
  if($developerSettings['bt-color-sync-enabled'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/color-sync/color-sync.php');
  
  if($developerSettings['bt-responsive-background-images'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/responsive-background-images/responsive-background-images.php');
  
  if($developerSettings['bt-svg-backgrounds'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/svg-backgrounds/svg-backgrounds.php');
  
  if($developerSettings['bt-sticky-column'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/sticky-column/sticky-column.php');
  
  if($developerSettings['bt-conditional-elements'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/conditional-elements/conditional-elements.php');
  
  if($developerSettings['bt-notes'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/notes/notes.php');
  
  if($developerSettings['bt-border-radius'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/border-radius/border-radius.php');
  
  if($developerSettings['bt-color-replace'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/color-replace/color-replace.php');
  
  if($developerSettings['bt-read-time'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/read-time/read-time.php');
  
  if($developerSettings['bt-bg-filters'] == 1 )
    include_once(plugin_dir_path(__FILE__) . 'includes/filters/filters.php');
  
  if($developerSettings['bt-template-jumper'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/template-jumper/template-jumper.php');
  
  if($developerSettings['bt-z-index'] == 1 )
    include_once(plugin_dir_path(__FILE__) . 'includes/z-index-pro/z-index-pro.php');

  if($developerSettings['bt-scss'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/scss/scss.php');

  if($developerSettings['bt-class-id-autocomplete'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/class-id-autocomplete/class-id-autocomplete.php');

  if($developerSettings['bt-mega-menu'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/mega-menu/mega-menu.php');
    
  if($developerSettings['max-width-column'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/max-width-column/max-width-column.php');

  if($developerSettings['bt-unlimited-editor-width'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/unlimited-editor-width/unlimited-editor-width.php');

  if($developerSettings['bt-bb-shortcut'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/bb-shortcut/bb-shortcut.php');

  if($developerSettings['globals'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/globals/globals.php');

  if($developerSettings['default-template'] !== '')
    include_once(plugin_dir_path(__FILE__) . 'includes/default-template/default-template.php');

  if($developerSettings['new-tab-preview'] == 1)
    include_once(plugin_dir_path(__FILE__) . 'includes/new-tab-preview/new-tab-preview.php');

  if($developerSettings['bt-ai-enabled'] == 1 && !empty($developerSettings['bt-ai-key']))
    include_once(plugin_dir_path(__FILE__) . 'includes/ai/ai.php');

  if($developerSettings['bt-lottie'] == 1){
    include_once(plugin_dir_path(__FILE__) . 'includes/lottie/ss-bb-lottie.php');
    include_once(plugin_dir_path(__FILE__) . 'includes/lottie/lottie-pro.php');
  }

  // set filters
  if($developerSettings['bt-disable-inline-enabled'] == 1)
    add_filter( 'fl_inline_editing_enabled', '__return_false' );
  
  if($developerSettings['bt-disable-notifications'] == 1)
    add_filter ('fl_disable_notifications', '__return_true' );

}

function bt_pro_activate() {
  
  $bt_defaultSettings = bt_defaults();
  
  // Activation code here...
  $developerSettings = get_option( 'bt_developer_settings');

  if( empty($developerSettings) ) // if the settings havnt been previously set
  {
    update_option( 'bt_developer_settings', $bt_defaultSettings);
  }
}

function bt_pro_deactivation() {
  //todo clear options;
}


function bt_has_permission(){
  $developerSettings = get_option('bt_developer_settings');
  $hasPermission = false;
  
  if(isset($developerSettings['bt-capabilities']) && $developerSettings['bt-capabilities'] != "")
  {
    $hasPermission = current_user_can($developerSettings['bt-capabilities']);
    return $hasPermission;
  }
  else
  {
    return true;
  }
}


function bt_pro_settings(){
  
  //get defaults
  $bt_defaultSettings = bt_defaults();
  
  //mnerge with saved settings
  if( is_array( get_option( 'bt_developer_settings',true) ) )
    $developerSettings = array_merge($bt_defaultSettings,get_option( 'bt_developer_settings',true)); //merge defauts with saved preferences
  else
    $developerSettings = $bt_defaultSettings;

  return $developerSettings;
  
}

function bt_defaults(){

  return array(
    'bt-disable-inline-enabled' => '0',
    'bt-disable-notifications'=>'0',
    'bt-update-all-enabled'=>'0',
    'bt-update-all-post-types'=>'post,page,fl-builder-template',
    'bt-default-modules-enabled'=>'0',
    'bt-color-sync-enabled'=>'0',
    'bt-responsive-background-images'=>'0',
    'bt-svg-backgrounds'=>'0',
    'bt-conditional-elements'=>'0',
    'bt-auto-cache-clear'=>'0',
    'bt-simple-templates'=>'0',
    'bt-color-replace'=>'0',
    'bt-sticky-column'=>'0',
    'bt-capabilities'=>'',
    'bt-notes'=>'0',
    'bt-notes-tooltip'=>'0',
    'bt-notes-restrict-editing'=>'0',
    'bt-notes-restrict-viewing'=>'0',
    'bt-border-radius'=>'0',
    'bt-read-time'=>'0',
    'bt-licence'=>'',
    'bt-show-beta'=>'0',
    'bt-bg-filters'=>'0',
    'bt-template-jumper'=>'0',
    'bt-template-jumper-default'=>'#00A0D2',
    'bt-template-jumper-nested'=>'#16DB93',
    'bt-template-jumper-template'=>'#03256C',
    'bt-template-jumper-global'=>'#ff9600',
    'bt-z-index'=>0,
    'bt-ai-enabled'=>0,
    'bt-ai-key'=>'',
    'bt-ai-model'=>'gpt-4',
    'bt-scss'=>0,
    'bt-lottie'=>0,
    'bt-class-id-autocomplete'=>0,
    'bt-mega-menu'=>0,
    'bt-unlimited-editor-width'=>0,
    'bt-bb-shortcut'=>0,
    'max-width-column'=>0,
    'default-template'=>'',
    'new-tab-preview' => 0,
    'globals'=>0,
  );
}