<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://sitespot.dev
 * @since      1.0.0
 *
 * @package    Bt_Pro
 * @subpackage Bt_Pro/admin/partials
 */

// quick and easy resets 
if(isset($_GET['bt_action']) && is_admin())
{
  if($_GET['bt_action'] == "clear_defaults")
  {
    delete_option("bt_defaults");
      ?>
      <div class="updated notice">
        <p>Defaults Cleared.... Please wait - Reloading page</p>
      </div>
      <script>
        //remove the clear defaults from the URL in case of refreshio and to avoid bookmarkio gross, but it works
        location.replace("/wp-admin/options-general.php?page=fl-builder-settings#developer");
      </script>
      <style>
        #fl-developer-form{
          opacity:0.4 !important;
        }
      </style>
    <?php
  }
}

$licence = bt_pro_get_licence();

if($licence->active)
  $licenceStatus = '<span style="color:green">ACTIVE</span>';
elseif(!empty($licence->status))
  $licenceStatus = '<span style="color:red">ERROR: '.$licence->status.'</span>';
else
  $licenceStatus = '<span style="color:red">ERROR</span>';

$bt_defaultSettings = bt_defaults();

if(get_option( 'bt_developer_settings') !== null && is_array(get_option( 'bt_developer_settings')))
  $developerSettings = array_merge($bt_defaultSettings,get_option( 'bt_developer_settings'));
else
  $developerSettings = $bt_defaultSettings;

if(!isset($developerSettings['bt-capabilities']))
  $developerSettings['bt-capabilities'] = '';
?>

  <div id="fl-developer-form" class="fl-settings-form" style="display: none;">

	  <h3 class="fl-settings-form-header">Developer Settings</h3>

  	<form id="developer-form" autocomplete="off" action="<?php FLBuilderAdminSettings::render_form_action( 'developer' ); ?>" method="post">

		<div class="fl-settings-form-content">
      <h4>
        Licence <small>status: <?php echo $licenceStatus; ?></small> 
      </h4>
      <p>
        <input name="bt-licence" type ="password" autocomplete="off" value="<?php echo bt_pro_licence_key();?>" class="regular-text"><BR>Your licence key is available from your <a href="https://www.sitespot.dev/my-account/" target="_blank">SiteSpot.DEV account area.</a>
      </p>
      <h4>
        Developer Tools
      </h4>
			<p>
				<label>
					<input type="checkbox" name="bt-update-all-enabled" value="1" <?php echo ($developerSettings['bt-update-all-enabled'] == 1 ? 'checked' : '');?>> 
					<span>Update All</span>
				</label>
			<p showwhen="bt-update-all-enabled">
				<label>
 					<span>Update All - Post Types (separated by commas)<BR></span>
					<input type="text" class="regular-text" name="bt-update-all-post-types" value="<?php echo $developerSettings['bt-update-all-post-types'];?>"> 
				</label>
				</p>
				<div showwhen="bt-update-all-enabled">
					<small><a class="see_post_types">See all post types</a></small>
					<div class="post_types_list">
						<ul>
							<?php
							foreach(get_post_types() as $pt)
							{
								echo "<li>$pt</li>";
							}
							?>
						</ul>
					</div>
				</div>
			<p>
				<label>
					<input type="checkbox" name="bt-default-modules-enabled" value="1" <?php echo ($developerSettings['bt-default-modules-enabled'] == 1 ? 'checked' : '');?>>
					<span>Default Modules</span>
				</label>
			</p>
			<p showwhen="bt-default-modules-enabled">
         <a onclick="return confirm('Are you sure? There is no undo.')" href="/wp-admin/options-general.php?bt_action=clear_defaults&page=fl-builder-settings#developer">Clear Your Module Defaults</a>
			</p>
			<p>
				<label>
 					<span>Default template for new pages</span>
					<select id="default-template" name="default-template">
					<?php
					
					// $developerSettings['default-template'];

					$args = array(
						'posts_per_page' => -1,
						'post_type'      => 'fl-builder-template',
						'fl-builder-template-type' => 'layout',
						'post_status'    => 'publish'
					);
					$postslist = get_posts( $args );
					if(empty($postslist))
						echo '<option value="">None found</option>';
					else
						echo '<option value="">Do not add template</option>';					
					foreach($postslist as $post)
					{
						if($post->ID == $developerSettings['default-template'])
							$selected = 'selected';
						else
							$selected = '';

						echo '<option value="'.$post->ID.'" '.$selected.'>'.$post->post_title.'</option>';
					}
					?>
				</select>	
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-conditional-elements" value="1" <?php echo ($developerSettings['bt-conditional-elements'] == 1 ? 'checked' : '');?>>
					<span>Conditional Rows and Columns</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-ai-enabled" value="1" <?php echo ($developerSettings['bt-ai-enabled'] == 1 ? 'checked' : '');?>>
					<span>OpenAI</span>
				</label>
			</p>
			<p showwhen="bt-ai-enabled">
				<label>
 					<span>OpenAI Key<BR></span>
					<input type="password"  name="bt-ai-key" value="<?php echo $developerSettings['bt-ai-key'];?>"> 
				</label>

			<p>
			<p showwhen="bt-ai-enabled">
				<label>
 					<span>OpenAI Model<BR></span>
					<input type="text"  name="bt-ai-model" value="<?php echo $developerSettings['bt-ai-model'];?>"> 
				</label>

			<p>
				<label>
					<input type="checkbox" name="bt-class-id-autocomplete" value="1" <?php echo ($developerSettings['bt-class-id-autocomplete'] == 1 ? 'checked' : '');?>>
					<span>Class & ID Input Autocomplete</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-notes" value="1" <?php echo ($developerSettings['bt-notes'] == 1 ? 'checked' : '');?>>
					<span>Module Notes Extension</span>
				</label>
			</p>
			<p showwhen="bt-notes">
				<label>
					<input type="checkbox" name="bt-notes-tooltip" value="1" <?php echo ($developerSettings['bt-notes-tooltip'] == 1 ? 'checked' : '');?>>
					<span>Show Note Tooltip on Hover</span>
				</label>
			</p>
			<p showwhen="bt-notes">
				<label>
					<input type="checkbox" name="bt-notes-restrict-editing" value="1" <?php echo ($developerSettings['bt-notes-restrict-editing'] == 1 ? 'checked' : '');?>>
					<span>Only Allow Admin to edit notes</span>
				</label>
			</p>
			<p showwhen="bt-notes">
				<label>
					<input type="checkbox" name="bt-notes-restrict-viewing" value="1" <?php echo ($developerSettings['bt-notes-restrict-viewing'] == 1 ? 'checked' : '');?>>
					<span>Only Allow Admin to view notes</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-template-jumper" value="1" <?php echo ($developerSettings['bt-template-jumper'] == 1 ? 'checked' : '');?>>
					<span>Template Jumper & Builder Border Colors</span>
				</label>
			</p>
			<p showwhen="bt-template-jumper">
				<label>
					<span>Standard Border Color</span><BR>
			    <input type="text" autocomplete="za" name="bt-template-jumper-default" value="<?php echo $developerSettings['bt-template-jumper-default'];?>" class="regular-text">
				</label>
			</p>
  		<p showwhen="bt-template-jumper">
				<label>
					<span>Nested Column Border Color</span><BR>
			    <input type="text" autocomplete="za" name="bt-template-jumper-nested" value="<?php echo $developerSettings['bt-template-jumper-nested'];?>" class="regular-text">
				</label>
			</p>
  		<p showwhen="bt-template-jumper">
				<label>
					<span>Beaver Themer Layout/Part Border Color</span><BR>
			    <input type="text" autocomplete="za" name="bt-template-jumper-template" value="<?php echo $developerSettings['bt-template-jumper-template'];?>" class="regular-text">
				</label>
			</p>
  		<p showwhen="bt-template-jumper">
				<label>
					<span>Beaver Themer Global Border Color</span><BR>
			    <input type="text" autocomplete="za" name="bt-template-jumper-global" value="<?php echo $developerSettings['bt-template-jumper-global'];?>" class="regular-text">
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-bb-shortcut" value="1" <?php echo ($developerSettings['bt-bb-shortcut'] == 1 ? 'checked' : '');?>>
					<span>Beaver Builder Shortcuts "?bb" and "?bp" </span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="new-tab-preview" value="1" <?php echo ($developerSettings['new-tab-preview'] == 1 ? 'checked' : '');?>>
					<span>Beaver Builder New Tab Preview Button</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-unlimited-editor-width" value="1" <?php echo ($developerSettings['bt-unlimited-editor-width'] == 1 ? 'checked' : '');?>>
					<span>Sidebar unlimited width</span>
				</label>
			</p>
			<h4>
        Design Tools & Modules
      </h4>
			<p>
				<label>
					<input type="checkbox" name="bt-color-sync-enabled" value="1" <?php echo ($developerSettings['bt-color-sync-enabled'] == 1 ? 'checked' : '');?>>
					<span>Color Sync</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-color-replace" value="1" <?php echo ($developerSettings['bt-color-replace'] == 1 ? 'checked' : '');?>>
					<span>Bulk Color Swap</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-lottie" value="1" <?php echo ($developerSettings['bt-lottie'] == 1 ? 'checked' : '');?>>
					<span>Lottie Pro</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-mega-menu" value="1" <?php echo ($developerSettings['bt-mega-menu'] == 1 ? 'checked' : '');?>>
					<span>Mega Menu</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-svg-backgrounds" value="1" <?php echo ($developerSettings['bt-svg-backgrounds'] == 1 ? 'checked' : '');?>>
					<span>SVG backgrounds</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-sticky-column" value="1" <?php echo ($developerSettings['bt-sticky-column'] == 1 ? 'checked' : '');?>>
					<span>Sticky Columns Pro</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="max-width-column" value="1" <?php echo ($developerSettings['max-width-column'] == 1 ? 'checked' : '');?>>
					<span>Max Width Columns</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-scss" value="1" <?php echo ($developerSettings['bt-scss'] == 1 ? 'checked' : '');?>>
					<span>Smart CSS - A CSS editor with live SASS and shortcode rendering. </span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-z-index" value="1" <?php echo ($developerSettings['bt-z-index'] == 1 ? 'checked' : '');?>>
					<span>Z Index Pro</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-read-time" value="1" <?php echo ($developerSettings['bt-read-time'] == 1 ? 'checked' : '');?>>
					<span>Read Time Module</span>
				</label>
			</p>
			<h4>
        Beta Features
	</h4>
	<p>
		Almost ready for the prime-time. Please let us know if you have any issues.
	</p>
	<p>
		<label>
			<input type="checkbox" name="bt-show-beta" value="1" <?php echo ($developerSettings['bt-show-beta'] == 1 ? 'checked' : '');?>>
			<span>Show Beta Features</span>
		</label>
	</p>
	<p showwhen="bt-show-beta">
		<label>
			<input type="checkbox" name="bt-bg-filters" value="1" <?php echo ($developerSettings['bt-bg-filters'] == 1 ? 'checked' : '');?>>
			<span>Beta: Background Image Filters</span>
		</label>
	</p>
	
	<h4>
		Legacy Features
	</h4>
	<p>
		Options that are now included in BB core. If you are new here, use the inbuilt Beaver builder features instead of these.
	</p>
	<p>
		<label>
			<input type="checkbox" name="bt-show-legacy" value="1");?>
			<span>Show Legacy Options</span>
		</label>
	</p>
	<p showwhen="bt-show-legacy">
		<label>
			<input type="checkbox" name="bt-border-radius" value="1" <?php echo ($developerSettings['bt-border-radius'] == 1 ? 'checked' : '');?>>
			<span>Legacy: Border Radius <small>(Now in BB 2.2 core, no need to enable unless you have previously used this)</small></span>
		</label>
	</p>
	<p showwhen="bt-show-legacy">
		<label>
			<input type="checkbox" name="bt-responsive-background-images" value="1" <?php echo ($developerSettings['bt-responsive-background-images'] == 1 ? 'checked' : '');?>>
			<span>Legacy:  Responsive Background Images <small>(Now in BB 2.2 core, no need to enable unless you have previously used this)</small></span>
		</label>
	</p>
	<p showwhen="bt-show-legacy">
		<label>
			<input type="checkbox" name="globals" value="1" <?php echo ($developerSettings['globals'] == 1 ? 'checked' : '');?>>
			<span>Global Colors</span>
		</label>
	</p>
	<h4>
		Limit access to Developer Modules
	</h4>
	<p>
		Modules will remain active, but be hidden from users with permissions below this level. Leave blank to show to all users.
      </p>
      <p>
          See:  <a href="https://codex.wordpress.org/Roles_and_Capabilities#Capability_vs._Role_Table" target="_blank">https://codex.wordpress.org/Roles_and_Capabilities#Capabilities</a>
      </p>
      <p>
         Note: Restricts the following module access: Bulk Updates, Bulk Color Swap, Default Modules.
      </p>
			<input type="text" autocomplete="sdfgsdfg" name="bt-capabilities" value="<?php echo $developerSettings['bt-capabilities'];?>" class="regular-text">
      <h4>
        Filters
      </h4>
			<p>
				<label>
					<input type="checkbox" name="bt-disable-inline-enabled" value="1" <?php echo ($developerSettings['bt-disable-inline-enabled'] == 1 ? 'checked' : '');?>>
					<span>Disable Inline Editing</span>
				</label>
			</p>
			<p>
				<label>
					<input type="checkbox" name="bt-disable-notifications" value="1" <?php echo ($developerSettings['bt-disable-notifications'] == 1 ? 'checked' : '');?>>
					<span>Disable Beaver Builder Notifications Bell</span>
				</label>
			</p>
      

		</div>
		<p class="submit">
			<input type="submit" name="update" class="button-primary" value="Save Developer Settings">
      <?php wp_nonce_field( 'bt-developer-nonce', 'bt-developer-nonce' ); ?>
    </p>
	</form>
</div>

<script>
// show/hide post types
jQuery(document).ready(function(){  
  
  // show hide modules as needed
  btProShowSubs();
  
  // show hide modules as clicked
   jQuery('input[type=checkbox]').change(function() {
     btProShowSubs();
   });
  
  jQuery('.see_post_types').click(function(){
    jQuery('.post_types_list').fadeToggle();
  });
  
  
  
});
  
  function btProShowSubs(){
    jQuery('#developer-form input[type=checkbox]').each(function(){
        if(jQuery(this).is(":checked")) 
        {
          var moduleName = jQuery(this).attr("name");
          jQuery('[showwhen='+moduleName+']').show();
        }
        else
        {
          var moduleName = jQuery(this).attr("name");
          jQuery('[showwhen='+moduleName+']').hide();
        }
    })
    
    
  }

</script>

<style>
  
  [showwhen]{
    display: none;
    margin: 0 6px;
    border-left: 4px solid white;
    padding: 10px;
		border-top:none !important;
  }
  
  .see_post_types:hover{
    cursor:pointer;
    text-decoration:underline;
  }
  .post_types_list{
    display:none;
    max-width:800px;
  }  
  .post_types_list li{
    display: inline-block;
    padding: 4px 8px;
    background: white;
    border: thin solid #d6d6d6;
    margin: 2px;
    border-radius: 3px;
  }

#bt-color-replace-form label {
    font-weight: 700;
    line-height: 1.5;
    padding-bottom: .5em;
    display: block;
}

.fl-settings-form-content>p{
    border-top: thin solid lightgrey;
    padding-top: 5px;
}


#default-template{
	width:100%;
}
</style>

