<?php


add_action( 'in_plugin_update_message-bt-pro/bt-pro.php', 'prefix_bt_pro_update_message', 10, 2 );

//show plugin update error if necessary
function prefix_bt_pro_update_message( $currentPluginMetadata, $newPluginMetadata ) {

  if(is_network_admin() || (!is_multisite() && is_admin() )) // only show in admin, and network admin if its multisite
  {

    $message = '';
    $licenceStatus = bt_pro_get_licence();
    $licenceKey = bt_pro_licence_key();
    
    if(!isset($licenceKey) || $licenceKey == "")
    {
      $admin_url = is_multisite() ? network_admin_url('settings.php?page=fl-builder-multisite-settings#developer') : admin_url('options-general.php?page=fl-builder-settings#developer');
      $message = 'Please <a href="' . esc_url($admin_url) . '">add your licence key</a> to receive updates.';
    }
    else if((int)$licenceStatus->active != 1)
    {
      $admin_url = is_multisite() ? network_admin_url('settings.php?page=fl-builder-multisite-settings#developer') : admin_url('options-general.php?page=fl-builder-settings#developer');
      $message = $licenceStatus->error. '. Check you have<a href="' . esc_url($admin_url) . '"> entered your licence key correctly</a>, or check your subscription in the <a href="https://www.sitespot.dev/my-account/" target="_blank">SiteSpot.DEV dashboard.</a>';
    }

    // check "upgrade_notice"
    if (isset($newPluginMetadata->upgrade_notice) && strlen(trim($newPluginMetadata->upgrade_notice)) > 0 && $message !== ''){
        echo '<span style="display:block; font-weight:600; margin-top:10px;">'.$message.'</span>';
    }
  }
}


// get the licence array with status etc
function bt_pro_get_licence(){
  
  if(is_multisite())
    $licence = get_site_option( 'bt_pro_licence');
  else
    $licence = get_option( 'bt_pro_licence');  

  return $licence;
  
}

function bt_pro_licence_key(){
  
  if(is_multisite())
    $licence = get_site_option( 'bt_pro_licence_key');
  else
    $licence = get_option( 'bt_pro_licence_key');  

  return $licence;
  
}

function bt_pro_verify_licence($key,$url,$plugin,$multisite = 0){
  

  //set default status
      $status = [
        'active' => 0,
        'sites' => 0,
        'multisite' => 0,
        'status' => '',
      ];

// NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD  NEW EDD 

  		// data to send in our API request
		$api_params = array(
			'edd_action' => 'activate_license',
			'license'    => $key,
			'item_id'    => SS_BEAVER_TEAM_PRO_ITEM_ID,
			'url'        => home_url()
		);

  
		// Call the custom API.
		$response = wp_remote_post( SS_BEAVER_TEAM_PRO_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

			$message =  ( is_wp_error( $response ) && ! empty( $response->get_error_message() ) ) ? $response->get_error_message() : __( 'An error occurred, please try again.' );
      
		} 
    else 
    {

			$license_data = json_decode( wp_remote_retrieve_body( $response ) );

			if ( false === $license_data->success ) {

				switch( $license_data->error ) {

					case 'expired' :

						$message = sprintf(
							__( 'Your license key expired on %s.' ),
							date_i18n( get_option( 'date_format' ), strtotime( $license_data->expires, current_time( 'timestamp' ) ) )
						);
						break;

					case 'revoked' :

						$message = __( 'Your license key has been disabled.' );
						break;

					case 'missing' :

						$message = __( 'Invalid license.' );
						break;

					case 'invalid' :
					case 'site_inactive' :

						$message = __( 'Your license is not active for this URL.' );
						break;

					case 'item_name_mismatch' :

						$message = sprintf( __( 'This appears to be an invalid license key for %s.' ), SS_BEAVER_TEAM_PRO_ITEM_NAME );
						break;

					case 'no_activations_left':

						$message = __( 'Your license key has reached its activation limit.' );
						break;

					default :

						$message = __( 'An error occurred, please try again.' );
						break;
				}

			}
      else
      {
						$message = __( 'Active.' );
      }

		}

    $status['status'] = $message;


		//  will be either "valid" or "invalid"	
    if(!empty($license_data)){
      if($license_data->license === 'valid')
      {
        $status['active'] = 1;
        $status['sites'] = 10;
        $status['multisite'] = 1;
      }
    }

    // merge in edd response status data, because it is better
    $status = (object)array_merge( (array) $status, (array) $license_data); 

    if(is_multisite())
    {
      update_site_option('bt_pro_licence',$status);
      update_site_option('bt_pro_licence_key',$key);
    }
    else
    {
      update_option('bt_pro_licence',$status);
      update_option('bt_pro_licence_key',$key);
    }
    return (object)$status;
}








# Register a custom 'activate-bt-pro' command to output a supplied positional param.
#
# $ wp activate-bt-pro licenceKey
# Success: Beaver Team Pro activated

/**
 *
 * @when before_wp_load
 */
$activateBtPro = function( $args, $assoc_args ) {

  $licenceKey = $args[0];
  $domain = bt_pro_get_main_site_url();

  $plugin = "bt-pro";
  $multisite = is_multisite();
    
  $lstatus  = bt_pro_verify_licence($licenceKey ,$domain,$plugin,$multisite);
  
  if(!empty($lstatus))
  {
    if( $lstatus->active == 1){
      WP_CLI::log( $lstatus->status);
      WP_CLI::success( 'BT Pro on '. $domain . ' now: ' . $lstatus->status);
    }
    else
      WP_CLI::error( 'Error activating BT Pro on '. $domain . '. Status: ' . $lstatus->status , $exit = false );

  }

  FLBuilderModel::delete_asset_cache_for_all_posts();

};
if ( class_exists( 'WP_CLI' ) ) {
  WP_CLI::add_command( 'activate-bt-pro', $activateBtPro );
}

function bt_pro_get_main_site_url() {

	// This is the current network's information; 'site' is old terminology.
	global $current_site;

	if ( is_multisite() && $current_site ) {
		$main_site_blog_id = $current_site->blog_id;
		return get_home_url( $main_site_blog_id );
	}

	return home_url();
}
