<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://sitespot.dev
 * @since      1.0.0
 *
 * @package    Bt_Pro
 * @subpackage Bt_Pro/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Bt_Pro
 * @subpackage Bt_Pro/admin
 * @author     SiteSpot.DEV <support@sitespot.dev>
 */



function bt_add_developer_settings_form(){
  include_once( plugin_dir_path(__FILE__) . '/partials/bt-pro-admin-display.php');  
}

//add developer tab to bb admin

function bt_add_developer_menu_item($navitems)
{
  $navitems['developer'] = array("title"=> "Developer",
                                "show"  =>1,
                                "priority"  =>690
                                );
  return $navitems;
};


           
//handles 'save' function on beaver builder settings

function bt_admin_settings_save(){

  if ( isset( $_POST['bt-developer-nonce'] ) && wp_verify_nonce( $_POST['bt-developer-nonce'], 'bt-developer-nonce' ) ) {
        
    $settings = array();
    
    $settings['bt-disable-inline-enabled'] = (isset($_POST['bt-disable-inline-enabled'])) ? $_POST['bt-disable-inline-enabled'] : "0";
    $settings['bt-disable-notifications'] = (isset($_POST['bt-disable-notifications'])) ? $_POST['bt-disable-notifications'] : "0";
    $settings['bt-update-all-enabled'] = (isset($_POST['bt-update-all-enabled'])) ? $_POST['bt-update-all-enabled'] : "0";
    $settings['bt-update-all-post-types'] = preg_replace('/\s+/', '', sanitize_text_field($_POST['bt-update-all-post-types']));
    $settings['bt-default-modules-enabled'] = (isset($_POST['bt-default-modules-enabled'])) ? $_POST['bt-default-modules-enabled'] : "0";
    $settings['bt-color-sync-enabled'] = (isset($_POST['bt-color-sync-enabled'])) ? $_POST['bt-color-sync-enabled'] : "0";
    $settings['bt-responsive-background-images'] = (isset($_POST['bt-responsive-background-images'])) ? $_POST['bt-responsive-background-images'] : "0";
    $settings['bt-svg-backgrounds'] = (isset($_POST['bt-svg-backgrounds'])) ? $_POST['bt-svg-backgrounds'] : "0";
    $settings['bt-conditional-elements'] = (isset($_POST['bt-conditional-elements'])) ? $_POST['bt-conditional-elements'] : "0";
    $settings['bt-auto-cache-clear'] = (isset($_POST['bt-auto-cache-clear'])) ? $_POST['bt-auto-cache-clear'] : "0";
    $settings['bt-sticky-column'] = (isset($_POST['bt-sticky-column'])) ? $_POST['bt-sticky-column'] : "0";
    $settings['bt-z-index'] = (isset($_POST['bt-z-index'])) ? $_POST['bt-z-index'] : "0";
    $settings['bt-color-replace'] = (isset($_POST['bt-color-replace'])) ? $_POST['bt-color-replace'] : "0";
    $settings['bt-filters'] = (isset($_POST['bt-filters'])) ? $_POST['bt-filters'] : "0";
    $settings['bt-notes'] = (isset($_POST['bt-notes'])) ? $_POST['bt-notes'] : "0";
    $settings['bt-notes-tooltip'] = (isset($_POST['bt-notes-tooltip'])) ? $_POST['bt-notes-tooltip'] : "0";
    $settings['bt-notes-restrict-editing'] = (isset($_POST['bt-notes-restrict-editing'])) ? $_POST['bt-notes-restrict-editing'] : "0";
    $settings['bt-notes-restrict-viewing'] = (isset($_POST['bt-notes-restrict-viewing'])) ? $_POST['bt-notes-restrict-viewing'] : "0";
    $settings['bt-border-radius'] = (isset($_POST['bt-border-radius'])) ? $_POST['bt-border-radius'] : "0";
    $settings['bt-read-time'] = (isset($_POST['bt-read-time'])) ? $_POST['bt-read-time'] : "0";
    $settings['bt-capabilities'] = sanitize_text_field($_POST['bt-capabilities']);
    $settings['bt-licence'] = sanitize_text_field($_POST['bt-licence']);
    $settings['bt-template-jumper'] = (isset($_POST['bt-template-jumper'])) ? $_POST['bt-template-jumper'] : "0";
    $settings['new-tab-preview'] = (isset($_POST['new-tab-preview'])) ? $_POST['new-tab-preview'] : "0";
    $settings['bt-template-jumper-default'] = sanitize_text_field($_POST['bt-template-jumper-default']);
    $settings['bt-template-jumper-nested'] = sanitize_text_field($_POST['bt-template-jumper-nested']);
    $settings['bt-template-jumper-template'] = sanitize_text_field($_POST['bt-template-jumper-template']);
    $settings['bt-template-jumper-global'] = sanitize_text_field($_POST['bt-template-jumper-global']);
    $settings['bt-scss'] = (isset($_POST['bt-scss'])) ? $_POST['bt-scss'] : "0";
    $settings['bt-lottie'] = (isset($_POST['bt-lottie'])) ? $_POST['bt-lottie'] : "0";
    $settings['bt-class-id-autocomplete'] = (isset($_POST['bt-class-id-autocomplete'])) ? $_POST['bt-class-id-autocomplete'] : "0";
    $settings['bt-mega-menu'] = (isset($_POST['bt-mega-menu'])) ? $_POST['bt-mega-menu'] : "0";
    $settings['bt-unlimited-editor-width'] = (isset($_POST['bt-unlimited-editor-width'])) ? $_POST['bt-unlimited-editor-width'] : "0";
    $settings['bt-bb-shortcut'] = (isset($_POST['bt-bb-shortcut'])) ? $_POST['bt-bb-shortcut'] : "0";
    $settings['max-width-column'] = (isset($_POST['max-width-column'])) ? $_POST['max-width-column'] : "0";
    $settings['default-template'] = sanitize_text_field($_POST['default-template']);
    $settings['globals'] = (isset($_POST['globals'])) ? $_POST['globals'] : "0";
    $settings['bt-show-beta'] = (isset($_POST['bt-show-beta'])) ? $_POST['bt-show-beta'] : "0"; // show beta features
    $settings['bt-bg-filters'] = (isset($_POST['bt-bg-filters'])) ? $_POST['bt-bg-filters'] : "0";
    $settings['bt-ai-enabled'] = (isset($_POST['bt-ai-enabled'])) ? $_POST['bt-ai-enabled'] : "0";
    $settings['bt-ai-key'] = preg_replace('/\s+/', '', sanitize_text_field($_POST['bt-ai-key']));
    $settings['bt-ai-model'] = preg_replace('/\s+/', '', sanitize_text_field($_POST['bt-ai-model']));


    //save to db
    update_option( 'bt_developer_settings', $settings );
    
    $key = $settings['bt-licence'];
    $url = urlencode(site_url());
    $plugin = "bt-pro";
    $multisite = is_multisite();
      
    bt_pro_verify_licence($settings['bt-licence'] ,$url,$plugin,$multisite);

    FLBuilderModel::delete_asset_cache_for_all_posts();
  }

};



